/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JMCADSystemProperties {
    public static final String VERSION = "09.157";
    public static final String JMCAD_URL = "http://jmcad.sf.net";
    public static final String user_dir = System.getProperty("user.dir");
    public static final String user_home = System.getProperty("user.home");
    public static final String java_io_tmpdir = System.getProperty("java.io.tmpdir");
    public static final String jmcad_project = user_home + File.separatorChar + ".jmcad";
    public static final String jmcad_properties = user_home + File.separatorChar + ".jmcad" + File.separatorChar + "jmcad.properties";
    public static final String jmcad_examples = user_dir + File.separatorChar + "examples";
    public static final String jmcad_project_examples = jmcad_project + File.separatorChar + "examples";

    public JMCADSystemProperties() {
        System.out.println("\n*** System Property ***");
        System.out.println("Number available processors: " + Runtime.getRuntime().availableProcessors());
        System.out.println("java.vendor: \t" + System.getProperty("java.vm.vendor"));
        System.out.println("java.runtime.name: \t" + System.getProperty("java.runtime.name"));
        System.out.println("java.version: \t" + System.getProperty("java.version"));
        System.out.println("Default Localization: \t" + Locale.getDefault());
        System.out.println("file.encoding: \t" + System.getProperty("file.encoding"));
        System.out.println("sun.jnu.encoding: \t" + System.getProperty("sun.jnu.encoding"));
        System.out.println("user.country: \t" + System.getProperty("user.country"));
        System.out.println("user.language: \t" + System.getProperty("user.language"));
        System.out.println("user.dir: \t" + System.getProperty("user.dir"));
        System.out.println("user.home: \t" + System.getProperty("user.home"));
        System.out.println("os.name: \t" + System.getProperty("os.name"));
        System.out.println("os.version: \t" + System.getProperty("os.version"));
        System.out.println("os.arch: \t" + System.getProperty("os.arch"));
        System.out.println("java.library.path: \t" + System.getProperty("java.library.path"));
        System.out.println("java.io.tmpdir: \t" + System.getProperty("java.io.tmpdir"));
        System.out.println("\n*** Set new System Property ***");
        String string = System.getProperty("os.name").toLowerCase();
        String string2 = System.getProperty("os.version").toLowerCase();
        String string3 = System.getProperty("os.arch").toLowerCase();
        String string4 = System.getProperty("java.library.path");
        String string5 = "";
        if (string.indexOf("win") != -1) {
            string5 = string3.indexOf("64") != -1 ? "lib\\win64" : "lib\\win32";
        } else if (string.indexOf("nix") != -1 || string.indexOf("nux") != -1) {
            string5 = string3.indexOf("64") != -1 ? "lib/x86_64-unknown-linux-gnu" : "lib/i686-pc-linux-gnu";
        } else if (string.indexOf("mac") != -1) {
            string5 = string2.indexOf("10.5") != -1 ? "lib/mac-10.5" : "lib/mac-10.4";
        } else if (string.indexOf("sun") != -1) {
            string5 = string2.indexOf("2.10") != -1 ? "lib/sparc-sun-solaris2.10" : "lib/sparc-sun-solaris2.6";
        }
        if (string4 != null && !string4.contains(string5)) {
            string4 = string4 + File.pathSeparator + string5;
            System.setProperty("java.library.path", string4);
        }
        System.out.println("java.library.path: \t" + System.getProperty("java.library.path"));
        System.out.println();
    }

    public static String findFile(String string) {
        if (new File(string).isFile()) {
            System.out.println("Find file -> " + string);
            return string;
        }
        if (string.lastIndexOf(File.separatorChar) != -1) {
            string = string.substring(string.lastIndexOf(File.separatorChar));
        }
        if (new File(user_dir + File.separatorChar + string).isFile()) {
            System.out.println("Find file -> " + user_dir + File.separatorChar + string);
            return user_dir + File.separatorChar + string;
        }
        if (new File(user_home + File.separatorChar + string).isFile()) {
            System.out.println("Find file -> " + user_home + File.separatorChar + string);
            return user_home + File.separatorChar + string;
        }
        try {
            String string2 = JMCADSystemProperties.getProperty("jmcad.model.path");
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (!new File(string3 + File.separatorChar + string).isFile()) continue;
                System.out.println("Find file -> " + string3 + File.separatorChar + string);
                return string3 + File.separatorChar + string;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.println("Find file -> null");
        return null;
    }

    public static void checkInstall() {
        if (new File(jmcad_project).mkdir()) {
            System.out.println("Created project dir: " + jmcad_project);
        } else {
            System.out.println("Project dir: " + jmcad_project);
        }
        if (!new File(jmcad_properties).exists()) {
            try {
                JarFile jarFile;
                Object object;
                Object object2;
                new File(jmcad_project_examples).mkdir();
                try {
                    object2 = JMCADSystemProperties.class.getResource("JMCAD_us.pdf");
                    object = (JarURLConnection)((URL)object2).openConnection();
                    jarFile = ((JarURLConnection)object).getJarFile();
                }
                catch (Exception exception) {
                    jarFile = new JarFile(JMCADSystemProperties.findFile("lib" + File.separatorChar + "JMCAD_install.jar"));
                }
                object2 = jarFile.entries();
                while (object2.hasMoreElements()) {
                    try {
                        object = (JarEntry)object2.nextElement();
                        if (((ZipEntry)object).getName().lastIndexOf(".jmcad") == -1 && ((ZipEntry)object).getName().lastIndexOf(".pdf") == -1 && ((ZipEntry)object).getName().lastIndexOf(".png") == -1 && ((ZipEntry)object).getName().lastIndexOf(".jpg") == -1 && ((ZipEntry)object).getName().lastIndexOf(".gif") == -1) continue;
                        System.out.println("Extract: " + ((ZipEntry)object).getName());
                        InputStream inputStream = jarFile.getInputStream((ZipEntry)object);
                        FileOutputStream fileOutputStream = new FileOutputStream(jmcad_project + File.separatorChar + ((ZipEntry)object).getName());
                        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                        byte[] byArray = new byte[(int)((ZipEntry)object).getSize()];
                        inputStream.read(byArray);
                        bufferedOutputStream.write(byArray);
                        bufferedOutputStream.flush();
                        inputStream.close();
                        bufferedOutputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            try {
                JMCADSystemProperties.setProperty("jmcad.model.path", "." + File.pathSeparator + jmcad_project + File.pathSeparator + jmcad_examples + File.pathSeparator + user_dir + File.pathSeparator + jmcad_project_examples);
                JMCADSystemProperties.setProperty("jmcad.version", VERSION);
                JMCADSystemProperties.setProperty("jmcad.license.type", "GNU General Public License version 2.0 (GPLv2)");
                JMCADSystemProperties.setProperty("jmcad.license.key", "GPLv2");
                JMCADSystemProperties.setProperty("jmcad.split.pane.divider.location", "250");
                JMCADSystemProperties.setProperty("jmcad.user.language", Locale.getDefault().getLanguage());
                System.out.println("Created JMCAD properties: " + jmcad_properties);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            block24: {
                try {
                    String string = JMCADSystemProperties.getProperty("jmcad.version");
                    if (string.trim().equals(VERSION)) break block24;
                    JMCADSystemProperties.setProperty("jmcad.version", VERSION);
                    try {
                        JarFile jarFile;
                        Object object;
                        Object object3;
                        try {
                            new File(jmcad_project_examples).mkdir();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            object3 = JMCADSystemProperties.class.getResource("JMCAD_us.pdf");
                            object = (JarURLConnection)((URL)object3).openConnection();
                            jarFile = ((JarURLConnection)object).getJarFile();
                        }
                        catch (Exception exception) {
                            jarFile = new JarFile(JMCADSystemProperties.findFile("lib" + File.separatorChar + "JMCAD_install.jar"));
                        }
                        object3 = jarFile.entries();
                        while (object3.hasMoreElements()) {
                            try {
                                object = (JarEntry)object3.nextElement();
                                if (((ZipEntry)object).getName().lastIndexOf(".jmcad") == -1 && ((ZipEntry)object).getName().lastIndexOf(".pdf") == -1 && ((ZipEntry)object).getName().lastIndexOf(".png") == -1 && ((ZipEntry)object).getName().lastIndexOf(".jpg") == -1 && ((ZipEntry)object).getName().lastIndexOf(".gif") == -1) continue;
                                System.out.println("Extract: " + ((ZipEntry)object).getName());
                                new File(((ZipEntry)object).getName()).delete();
                                InputStream inputStream = jarFile.getInputStream((ZipEntry)object);
                                FileOutputStream fileOutputStream = new FileOutputStream(jmcad_project + File.separatorChar + ((ZipEntry)object).getName());
                                byte[] byArray = new byte[(int)((ZipEntry)object).getSize()];
                                inputStream.read(byArray);
                                fileOutputStream.write(byArray);
                                inputStream.close();
                                fileOutputStream.close();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            System.out.println("JMCAD properties: " + jmcad_properties);
        }
    }

    public static synchronized void setProperty(String string, String string2) {
        try {
            Closeable closeable;
            Properties properties = new Properties();
            try {
                closeable = new FileInputStream(jmcad_properties);
                properties.load((InputStream)closeable);
                ((FileInputStream)closeable).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            properties.setProperty(string, string2);
            closeable = new FileOutputStream(jmcad_properties);
            properties.store((OutputStream)closeable, null);
            ((FileOutputStream)closeable).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static synchronized String getProperty(String string) {
        try {
            Properties properties = new Properties();
            FileInputStream fileInputStream = new FileInputStream(jmcad_properties);
            properties.load(fileInputStream);
            fileInputStream.close();
            return properties.getProperty(string);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

