/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.tools.OperatingSystem;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.IllegalRenderingStateException;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.RenderingError;
import javax.media.j3d.RenderingErrorListener;
import javax.media.j3d.Screen3D;
import javax.media.j3d.View;
import javax.media.j3d.VirtualUniverse;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class Component3DManager {
    private static final String CHECK_OFF_SCREEN_IMAGE_SUPPORT = "com.eteks.sweethome3d.j3d.checkOffScreenSupport";
    private static Component3DManager instance;
    private RenderingErrorObserver renderingErrorObserver;
    private Object renderingErrorListener;
    private Boolean offScreenImageSupported;
    private GraphicsConfiguration defaultScreenConfiguration;
    private int depthSize;

    private Component3DManager() {
        if (!GraphicsEnvironment.isHeadless()) {
            int n = 24;
            try {
                n = Integer.valueOf(System.getProperty("com.eteks.sweethome3d.j3d.depthSize", "24"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = this.createGraphicsConfigurationTemplate3D(n);
            this.defaultScreenConfiguration = this.createScreenConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
            if (OperatingSystem.isWindows() && !this.isOffScreenImageSupported()) {
                graphicsConfigTemplate3D = this.createGraphicsConfigurationTemplate3D(new GraphicsConfigTemplate3D().getDepthSize());
                this.defaultScreenConfiguration = this.createScreenConfiguration((GraphicsConfigTemplate)graphicsConfigTemplate3D);
                this.offScreenImageSupported = null;
            }
            this.depthSize = graphicsConfigTemplate3D.getDepthSize();
        } else {
            this.offScreenImageSupported = Boolean.FALSE;
        }
    }

    private GraphicsConfigTemplate3D createGraphicsConfigurationTemplate3D(int n) {
        GraphicsConfigTemplate3D graphicsConfigTemplate3D;
        int n2;
        if (System.getProperty("j3d.implicitAntialiasing") == null) {
            System.setProperty("j3d.implicitAntialiasing", "true");
        }
        if ((n2 = (graphicsConfigTemplate3D = new GraphicsConfigTemplate3D()).getDepthSize()) != n) {
            graphicsConfigTemplate3D.setDepthSize(n);
            if (!graphicsConfigTemplate3D.isGraphicsConfigSupported(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration())) {
                graphicsConfigTemplate3D.setDepthSize(n2);
            }
        }
        graphicsConfigTemplate3D.setSceneAntialiasing(2);
        String string = System.getProperty("j3d.stereo");
        if (string != null) {
            if ("REQUIRED".equals(string)) {
                graphicsConfigTemplate3D.setStereo(1);
            } else if ("PREFERRED".equals(string)) {
                graphicsConfigTemplate3D.setStereo(2);
            }
        }
        return graphicsConfigTemplate3D;
    }

    private GraphicsConfiguration createScreenConfiguration(GraphicsConfigTemplate graphicsConfigTemplate) {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getBestConfiguration(graphicsConfigTemplate);
        if (graphicsConfiguration == null) {
            graphicsConfigTemplate = new GraphicsConfigTemplate3D();
            graphicsConfiguration = graphicsDevice.getBestConfiguration(graphicsConfigTemplate);
        }
        return graphicsConfiguration;
    }

    public int getDepthSize() {
        return this.depthSize;
    }

    public static Component3DManager getInstance() {
        if (instance == null) {
            instance = new Component3DManager();
        }
        return instance;
    }

    public void setRenderingErrorObserver(RenderingErrorObserver renderingErrorObserver) {
        try {
            Class.forName("javax.media.j3d.RenderingErrorListener");
            this.renderingErrorListener = RenderingErrorListenerManager.setRenderingErrorObserver(renderingErrorObserver, this.renderingErrorListener);
            this.renderingErrorObserver = renderingErrorObserver;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public RenderingErrorObserver getRenderingErrorObserver() {
        return this.renderingErrorObserver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOffScreenImageSupported() {
        if (this.offScreenImageSupported == null) {
            if ("false".equalsIgnoreCase(System.getProperty(CHECK_OFF_SCREEN_IMAGE_SUPPORT, "true"))) {
                this.offScreenImageSupported = Boolean.FALSE;
            } else if (OperatingSystem.isMacOSX()) {
                this.offScreenImageSupported = Boolean.TRUE;
            } else {
                SimpleUniverse simpleUniverse = null;
                try {
                    ViewingPlatform viewingPlatform = new ViewingPlatform();
                    Viewer viewer = new Viewer(new Canvas3D[0]);
                    simpleUniverse = new SimpleUniverse(viewingPlatform, viewer);
                    this.getOffScreenImage(viewer.getView(), 1, 1);
                    this.offScreenImageSupported = Boolean.TRUE;
                }
                catch (IllegalRenderingStateException illegalRenderingStateException) {
                    this.offScreenImageSupported = Boolean.FALSE;
                }
                catch (NullPointerException nullPointerException) {
                    this.offScreenImageSupported = Boolean.FALSE;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.offScreenImageSupported = Boolean.FALSE;
                }
                finally {
                    if (simpleUniverse != null) {
                        simpleUniverse.cleanup();
                    }
                }
            }
        }
        return this.offScreenImageSupported;
    }

    private Canvas3D getCanvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl, RenderingObserver renderingObserver) {
        Object object;
        GraphicsConfiguration graphicsConfiguration2;
        if (GraphicsEnvironment.isHeadless()) {
            graphicsConfiguration2 = null;
        } else if (graphicsConfiguration == null || graphicsConfiguration.getDevice() == this.defaultScreenConfiguration.getDevice()) {
            graphicsConfiguration2 = this.defaultScreenConfiguration;
        } else {
            object = this.createGraphicsConfigurationTemplate3D(this.depthSize);
            graphicsConfiguration2 = graphicsConfiguration.getDevice().getBestConfiguration((GraphicsConfigTemplate)object);
            if (graphicsConfiguration2 == null) {
                graphicsConfiguration2 = graphicsConfiguration.getDevice().getBestConfiguration((GraphicsConfigTemplate)new GraphicsConfigTemplate3D());
            }
        }
        if (graphicsConfiguration2 == null) {
            throw new IllegalRenderingStateException("Can't create graphics environment for Canvas 3D");
        }
        try {
            System.gc();
            object = renderingObserver != null ? new ObservedCanvas3D(graphicsConfiguration2, bl, renderingObserver) : new Canvas3D(graphicsConfiguration2, bl);
            if (!bl && OperatingSystem.isLinux() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
                WindowAdapter windowAdapter = new WindowAdapter((Canvas3D)object){
                    private Timer timer;
                    final /* synthetic */ Canvas3D val$canvas3D;
                    {
                        this.val$canvas3D = canvas3D;
                    }

                    public void windowActivated(WindowEvent windowEvent) {
                        if (this.timer == null) {
                            this.timer = new Timer(100, new ActionListener(){

                                public void actionPerformed(ActionEvent actionEvent) {
                                    val$canvas3D.repaint();
                                }
                            });
                            this.timer.setRepeats(false);
                        }
                        this.timer.restart();
                    }

                    public void windowDeactivated(WindowEvent windowEvent) {
                        this.windowActivated(null);
                    }
                };
                object.addHierarchyListener(new HierarchyListener((Canvas3D)object, windowAdapter){
                    private Window parentWindow;
                    final /* synthetic */ Canvas3D val$canvas3D;
                    final /* synthetic */ WindowListener val$parentActivationListener;
                    {
                        this.val$canvas3D = canvas3D;
                        this.val$parentActivationListener = windowListener;
                    }

                    public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                        Window window = SwingUtilities.windowForComponent((Component)this.val$canvas3D);
                        if (window != null) {
                            if (this.parentWindow != window) {
                                window.addWindowListener(this.val$parentActivationListener);
                            }
                        } else if (this.parentWindow != null) {
                            this.parentWindow.removeWindowListener(this.val$parentActivationListener);
                        }
                        this.parentWindow = window;
                    }
                });
            }
            return object;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            IllegalRenderingStateException illegalRenderingStateException = new IllegalRenderingStateException("Can't create Canvas 3D");
            illegalRenderingStateException.initCause((Throwable)illegalArgumentException);
            throw illegalRenderingStateException;
        }
    }

    public Canvas3D getOnscreenCanvas3D() {
        return this.getOnscreenCanvas3D(null);
    }

    public Canvas3D getOnscreenCanvas3D(RenderingObserver renderingObserver) {
        return this.getCanvas3D(null, false, renderingObserver);
    }

    public Canvas3D getOnscreenCanvas3D(GraphicsConfiguration graphicsConfiguration, RenderingObserver renderingObserver) {
        return this.getCanvas3D(graphicsConfiguration, false, renderingObserver);
    }

    public Canvas3D getOffScreenCanvas3D(int n, int n2) {
        Canvas3D canvas3D = this.getCanvas3D(null, true, null);
        Screen3D screen3D = canvas3D.getScreen3D();
        screen3D.setSize(n, n2);
        screen3D.setPhysicalScreenWidth(2.0);
        screen3D.setPhysicalScreenHeight((double)(2.0f / (float)n * (float)n2));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        ImageComponent2D imageComponent2D = new ImageComponent2D(1, bufferedImage);
        imageComponent2D.setCapability(2);
        canvas3D.setOffScreenBuffer(imageComponent2D);
        return canvas3D;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BufferedImage getOffScreenImage(View view, int n, int n2) {
        BufferedImage bufferedImage;
        RenderingErrorObserver renderingErrorObserver;
        block10: {
            Canvas3D canvas3D = null;
            renderingErrorObserver = this.getRenderingErrorObserver();
            try {
                final CountDownLatch countDownLatch = new CountDownLatch(1);
                this.setRenderingErrorObserver(new RenderingErrorObserver(){

                    public void errorOccured(int n, String string) {
                        countDownLatch.countDown();
                    }
                });
                canvas3D = this.getOffScreenCanvas3D(n, n2);
                view.addCanvas3D(canvas3D);
                canvas3D.renderOffScreenBuffer();
                canvas3D.waitForOffScreenRendering();
                if (countDownLatch.await(10L, TimeUnit.MILLISECONDS)) {
                    throw new IllegalRenderingStateException("Off screen rendering unavailable");
                }
                bufferedImage = canvas3D.getOffScreenBuffer().getImage();
                if (canvas3D == null) break block10;
            }
            catch (InterruptedException interruptedException) {
                try {
                    IllegalRenderingStateException illegalRenderingStateException = new IllegalRenderingStateException("Off screen rendering interrupted");
                    illegalRenderingStateException.initCause((Throwable)interruptedException);
                    throw illegalRenderingStateException;
                }
                catch (Throwable throwable) {
                    if (canvas3D != null) {
                        view.removeCanvas3D(canvas3D);
                        try {
                            canvas3D.setOffScreenBuffer(null);
                        }
                        catch (NullPointerException nullPointerException) {
                            // empty catch block
                        }
                    }
                    this.setRenderingErrorObserver(renderingErrorObserver);
                    throw throwable;
                }
            }
            view.removeCanvas3D(canvas3D);
            try {
                canvas3D.setOffScreenBuffer(null);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.setRenderingErrorObserver(renderingErrorObserver);
        return bufferedImage;
    }

    private static class ObservedCanvas3D
    extends Canvas3D {
        private final RenderingObserver renderingObserver;
        private final boolean paintDelayed;
        private Timer timer;

        private ObservedCanvas3D(GraphicsConfiguration graphicsConfiguration, boolean bl, RenderingObserver renderingObserver) {
            super(graphicsConfiguration, bl);
            this.renderingObserver = renderingObserver;
            this.paintDelayed = OperatingSystem.isWindows() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7");
        }

        public void preRender() {
            this.renderingObserver.canvas3DPreRendered(this);
        }

        public void postRender() {
            this.renderingObserver.canvas3DPostRendered(this);
        }

        public void postSwap() {
            this.renderingObserver.canvas3DSwapped(this);
        }

        public void paint(Graphics graphics) {
            if (this.paintDelayed) {
                if (this.timer == null) {
                    this.timer = new Timer(100, new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Graphics graphics = ObservedCanvas3D.this.getGraphics();
                            ObservedCanvas3D.super.paint(graphics);
                            graphics.dispose();
                        }
                    });
                    this.timer.setRepeats(false);
                }
                this.timer.restart();
            } else {
                super.paint(graphics);
            }
        }
    }

    public static interface RenderingObserver {
        public void canvas3DPreRendered(Canvas3D var1);

        public void canvas3DPostRendered(Canvas3D var1);

        public void canvas3DSwapped(Canvas3D var1);
    }

    private static class RenderingErrorListenerManager {
        private RenderingErrorListenerManager() {
        }

        public static Object setRenderingErrorObserver(final RenderingErrorObserver renderingErrorObserver, Object object) {
            if (object != null) {
                VirtualUniverse.removeRenderingErrorListener((RenderingErrorListener)((RenderingErrorListener)object));
            }
            RenderingErrorListener renderingErrorListener = new RenderingErrorListener(){

                public void errorOccurred(RenderingError renderingError) {
                    renderingErrorObserver.errorOccured(renderingError.getErrorCode(), renderingError.getErrorMessage());
                }
            };
            VirtualUniverse.addRenderingErrorListener((RenderingErrorListener)renderingErrorListener);
            return renderingErrorListener;
        }
    }

    public static interface RenderingErrorObserver {
        public void errorOccured(int var1, String var2);
    }
}

