/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.swing.HomeTransferableList;
import com.eteks.sweethome3d.swing.LocatedTransferHandler;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.FurnitureView;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.TransferableView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureTransferHandler
extends LocatedTransferHandler {
    private final Home home;
    private final ContentManager contentManager;
    private final HomeController homeController;
    private JComponent transferableSource;
    private List<HomePieceOfFurniture> copiedFurniture;
    private Object copiedCSV;

    public FurnitureTransferHandler(Home home, ContentManager contentManager, HomeController homeController) {
        this.home = home;
        this.contentManager = contentManager;
        this.homeController = homeController;
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        this.transferableSource = jComponent;
        this.copiedFurniture = Home.getFurnitureSubList(this.home.getSelectedItems());
        final HomeTransferableList homeTransferableList = new HomeTransferableList(this.copiedFurniture);
        if (jComponent instanceof TransferableView) {
            this.copiedCSV = null;
            this.homeController.createTransferData(new TransferableView.TransferObserver(){

                public void dataReady(Object[] objectArray) {
                    for (Object object : objectArray) {
                        if (!(object instanceof String)) continue;
                        FurnitureTransferHandler.this.copiedCSV = object;
                        break;
                    }
                }
            }, TransferableView.DataType.FURNITURE_LIST);
            return new Transferable(){

                public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                    if (DataFlavor.stringFlavor.equals(dataFlavor)) {
                        return FurnitureTransferHandler.this.copiedCSV;
                    }
                    return homeTransferableList.getTransferData(dataFlavor);
                }

                public DataFlavor[] getTransferDataFlavors() {
                    ArrayList<DataFlavor> arrayList = new ArrayList<DataFlavor>(Arrays.asList(homeTransferableList.getTransferDataFlavors()));
                    arrayList.add(DataFlavor.stringFlavor);
                    return arrayList.toArray(new DataFlavor[arrayList.size()]);
                }

                public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                    return homeTransferableList.isDataFlavorSupported(dataFlavor) || DataFlavor.stringFlavor.equals(dataFlavor);
                }
            };
        }
        return homeTransferableList;
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        if (n == 2 && this.copiedFurniture != null) {
            this.homeController.cut(this.copiedFurniture);
        }
        this.transferableSource = null;
        this.copiedFurniture = null;
        this.copiedCSV = null;
        this.homeController.enablePasteAction();
    }

    @Override
    public boolean canImportFlavor(DataFlavor[] dataFlavorArray) {
        Level level = this.home.getSelectedLevel();
        List<DataFlavor> list = Arrays.asList(dataFlavorArray);
        return !(level != null && !level.isViewable() || !list.contains(HomeTransferableList.HOME_FLAVOR) && !list.contains(DataFlavor.javaFileListFlavor));
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (this.canImportFlavor(transferable.getTransferDataFlavors())) {
            try {
                List<DataFlavor> list = Arrays.asList(transferable.getTransferDataFlavors());
                if (list.contains(HomeTransferableList.HOME_FLAVOR)) {
                    List list2 = (List)transferable.getTransferData(HomeTransferableList.HOME_FLAVOR);
                    List<HomePieceOfFurniture> list3 = Home.getFurnitureSubList(list2);
                    if (this.isDrop()) {
                        HomePieceOfFurniture homePieceOfFurniture = this.getDropPieceOfFurniture(jComponent);
                        View view = this.homeController.getFurnitureController().getView();
                        if ((jComponent == this.transferableSource || jComponent instanceof JViewport && ((JViewport)jComponent).getView() == this.transferableSource) && view != null) {
                            this.homeController.getFurnitureController().moveSelectedFurnitureBefore(homePieceOfFurniture);
                        } else {
                            this.homeController.drop(list3, view != null && SwingUtilities.isDescendingFrom(jComponent, (JComponent)((Object)view)) ? view : null, homePieceOfFurniture);
                        }
                        this.copiedFurniture = null;
                    } else {
                        this.homeController.paste(list3);
                    }
                    return true;
                }
                List list4 = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                final List<String> list5 = this.getModelContents(list4, this.contentManager);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        FurnitureTransferHandler.this.homeController.dropFiles(list5, 0.0f, 0.0f);
                    }
                });
                return !list5.isEmpty();
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                throw new RuntimeException("Can't import", unsupportedFlavorException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Can't access to data", iOException);
            }
        }
        return false;
    }

    private HomePieceOfFurniture getDropPieceOfFurniture(JComponent jComponent) {
        if (OperatingSystem.isJavaVersionGreaterOrEqual("1.6") && jComponent instanceof FurnitureView) {
            try {
                Object object = jComponent.getClass().getMethod("getDropLocation", new Class[0]).invoke((Object)jComponent, new Object[0]);
                if (((Boolean)object.getClass().getMethod("isInsertRow", new Class[0]).invoke(object, new Object[0])).booleanValue()) {
                    int n = (Integer)object.getClass().getMethod("getRow", new Class[0]).invoke(object, new Object[0]);
                    TableModel tableModel = ((JTable)jComponent).getModel();
                    if (n != -1 && n < tableModel.getRowCount()) {
                        HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)tableModel.getValueAt(n, 0);
                        if (this.copiedFurniture != null) {
                            while (this.copiedFurniture.contains(homePieceOfFurniture) || this.isPieceOfFurnitureChild(homePieceOfFurniture, this.copiedFurniture)) {
                                if (++n < tableModel.getRowCount()) {
                                    homePieceOfFurniture = (HomePieceOfFurniture)tableModel.getValueAt(n, 0);
                                    continue;
                                }
                                homePieceOfFurniture = null;
                                break;
                            }
                            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                                HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)homePieceOfFurniture;
                                if (this.copiedFurniture.containsAll(homeFurnitureGroup.getFurniture())) {
                                    homePieceOfFurniture = null;
                                }
                                ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(homeFurnitureGroup.getAllFurniture());
                                Iterator iterator = arrayList.iterator();
                                while (iterator.hasNext()) {
                                    if (!(iterator.next() instanceof HomeFurnitureGroup)) continue;
                                    iterator.remove();
                                }
                                if (this.copiedFurniture.containsAll(arrayList)) {
                                    homePieceOfFurniture = null;
                                }
                            }
                        }
                        return homePieceOfFurniture;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    private boolean isPieceOfFurnitureChild(HomePieceOfFurniture homePieceOfFurniture, List<HomePieceOfFurniture> list) {
        for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
            if (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || !((HomeFurnitureGroup)homePieceOfFurniture2).getAllFurniture().contains(homePieceOfFurniture)) continue;
            return true;
        }
        return false;
    }
}

