/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.AutoCommitSpinner;
import com.eteks.sweethome3d.swing.HomeFurniturePanel;
import com.eteks.sweethome3d.swing.NullableSpinner;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.ObserverCameraController;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ObserverCameraPanel
extends JPanel
implements DialogView {
    private final ObserverCameraController controller;
    private JLabel xLabel;
    private JSpinner xSpinner;
    private JLabel yLabel;
    private JSpinner ySpinner;
    private JLabel elevationLabel;
    private JSpinner elevationSpinner;
    private JLabel yawLabel;
    private JSpinner yawSpinner;
    private JLabel pitchLabel;
    private JSpinner pitchSpinner;
    private JLabel fieldOfViewLabel;
    private JSpinner fieldOfViewSpinner;
    private JCheckBox adjustObserverCameraElevationCheckBox;
    private String dialogTitle;

    public ObserverCameraPanel(UserPreferences userPreferences, ObserverCameraController observerCameraController) {
        super(new GridBagLayout());
        this.controller = observerCameraController;
        this.createComponents(userPreferences, observerCameraController);
        this.setMnemonics(userPreferences);
        this.layoutComponents(userPreferences);
    }

    private void createComponents(UserPreferences userPreferences, final ObserverCameraController observerCameraController) {
        String string = userPreferences.getLengthUnit().getName();
        this.xLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "xLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -500000.0f, 500000.0f);
        this.xSpinner = new NullableSpinner(nullableSpinnerLengthModel);
        nullableSpinnerLengthModel.setLength(Float.valueOf(observerCameraController.getX()));
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        observerCameraController.addPropertyChangeListener(ObserverCameraController.Property.X, propertyChangeListener);
        nullableSpinnerLengthModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                observerCameraController.setX(nullableSpinnerLengthModel.getLength().floatValue());
            }
        });
        this.yLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HomeFurniturePanel.class, "yLabel.text", string));
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel2 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, -500000.0f, 500000.0f);
        this.ySpinner = new NullableSpinner(nullableSpinnerLengthModel2);
        nullableSpinnerLengthModel2.setLength(Float.valueOf(observerCameraController.getY()));
        PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel2.setLength((Float)propertyChangeEvent.getNewValue());
            }
        };
        observerCameraController.addPropertyChangeListener(ObserverCameraController.Property.Y, propertyChangeListener2);
        nullableSpinnerLengthModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                observerCameraController.setY(nullableSpinnerLengthModel2.getLength().floatValue());
            }
        });
        this.elevationLabel = new JLabel(String.format(SwingTools.getLocalizedLabelText(userPreferences, ObserverCameraPanel.class, "elevationLabel.text", new Object[0]), string));
        float f = userPreferences.getLengthUnit().getMaximumElevation();
        final NullableSpinner.NullableSpinnerLengthModel nullableSpinnerLengthModel3 = new NullableSpinner.NullableSpinnerLengthModel(userPreferences, observerCameraController.getMinimumElevation(), f);
        this.elevationSpinner = new NullableSpinner(nullableSpinnerLengthModel3);
        nullableSpinnerLengthModel3.setLength(Float.valueOf(observerCameraController.getElevation()));
        nullableSpinnerLengthModel3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                observerCameraController.setElevation(nullableSpinnerLengthModel3.getLength().floatValue());
            }
        });
        PropertyChangeListener propertyChangeListener3 = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                nullableSpinnerLengthModel3.setLength(Float.valueOf(observerCameraController.getElevation()));
            }
        };
        observerCameraController.addPropertyChangeListener(ObserverCameraController.Property.ELEVATION, propertyChangeListener3);
        this.yawLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ObserverCameraPanel.class, "yawLabel.text", new Object[0]));
        final SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(new Float(0.0f), new Float(-10000.0f), new Float(10000.0f), new Float(5.0f));
        this.yawSpinner = new AutoCommitSpinner(spinnerNumberModel, new DecimalFormat("0.#"));
        spinnerNumberModel.setValue(new Float((float)Math.toDegrees(observerCameraController.getYaw())));
        spinnerNumberModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                observerCameraController.setYaw((float)Math.toRadians(((Number)spinnerNumberModel.getValue()).floatValue()));
            }
        });
        observerCameraController.addPropertyChangeListener(ObserverCameraController.Property.YAW, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel.setValue(new Float((float)Math.toDegrees(observerCameraController.getYaw())));
            }
        });
        this.pitchLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ObserverCameraPanel.class, "pitchLabel.text", new Object[0]));
        final SpinnerNumberModel spinnerNumberModel2 = new SpinnerNumberModel(new Float(0.0f), new Float(-90.0f), new Float(90.0f), new Float(5.0f));
        this.pitchSpinner = new AutoCommitSpinner(spinnerNumberModel2, new DecimalFormat("0.#"));
        spinnerNumberModel2.setValue(new Float((float)Math.toDegrees(observerCameraController.getPitch())));
        spinnerNumberModel2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                observerCameraController.setPitch((float)Math.toRadians(((Number)spinnerNumberModel2.getValue()).floatValue()));
            }
        });
        observerCameraController.addPropertyChangeListener(ObserverCameraController.Property.PITCH, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel2.setValue(new Float((float)Math.toDegrees(observerCameraController.getPitch())));
            }
        });
        this.fieldOfViewLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, ObserverCameraPanel.class, "fieldOfViewLabel.text", new Object[0]));
        final SpinnerNumberModel spinnerNumberModel3 = new SpinnerNumberModel(new Float(10.0f), new Float(2.0f), new Float(120.0f), new Float(1.0f));
        this.fieldOfViewSpinner = new AutoCommitSpinner(spinnerNumberModel3, new DecimalFormat("0.#"));
        spinnerNumberModel3.setValue(new Float((float)Math.toDegrees(observerCameraController.getFieldOfView())));
        spinnerNumberModel3.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                observerCameraController.setFieldOfView((float)Math.toRadians(((Number)spinnerNumberModel3.getValue()).floatValue()));
            }
        });
        observerCameraController.addPropertyChangeListener(ObserverCameraController.Property.FIELD_OF_VIEW, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                spinnerNumberModel3.setValue(new Float((float)Math.toDegrees(observerCameraController.getFieldOfView())));
            }
        });
        this.adjustObserverCameraElevationCheckBox = new JCheckBox(SwingTools.getLocalizedLabelText(userPreferences, ObserverCameraPanel.class, "adjustObserverCameraElevationCheckBox.text", new Object[0]), observerCameraController.isElevationAdjusted());
        this.adjustObserverCameraElevationCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                observerCameraController.setElevationAdjusted(ObserverCameraPanel.this.adjustObserverCameraElevationCheckBox.isSelected());
            }
        });
        observerCameraController.addPropertyChangeListener(ObserverCameraController.Property.OBSERVER_CAMERA_ELEVATION_ADJUSTED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ObserverCameraPanel.this.adjustObserverCameraElevationCheckBox.setSelected(observerCameraController.isElevationAdjusted());
            }
        });
        observerCameraController.addPropertyChangeListener(ObserverCameraController.Property.MINIMUM_ELEVATION, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (nullableSpinnerLengthModel3.getLength() != null) {
                    nullableSpinnerLengthModel3.setLength(Float.valueOf(Math.max(nullableSpinnerLengthModel3.getLength().floatValue(), observerCameraController.getMinimumElevation())));
                }
                nullableSpinnerLengthModel3.setMinimum(Float.valueOf(observerCameraController.getMinimumElevation()));
            }
        });
        this.dialogTitle = userPreferences.getLocalizedString(ObserverCameraPanel.class, "observerCamera.title", new Object[0]);
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.xLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ObserverCameraPanel.class, "xLabel.mnemonic", new Object[0])).getKeyCode());
            this.xLabel.setLabelFor(this.xSpinner);
            this.yLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ObserverCameraPanel.class, "yLabel.mnemonic", new Object[0])).getKeyCode());
            this.yLabel.setLabelFor(this.ySpinner);
            this.elevationLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ObserverCameraPanel.class, "elevationLabel.mnemonic", new Object[0])).getKeyCode());
            this.elevationLabel.setLabelFor(this.elevationSpinner);
            this.fieldOfViewLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ObserverCameraPanel.class, "fieldOfViewLabel.mnemonic", new Object[0])).getKeyCode());
            this.fieldOfViewLabel.setLabelFor(this.fieldOfViewLabel);
            this.yawLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ObserverCameraPanel.class, "yawLabel.mnemonic", new Object[0])).getKeyCode());
            this.yawLabel.setLabelFor(this.yawLabel);
            this.pitchLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ObserverCameraPanel.class, "pitchLabel.mnemonic", new Object[0])).getKeyCode());
            this.pitchLabel.setLabelFor(this.pitchLabel);
            this.adjustObserverCameraElevationCheckBox.setMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(ObserverCameraPanel.class, "adjustObserverCameraElevationCheckBox.mnemonic", new Object[0])).getKeyCode());
        }
    }

    private void layoutComponents(UserPreferences userPreferences) {
        int n = OperatingSystem.isMacOSX() ? 22 : 21;
        int n2 = Math.round(5.0f * SwingTools.getResolutionScale());
        JPanel jPanel = SwingTools.createTitledPanel(userPreferences.getLocalizedString(ObserverCameraPanel.class, "locationPanel.title", new Object[0]));
        Insets insets = new Insets(0, 0, n2, n2);
        jPanel.add((Component)this.xLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        Insets insets2 = new Insets(0, 0, n2, 0);
        jPanel.add((Component)this.xSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        jPanel.add((Component)this.yLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel.add((Component)this.ySpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, -15, 0));
        jPanel.add((Component)this.elevationLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel.add((Component)this.elevationSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        Insets insets3 = OperatingSystem.isMacOSXLeopardOrSuperior() ? new Insets(0, 0, 0, 0) : new Insets(0, 0, 5, 0);
        this.add((Component)jPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        JPanel jPanel2 = SwingTools.createTitledPanel(userPreferences.getLocalizedString(ObserverCameraPanel.class, "anglesPanel.title", new Object[0]));
        jPanel2.add((Component)this.yawLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.yawSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets2, -10, 0));
        jPanel2.add((Component)this.pitchLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.pitchSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        jPanel2.add((Component)this.fieldOfViewLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, n, 0, insets, 0, 0));
        jPanel2.add((Component)this.fieldOfViewSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 21, 2, insets2, 0, 0));
        this.add((Component)jPanel2, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 21, 2, insets3, 0, 0));
        if (this.controller.isObserverCameraElevationAdjustedEditable()) {
            this.add((Component)this.adjustObserverCameraElevationCheckBox, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 21, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void displayView(View view) {
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)this.elevationSpinner.getEditor()).getTextField();
        if (SwingTools.showConfirmDialog((JComponent)((Object)view), this, this.dialogTitle, jFormattedTextField) == 0 && this.controller != null) {
            this.controller.modifyObserverCamera();
        }
    }
}

