/*
 * Decompiled with CFR 0.152.
 */
package retypar.converter.helper;

import heuser.simpleLogger.SimpleLogger;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import retypar.converter.helper.FontRenderer;
import retypar.converter.helper.Letter;
import retypar.retypar;

public class ImageProcessor
extends SimpleLogger
implements Runnable {
    public String[] txtVerMono;
    public Color[][] colors;
    private FontRenderer fRender = new FontRenderer();
    private Image originalImage;
    public boolean working;
    BufferedImage converted;
    private boolean uppercase;
    private boolean lowercase;
    private boolean numbers;
    private boolean special;
    public boolean colored;
    private int renderMode;
    private int threshold;
    public Color bgColor;
    public boolean stop;
    private int scale;
    public final int RENDER_MRULES = 0;
    public final int RENDER_NOISE = 1;
    private int destHeight;
    private int destWidth;
    private Letter m;
    private Letter l;
    private BufferedImage bImg;
    public float progress = 0.0f;

    public void init(Image image, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Color color, int n, int n2, int n3) {
        this.originalImage = image;
        this.uppercase = bl;
        this.lowercase = bl2;
        this.numbers = bl3;
        this.special = bl4;
        this.colored = bl5;
        this.bgColor = color;
        this.scale = n;
        this.renderMode = n2;
        this.threshold = n3;
        this.stop = false;
        this.progress = 0.0f;
        this.working = true;
    }

    public void run() {
        this.prepareConversion();
    }

    private void prepareConversion() {
        this.fRender.render(new Font(retypar.font, 0, retypar.fontSize), this.uppercase, this.lowercase, this.numbers, this.special);
    }

    public BufferedImage convertImage() {
        int n = 0;
        BufferedImage bufferedImage = new BufferedImage(this.originalImage.getWidth(null), this.originalImage.getHeight(null), 1);
        bufferedImage.getGraphics().drawImage(this.originalImage, 0, 0, this.originalImage.getWidth(null), this.originalImage.getHeight(null), null);
        this.destWidth = bufferedImage.getWidth();
        this.destHeight = bufferedImage.getHeight();
        if (this.scale != 100) {
            this.destWidth = this.destWidth * this.scale / 100;
            this.destHeight = this.destHeight * this.scale / 100;
        }
        this.destWidth = this.destWidth / retypar.fontSize * retypar.fontSize;
        this.destHeight = this.destHeight / retypar.fontSize * retypar.fontSize;
        this.txtVerMono = new String[this.destHeight / retypar.fontSize];
        this.colors = new Color[this.destHeight / retypar.fontSize][this.destWidth / retypar.fontSize];
        if (this.scale != 100) {
            Image image = bufferedImage.getScaledInstance(this.destWidth, this.destHeight, 2);
            bufferedImage = new BufferedImage(this.destWidth, this.destHeight, 1);
            bufferedImage.getGraphics().drawImage(image, 0, 0, null);
        }
        this.bImg = new BufferedImage(this.destWidth, this.destHeight, 1);
        Graphics2D graphics2D = this.bImg.createGraphics();
        graphics2D.setBackground(this.bgColor);
        graphics2D.clearRect(0, 0, this.destWidth, this.destHeight);
        graphics2D.setColor(Color.BLACK);
        Font font = new Font(retypar.font, 0, retypar.fontSize + 1);
        graphics2D.setFont(font);
        float f = 100.0f / ((float)this.destWidth / (float)retypar.fontSize * ((float)this.destHeight / (float)retypar.fontSize));
        for (int i = 0; i < this.destHeight; i += retypar.fontSize) {
            n = i / retypar.fontSize;
            this.txtVerMono[n] = "";
            for (int j = 0; j < this.destWidth; j += retypar.fontSize) {
                this.progress += f;
                int[] nArray = new int[retypar.fontSize * retypar.fontSize];
                for (int k = 0; k < retypar.fontSize; ++k) {
                    for (int i2 = 0; i2 < retypar.fontSize; ++i2) {
                        nArray[k * retypar.fontSize + i2] = bufferedImage.getRGB(j + i2, i + k);
                    }
                }
                Color color = this.calcColor(nArray);
                if (this.colored) {
                    graphics2D.setColor(color);
                    this.colors[n][j / retypar.fontSize] = color;
                }
                String string = this.check(nArray, color);
                int n2 = n;
                this.txtVerMono[n2] = this.txtVerMono[n2] + string;
                graphics2D.drawString(string, j, i + retypar.fontSize);
            }
            if (!this.stop) continue;
            this.working = false;
            return this.bImg;
        }
        this.working = false;
        this.progress = 100.0f;
        bufferedImage.flush();
        graphics2D.dispose();
        this.bImg.flush();
        return this.bImg;
    }

    public String[] getTxtVerMono() {
        return this.txtVerMono;
    }

    public BufferedImage getImage() {
        return this.bImg;
    }

    private String check(int[] nArray, Color color) {
        int n = FontRenderer.letters.size();
        this.m = (Letter)FontRenderer.letters.get(n - 1);
        int n2 = this.m.fits(nArray);
        char c = this.m.name;
        switch (this.renderMode) {
            case 0: {
                nArray = this.renderMRules(nArray, color, this.threshold);
                break;
            }
            case 1: {
                nArray = this.renderNoise(nArray, color, this.threshold);
            }
        }
        while (n > 0) {
            this.l = (Letter)FontRenderer.letters.get(--n);
            if (this.l.fits(nArray) >= n2) continue;
            n2 = this.l.fits(nArray);
            c = this.l.name;
        }
        return "" + c;
    }

    private int[] renderMRules(int[] nArray, Color color, int n) {
        for (int i = 0; i < nArray.length; ++i) {
        }
        return nArray;
    }

    private int[] renderNoise(int[] nArray, Color color, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            Color color2 = new Color(nArray[i]);
            int n2 = color2.getRed() - color.getRed();
            int n3 = color2.getGreen() - color.getGreen();
            int n4 = color2.getBlue() - color.getBlue();
            n2 = n2 < -n || n2 > n ? 0 : 255;
            n3 = n3 < -n || n3 > n ? 0 : 255;
            n4 = n4 < -n || n4 > n ? 0 : 255;
            color2 = new Color(n2, n3, n4);
            nArray[i] = color2.getRGB();
        }
        return nArray;
    }

    private Color calcColor(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < retypar.fontSize * retypar.fontSize; ++i) {
            n = (n + DirectColorModel.getRGBdefault().getRed(nArray[i])) / 2;
            n3 = (n3 + DirectColorModel.getRGBdefault().getBlue(nArray[i])) / 2;
            n2 = (n2 + DirectColorModel.getRGBdefault().getGreen(nArray[i])) / 2;
        }
        if (n > 255) {
            n = 255;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        if (n3 > 255) {
            n3 = 255;
        }
        return new Color(n, n2, n3);
    }
}

