package retypar;


import java.io.*;

/**
 * Loads external classes from algorithms folder and casts them to <code>retypar.converter</code> if possible.
 */
public class AlgoClassLoader extends ClassLoader{

    private final String fileSeparator = System.getProperty("file.separator");

    public Class findClass(String name){
        String className = "ERROR";
        try{
            className = name.substring(name.lastIndexOf(fileSeparator + "converter" + fileSeparator) + 11);
            className = className.substring(0, className.length() - 6);
            className = className.replaceAll("\\\\", "/");
            //System.out.println("className " + className);
        }catch (Exception e){
            retypar.logError("Error extracting class name: " + e.toString());
        }


        //System.out.println("searching " + name + "\t" + className);
        if (name.startsWith("file:/")) name = name.substring(5);
        byte buffer[] = readClassFile(new File(name));

        className = className.replaceAll("/", ".");

        //System.out.println("creating " + className.replaceAll(fileSeparator, "."));

        Class c = defineClass("retypar.converter." + className, buffer, 0, buffer.length);

        return c;
    }

    private byte[] readClassFile(File file){
        //System.out.println("loading " + file.getAbsolutePath());
        byte buffer[];

        try{
            InputStream in = new FileInputStream(file);
            int bufferSize = (int)file.length();
            buffer = new byte[bufferSize];
            in.read(buffer, 0, bufferSize);
            in.close();
        }catch (Exception e){
            retypar.logError("Cannot read class file!\n" + e.toString());
            return null;
        }
    return buffer;
    }
}
