package retypar.converter;

import retypar.converter.helper.ImageProcessor;

import java.io.File;
import java.awt.*;
import java.awt.image.BufferedImage;

/**
 * retypar algorithm "Noise".<BR>
 * Returns ASCII and Images, features progress monitoring and threshold.
 * @author Jens Heuser
 * @see retypar.converter.Converter
 */
public class Noise implements Converter {

    ImageProcessor imP;



    public String worksWith() {
        return "0.9.2";
    }


    public String getDescription() {
        return "retypar's second algorithm.\nUsing a threshold of 0 produces results similar \nto the ones of M-Rules.\n";
    }


    public String getAuthor() {
        return "Jens Heuser";
    }


    public String getWebsite() {
        return "http://www.retypar.de.vu";
    }


    public String toString() {
        return "Noise";
    }


    public String getShortName(){
        return "ns";
    }


    public String broughtPackage(){
        return "";
    }


    public boolean usesThreshold() {
        return true;
    }


    public int getMinThreshold() {
        return 0;
    }


    public int getMaxThreshold() {
        return 255;
    }


    public int getInitThreshold(){
        return 5;
    }

    public int getThresholdStep(){
        return 1;
    }


    public boolean monitorsProgess() {
        return true;
    }


    public boolean returnsASCII(){
        return true;
    }


    public boolean returnsImage(){
        return true;
    }


    public Color[][] getColors(){
        return imP.colors;
    }


    public String[] getASCII(){
        if (imP.progress != 100){
            imP.run();
            imP.convertImage();
        }
        return imP.getTxtVerMono();
    }


    public void prepare(Image img,
                        boolean uppercase,
                        boolean lowercase,
                        boolean numbers,
                        boolean special,
                        boolean colored,
                        Color bgColor,
                        int scale,
                        int threshold) {

        imP = new ImageProcessor();
        imP.init(img, uppercase, lowercase, numbers, special, colored, bgColor, scale, imP.RENDER_NOISE, threshold);
    }


    public BufferedImage getImage() {
        if (imP.progress != 100){
            imP.run();
            imP.convertImage();
        }
        return imP.getImage();
    }


    public int getProgress(){
        return (int)imP.progress;
    }


    public void stop(){}


    public String getErrors() {
        return null;
    }
}
