/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.JaxoClipboard;
import net.sf.jaxodraw.gui.JaxoDrawingArea;
import net.sf.jaxodraw.gui.JaxoZoom;
import net.sf.jaxodraw.gui.grid.JaxoPaintableGrid;
import net.sf.jaxodraw.gui.handle.JaxoDefaultHandle;
import net.sf.jaxodraw.gui.menu.popup.JaxoFBoxPopupMenu;
import net.sf.jaxodraw.gui.panel.JaxoColorChooser;
import net.sf.jaxodraw.gui.panel.edit.JaxoOptionsPanel;
import net.sf.jaxodraw.object.JaxoFillColorObject;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.group.JaxoGroup;
import net.sf.jaxodraw.object.text.JaxoPSText;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.Location;

public abstract class AbstractJaxoCanvas
extends JComponent
implements JaxoDrawingArea {
    protected static final int HANDLE_PAINT_OFF = 0;
    protected static final int HANDLE_PAINT_ON = 1;
    protected static final int HANDLE_PAINT_SELECTION = 2;
    protected static final boolean HOVERING_EDITED_OBJECTS = true;
    private static final Insets COMPONENT_REPAINT_PADDING = new Insets(5, 5, 5, 5);
    private transient JaxoHandle handle = new JaxoDefaultHandle();
    private transient JaxoZoom zoom = new JaxoZoom(this);
    private transient JaxoPaintableGrid grid;
    private transient ChangeListener gridListener = this.getNewGridListener();
    private transient JaxoGraph canvasGraph = new JaxoGraph();
    private transient JaxoColorChooser colorChooser;
    private final JaxoFBoxPopupMenu fboxPopup;
    private final JaxoClipboard clipboard;
    private boolean antialiasEnabled;
    private Color canvasBackground = Color.white;
    private final Dimension minimumCanvasSize = new Dimension(0, 0);
    private final Dimension maximumCanvasSize = new Dimension(504, 360);
    private int handlePaintMode;

    protected AbstractJaxoCanvas() {
        this.fboxPopup = new JaxoFBoxPopupMenu();
        this.clipboard = new JaxoClipboard(this);
        this.resetColorChoser();
    }

    protected final JaxoFBoxPopupMenu getFboxPopup() {
        return this.fboxPopup;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.zoom = new JaxoZoom(this);
        this.handle = new JaxoDefaultHandle();
        this.canvasGraph = new JaxoGraph();
        this.resetColorChoser();
        this.gridListener = this.getNewGridListener();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Jaxo.mode")) {
            int mode = (Integer)evt.getNewValue();
            if (!this.unMarkGraph()) {
                this.repaint();
            }
            this.zoom.setActive(mode == 3162);
            this.updateMode(mode);
            this.firePropertyChange("Jaxo.mode", evt.getOldValue(), evt.getNewValue());
        } else if (evt.getPropertyName().equals("Jaxo.antialiasEnabled")) {
            this.setAntialiasEnabled((Boolean)evt.getNewValue());
        } else if (evt.getPropertyName().equals("Jaxo.mouseLocation")) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public Component asComponent() {
        return this;
    }

    protected JaxoHandle getHandle() {
        return this.handle;
    }

    public void setHandle(JaxoHandle newHandle) {
        if (newHandle != this.getHandle()) {
            this.handle = newHandle;
            this.repaint();
        }
    }

    protected int getHandlePaintMode() {
        return this.handlePaintMode;
    }

    protected void setHandlePaintMode(int value) {
        if (this.handlePaintMode != value) {
            this.handlePaintMode = value;
            this.repaint();
        }
    }

    protected JaxoGraph getCanvasGraph() {
        return this.canvasGraph;
    }

    public void setCanvasGraph(JaxoGraph value) {
        this.canvasGraph = value;
    }

    public void moveGraph(int dx, int dy) {
        this.canvasGraph.getObjectList().moveAllObjects(dx, dy);
        this.markImageInvalid();
    }

    public void copyMarkedObjects() {
        this.putToSystemClipboard(this.getClipboard());
    }

    public void cutMarkedObjects() {
        this.copyMarkedObjects();
        this.deleteMarkedObjects();
    }

    public boolean unMarkGraph() {
        if (this.canvasGraph.containsMarkedObjects()) {
            this.canvasGraph.setAsMarked(false);
            this.repaint();
            return true;
        }
        return false;
    }

    public Color getCanvasBackground() {
        return this.canvasBackground;
    }

    public void setCanvasBackground(Color color) {
        if (!this.canvasBackground.equals(color)) {
            this.canvasBackground = color;
            this.markBackgroundInvalid();
        }
    }

    public Point getCanvasOrigin() {
        Insets n = this.getInsets();
        return new Point(n.left, n.top);
    }

    public Rectangle getCanvasBounds() {
        Insets n = this.getInsets();
        Dimension d = this.getCanvasSize();
        return new Rectangle(n.left, n.top, d.width, d.height);
    }

    public Dimension getCanvasSize() {
        Dimension result = this.getSize();
        Insets n = this.getInsets();
        Dimension maximum = this.getEffectiveMaximumCanvasSize();
        result.width = Math.min(maximum.width, result.width - n.left - n.right);
        result.height = Math.min(maximum.height, result.height - n.top - n.bottom);
        return result;
    }

    public Dimension getMinimumCanvasSize() {
        return (Dimension)this.minimumCanvasSize.clone();
    }

    public void setMinimumCanvasSize(Dimension value) {
        if (!value.equals(this.minimumCanvasSize)) {
            Dimension old = this.getEffectiveMaximumCanvasSize();
            this.minimumCanvasSize.setSize(value);
            this.updateEffectiveMaximumCanvasSize(old);
            this.revalidateCanvas();
        }
    }

    public Dimension getMaximumCanvasSize() {
        return (Dimension)this.maximumCanvasSize.clone();
    }

    public void setMaximumCanvasSize(Dimension value) {
        if (!value.equals(this.maximumCanvasSize)) {
            Dimension old = this.getEffectiveMaximumCanvasSize();
            this.maximumCanvasSize.setSize(value);
            this.updateEffectiveMaximumCanvasSize(old);
        }
    }

    protected Dimension getEffectiveMaximumCanvasSize() {
        Dimension result = new Dimension(this.maximumCanvasSize);
        result.width = Math.max(result.width, this.minimumCanvasSize.width);
        result.height = Math.max(result.height, this.minimumCanvasSize.height);
        return result;
    }

    private void updateEffectiveMaximumCanvasSize(Dimension oldValue) {
        if (!oldValue.equals(this.getEffectiveMaximumCanvasSize())) {
            this.rebuildImage();
            this.revalidateCanvas();
            this.repaint();
        }
    }

    protected Point toGraphCoordinates(Point p) {
        Insets n = this.getInsets();
        return new Point(p.x - n.left, p.y - n.top);
    }

    protected Point toComponentCoordinates(Point p) {
        Insets n = this.getInsets();
        return new Point(p.x + n.left, p.y + n.top);
    }

    protected Rectangle toComponentCoordinates(Rectangle r) {
        Rectangle result = new Rectangle(r);
        result.setLocation(this.toComponentCoordinates(r.getLocation()));
        return result;
    }

    protected Rectangle getScreenBounds(JaxoObject o) {
        Rectangle bounds = this.toComponentCoordinates(o.getBounds());
        Point p = this.getLocationOnScreen();
        return new Rectangle(p.x + bounds.x, p.y + bounds.y, bounds.width, bounds.height);
    }

    public JaxoZoom getZoom() {
        return this.zoom;
    }

    protected JaxoPaintableGrid getGrid() {
        return this.grid;
    }

    public void setGrid(JaxoPaintableGrid value) {
        if (value != this.grid) {
            if (this.grid != null) {
                this.grid.removeChangeListener(this.gridListener);
            }
            this.grid = value;
            if (this.grid != null) {
                this.grid.addChangeListener(this.gridListener);
            }
            this.markBackgroundInvalid();
        }
    }

    public void setCanvasGraphAndGrid(JaxoGraph newGraph, JaxoPaintableGrid newGrid) {
        this.setCanvasGraph(newGraph);
        if (this.grid == null) {
            this.setGrid(newGrid);
        } else if (newGrid != this.grid) {
            this.setGrid(newGrid);
            this.revalidateCanvas();
        }
    }

    private boolean isSnappingToGrid() {
        if (this.grid != null) {
            return this.grid.isSnapping();
        }
        return false;
    }

    protected boolean isAntialiasEnabled() {
        return this.antialiasEnabled;
    }

    public void setAntialiasEnabled(boolean value) {
        if (this.antialiasEnabled != value) {
            this.antialiasEnabled = value;
            this.markImageInvalid();
        }
    }

    public Dimension getPreferredScrollableViewportSize() {
        Dimension result = this.getMinimumCanvasSize();
        JaxoGeometry.grow(result, this.getInsets());
        return result;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 6;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 0 ? visibleRect.width : visibleRect.height;
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.getParent() instanceof JViewport && this.getParent().getWidth() > this.getPreferredSize().width;
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getParent() instanceof JViewport && this.getParent().getHeight() > this.getPreferredSize().height;
    }

    protected boolean canPasteGraphFromSystemClipboard() {
        return this.clipboard.canPasteGraphFromSystemClipboard();
    }

    protected JaxoGraph getSystemClipboardGraph() {
        return this.clipboard.getSystemClipboardGraph();
    }

    protected void putToSystemClipboard(JaxoGraph g) {
        this.clipboard.putToSystemClipboard(g);
    }

    public JaxoGraph getClipboard() {
        return new JaxoGraph(this.canvasGraph.getCopyOfMarkedObjects());
    }

    protected void markBackgroundInvalid() {
        this.markImageInvalid();
    }

    public void markImageInvalid() {
        this.markImageInvalid(null);
    }

    protected void paintBackgroundAndGrid(Graphics2D g, Rectangle rect) {
        g.clipRect(rect.x, rect.y, rect.width, rect.height);
        if (this.grid == null || this.grid.getTransparency() != 1) {
            g.setColor(this.getCanvasBackground());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
        }
        if (this.grid != null) {
            this.grid.setCanvasSize(this.getEffectiveMaximumCanvasSize());
            this.grid.paint(g);
        }
    }

    protected void snapPoint(Point p) {
        if (this.isSnappingToGrid()) {
            this.grid.snapPoint(p);
        }
    }

    protected void snapObject(JaxoObject o) {
        if (this.isSnappingToGrid() && !(o instanceof JaxoGroup)) {
            Point p = new Point(o.getX(), o.getY());
            Point q = new Point(p);
            this.grid.snapPoint(q);
            o.moveBy(q.x - p.x, q.y - p.y);
        }
    }

    private ChangeListener getNewGridListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                AbstractJaxoCanvas.this.markBackgroundInvalid();
            }
        };
    }

    public void updateLanguage() {
        this.fboxPopup.updateLanguage();
        this.colorChooser.updateLanguage();
    }

    private void resetColorChoser() {
        this.colorChooser = new JaxoColorChooser(this.asComponent());
        this.colorChooser.setPermanent(true);
    }

    protected void repaintBoundingBox(Rectangle2D r) {
        Rectangle s = this.toComponentCoordinates(r.getBounds());
        JaxoGeometry.grow(s, COMPONENT_REPAINT_PADDING);
        this.repaint(s);
    }

    protected boolean showColorPanel(JaxoObject ob) {
        Rectangle screenBounds = this.getScreenBounds(ob);
        Location.RelativeToAvoiding location = new Location.RelativeToAvoiding(this.asComponent(), screenBounds);
        int colorMode = JaxoPrefs.getIntPref("prefCOLORSPACE");
        if (ob instanceof JaxoFillColorObject && ((JaxoFillColorObject)((Object)ob)).isFilled()) {
            final JaxoFillColorObject fillObject = (JaxoFillColorObject)((Object)ob);
            this.colorChooser.setMode(colorMode == 2 ? 2 : 0);
            this.colorChooser.setOptional(false);
            this.colorChooser.setColor(fillObject.getFillColor());
            this.colorChooser.addChangeListener(new ColorChooserListener(ob){

                protected void setColor(Color c) {
                    fillObject.setFillColor(c);
                }
            });
            this.colorChooser.show(location);
            if (this.colorChooser.hasChanged() && JaxoColor.isGrayScale(this.colorChooser.getColor())) {
                ob.setColor(JaxoColor.BLACK);
            }
        } else if (ob instanceof JaxoGroup) {
            this.colorChooser.setMode(colorMode == 2 ? 2 : 1);
            final JaxoGroup g = (JaxoGroup)ob;
            final JaxoList<JaxoObject> oldContents = g.getObjectList();
            final JaxoList<JaxoObject> tmpContents = oldContents.copyOf();
            this.colorChooser.setOptionalColor(g.getColor());
            this.colorChooser.addChangeListener(new ColorChooserListener(g){

                protected void setColor(Color c) {
                    if (c == null) {
                        g.setObjectList(oldContents);
                    } else {
                        g.setObjectList(tmpContents);
                        g.setColor(c);
                    }
                }
            });
            this.colorChooser.show(location);
            g.setObjectList(oldContents);
            if (this.colorChooser.hasChanged() && this.colorChooser.getColor() != null) {
                g.setColor(this.colorChooser.getColor());
            }
        } else {
            this.colorChooser.setMode(colorMode == 2 ? 2 : (ob instanceof JaxoPSText ? 0 : 1));
            this.colorChooser.setOptional(false);
            this.colorChooser.setColor(ob.getColor());
            this.colorChooser.addChangeListener(new ColorChooserListener(ob));
            this.colorChooser.show(location);
        }
        return this.colorChooser.hasChanged();
    }

    protected boolean showSelectionPanel(Point location) {
        boolean canPaste = this.canPasteGraphFromSystemClipboard();
        if (this.getCanvasGraph().containsMarkedObjects()) {
            this.fboxPopup.setMenuItemEnabled(1, canPaste);
            this.fboxPopup.setMenuItemEnabled(2, this.getCanvasGraph().containsMarkedGroups());
            this.fboxPopup.setMenuItemEnabled(3, this.getCanvasGraph().hasMoreMarkedObjectsThan(1));
            this.fboxPopup.normalPopup();
            this.fboxPopup.show(this, location.x, location.y);
        } else if (canPaste) {
            this.fboxPopup.setMenuItemEnabled(1, true);
            this.fboxPopup.onlyPastePopup();
            this.fboxPopup.show(this, location.x, location.y);
        } else {
            return false;
        }
        return true;
    }

    protected boolean showEditPanel(JaxoObject o) {
        int old = this.getHandlePaintMode();
        this.setHandlePaintMode(2);
        JaxoOptionsPanel p = new JaxoOptionsPanel(o);
        p.addChangeListener(new EditPanelListener());
        Rectangle screenBounds = this.getScreenBounds(o);
        Location.RelativeToAvoiding l = new Location.RelativeToAvoiding(this.asComponent(), screenBounds);
        p.show(this.asComponent(), l);
        this.setHandlePaintMode(old);
        return p.hasChanged();
    }

    protected abstract void revalidateCanvas();

    protected abstract void rebuildImage();

    protected abstract void deleteMarkedObjects();

    protected abstract void updateMode(int var1);

    private class EditPanelListener
    implements ChangeListener {
        private EditPanelListener() {
        }

        public void stateChanged(ChangeEvent evt) {
            this.repaintObject();
        }

        private void repaintObject() {
            AbstractJaxoCanvas.this.repaint();
        }
    }

    private class ColorChooserListener
    implements ChangeListener {
        private final JaxoObject object;

        ColorChooserListener(JaxoObject o) {
            this.object = o;
        }

        protected final JaxoObject object() {
            return this.object;
        }

        public void stateChanged(ChangeEvent e) {
            this.setColor(AbstractJaxoCanvas.this.colorChooser.getColor());
            AbstractJaxoCanvas.this.repaintBoundingBox(this.object.getBounds());
            if (!AbstractJaxoCanvas.this.colorChooser.isAdjusting()) {
                AbstractJaxoCanvas.this.colorChooser.removeChangeListener(this);
            }
        }

        protected void setColor(Color c) {
            this.object.setColor(c);
        }
    }
}

