/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.util.JaxoLog;

public class JaxoClipboard {
    private static final DataFlavor GRAPH_FLAVOR = new DataFlavor("application/x-jaxodraw-graph;class=" + JaxoGraph.class.getName() + ";version=2", "JaxoDraw graph");
    private transient Clipboard fakeSystemClipboard;
    private final Component parentC;

    public JaxoClipboard(Component parent) {
        this.parentC = parent;
    }

    protected boolean canPasteGraphFromSystemClipboard() {
        Clipboard c = this.getSystemClipboard();
        try {
            return c.isDataFlavorAvailable(GRAPH_FLAVOR);
        }
        catch (IllegalStateException e) {
            JaxoLog.debug(e);
            return false;
        }
    }

    protected JaxoGraph getSystemClipboardGraph() {
        Clipboard c = this.getSystemClipboard();
        try {
            Transferable t = c.getContents(this);
            return (JaxoGraph)t.getTransferData(GRAPH_FLAVOR);
        }
        catch (IllegalStateException e) {
            this.systemClipboardUnavailable();
            return null;
        }
        catch (UnsupportedFlavorException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void putToSystemClipboard(JaxoGraph g) {
        JaxoGraph graph = g.copyOf();
        ClipboardTransferable t = new ClipboardTransferable(graph);
        try {
            this.getSystemClipboard().setContents(t, null);
        }
        catch (IllegalStateException e) {
            JaxoLog.debug(e);
            this.systemClipboardUnavailable();
        }
    }

    private Clipboard getSystemClipboard() {
        if (this.fakeSystemClipboard != null) {
            return this.fakeSystemClipboard;
        }
        try {
            return this.parentC.getToolkit().getSystemClipboard();
        }
        catch (SecurityException e) {
            this.fakeSystemClipboard = new Clipboard("JaxoDraw");
            return this.fakeSystemClipboard;
        }
    }

    private void systemClipboardUnavailable() {
        this.parentC.getToolkit().beep();
    }

    private static class ClipboardTransferable
    implements Transferable {
        private final JaxoGraph jaxoGraph;

        ClipboardTransferable(JaxoGraph graph) {
            this.jaxoGraph = graph;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{GRAPH_FLAVOR};
        }

        public boolean isDataFlavorSupported(DataFlavor f) {
            return f.equals(GRAPH_FLAVOR);
        }

        public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(f)) {
                throw new UnsupportedFlavorException(f);
            }
            return this.jaxoGraph.copyOf();
        }
    }
}

