/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.menu.popup;

import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoLooknFeel;

public class JaxoZoomPopupMenu
extends JPopupMenu
implements JaxoLocalized {
    private static final long serialVersionUID = 7526471155622776147L;
    private final JMenu zoomFactorM = new JMenu();
    private final JRadioButtonMenuItem zoom2;
    private final JRadioButtonMenuItem zoom4;
    private final JRadioButtonMenuItem zoom8;

    public JaxoZoomPopupMenu() {
        this.zoomFactorM.setActionCommand(JaxoConstants.getModeAsString(791));
        ButtonGroup zoomFactorGroup = new ButtonGroup();
        this.zoom2 = new JRadioButtonMenuItem();
        this.zoom2.setActionCommand(JaxoConstants.getModeAsString(792));
        this.zoom4 = new JRadioButtonMenuItem();
        this.zoom4.setActionCommand(JaxoConstants.getModeAsString(793));
        this.zoom8 = new JRadioButtonMenuItem();
        this.zoom8.setActionCommand(JaxoConstants.getModeAsString(794));
        zoomFactorGroup.add(this.zoom2);
        zoomFactorGroup.add(this.zoom4);
        zoomFactorGroup.add(this.zoom8);
        this.zoomFactorM.add(this.zoom2);
        this.zoomFactorM.add(this.zoom4);
        this.zoomFactorM.add(this.zoom8);
        this.zoom2.setSelected(true);
        this.add(this.zoomFactorM);
        this.updateLanguage();
        JaxoLooknFeel.registerComponent(this);
    }

    public void setZoomFactor(int value) {
        if (value <= 2) {
            this.zoom2.setSelected(true);
        } else if (value <= 4) {
            this.zoom4.setSelected(true);
        } else {
            this.zoom8.setSelected(true);
        }
    }

    public void addActionListener(ActionListener l) {
        this.zoomFactorM.addActionListener(l);
        this.zoom2.addActionListener(l);
        this.zoom4.addActionListener(l);
        this.zoom8.addActionListener(l);
    }

    public final void updateLanguage() {
        this.zoomFactorM.setText(JaxoLanguage.translate("JaxoZoom.factor"));
        this.zoom2.setText(JaxoLanguage.message("JaxoZoom.factor.%0", 2));
        this.zoom4.setText(JaxoLanguage.message("JaxoZoom.factor.%0", 4));
        this.zoom8.setText(JaxoLanguage.message("JaxoZoom.factor.%0", 8));
    }
}

