/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.io.JaxoIO;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoPrefs;

public class JaxoChooseFile {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoChooseFile.class);
    private Component parent;
    private String approveText;
    private String dialogTitle;

    public JaxoChooseFile(Component parentc) {
        this(parentc, null);
    }

    public JaxoChooseFile(Component parentc, String text) {
        this.parent = parentc;
        this.approveText = text;
    }

    public final Component getComponentParent() {
        return this.parent;
    }

    public void setComponentParent(Component value) {
        this.parent = value;
    }

    public final String getApproveText() {
        return this.approveText;
    }

    public void setApproveText(String value) {
        this.approveText = value;
    }

    public final String getDialogTitle() {
        return this.dialogTitle == null ? this.approveText : this.dialogTitle;
    }

    public void setDialogTitle(String value) {
        this.dialogTitle = value;
    }

    public final String chooseFile(String[] allowedExtensions, String description, String selectedFile) {
        String fileName = "";
        JFileChooser chooser = new JFileChooser(JaxoPrefs.getStringPref("prefUSERDIR"));
        if (allowedExtensions != null) {
            chooser.setFileFilter(new ExtensionFilter(allowedExtensions, description));
        }
        chooser.setSelectedFile(new File(selectedFile));
        chooser.setApproveButtonText(this.approveText);
        chooser.setDialogTitle(JaxoDialogs.translatedWindowTitle(this.dialogTitle == null ? LANGUAGE.value("defaultTitle") : this.dialogTitle));
        int returnVal = chooser.showDialog(this.parent, chooser.getApproveButtonText());
        if (returnVal == 0) {
            fileName = chooser.getSelectedFile().getAbsolutePath();
            JaxoPrefs.setStringPref("prefUSERDIR", chooser.getSelectedFile().getParent());
        }
        return fileName;
    }

    private static class ExtensionFilter
    extends FileFilter {
        private final Set<String> extensions;
        private final String description;

        ExtensionFilter(String[] ext, String desc) {
            this.extensions = new HashSet<String>(ext.length);
            for (int i = 0; i < ext.length; ++i) {
                this.extensions.add(ext[i].toLowerCase(Locale.ENGLISH));
            }
            this.description = desc;
        }

        public final boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                if (this.extensions.contains(JaxoIO.extension(f.getName()).toLowerCase(Locale.ENGLISH))) {
                    return true;
                }
            }
            return false;
        }

        public final String getDescription() {
            return this.description;
        }
    }
}

