/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.panel.JaxoChooseFile;
import net.sf.jaxodraw.gui.swing.JaxoTitledBorder;
import net.sf.jaxodraw.io.exports.JaxoExport;
import net.sf.jaxodraw.io.imports.JaxoImport;
import net.sf.jaxodraw.plugin.JaxoPlugin;
import net.sf.jaxodraw.plugin.JaxoPluginInfo;
import net.sf.jaxodraw.plugin.JaxoPluginLoader;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLanguage;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoLog;

public class JaxoPluginManagerPanel
implements ListSelectionListener,
JaxoLocalized {
    private JDialog dialog;
    private List<Object> plugins;
    private final DefaultListModel listModel = new DefaultListModel();
    private final JTextArea describeArea = new JTextArea(5, 20);
    private JList list;
    private final JButton uninstallButton = new JButton();
    private final JButton installButton = new JButton();
    private final JButton closeButton = new JButton();
    private JPanel namePanel;
    private JPanel describePanel;
    private JPanel pluginPanel;

    public JaxoPluginManagerPanel(Component parent) {
        this.initListOfPlugins();
        this.initListModel();
        this.initComponents(parent);
    }

    public void setVisible(boolean b) {
        this.dialog.setVisible(b);
    }

    public final void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            int[] indices = this.list.getSelectedIndices();
            if (indices.length == 1) {
                this.uninstallButton.setEnabled(true);
                JaxoPlugin selected = (JaxoPlugin)this.plugins.get(indices[0]);
                String version = selected.version();
                String description = selected.description();
                String text = JaxoLanguage.translate("Name") + ": " + selected.pluginName() + "\n\n" + JaxoLanguage.translate("Version") + ": " + version + "\n\n\n" + description;
                this.describeArea.setText(text);
            } else {
                this.uninstallButton.setEnabled(indices.length != 0);
                this.describeArea.setText("");
            }
        }
    }

    private void initListOfPlugins() {
        this.plugins = JaxoPluginInfo.getPluginInfo().getExportFormats();
        this.plugins.removeAll(JaxoExport.getBuiltInFormats());
        this.plugins.addAll(JaxoPluginInfo.getPluginInfo().getImportFormats());
        this.plugins.removeAll(JaxoImport.getBuiltInFormats());
    }

    private void initListModel() {
        for (int i = 0; i < this.plugins.size(); ++i) {
            this.listModel.add(i, ((JaxoPlugin)this.plugins.get(i)).pluginName());
        }
    }

    private void initComponents(Component parent) {
        this.list = new JList(this.listModel);
        this.list.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.list.addListSelectionListener(this);
        this.setupPluginPanel();
        JPanel buttonPanel = this.getButtonPanel();
        this.dialog = JaxoDialogs.newDialog(parent, JaxoDialogs.windowTitle("JaxoPluginManagerPanel.title"), true);
        this.dialog.getContentPane().add((Component)this.pluginPanel, "Center");
        this.dialog.getContentPane().add((Component)buttonPanel, "Last");
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(parent);
    }

    private void setupPluginPanel() {
        JScrollPane listScrollPane = new JScrollPane(this.list);
        this.namePanel = JaxoDialogs.newTitledBorderLayoutPanel("JaxoPluginManagerPanel.namePanel.title");
        this.namePanel.add(listScrollPane);
        this.describeArea.setEditable(false);
        this.describeArea.setLineWrap(true);
        this.describeArea.setWrapStyleWord(true);
        this.describeArea.setMargin(new Insets(5, 5, 5, 5));
        JScrollPane describeScrollPane = new JScrollPane(this.describeArea);
        this.describePanel = JaxoDialogs.newTitledBorderLayoutPanel("JaxoPluginManagerPanel.describePanel.title");
        this.describePanel.add(describeScrollPane);
        this.pluginPanel = JaxoDialogs.newTitledBorderLayoutPanel("JaxoPluginManagerPanel.pluginPanel.title");
        this.pluginPanel.add((Component)this.namePanel, "West");
        this.pluginPanel.add((Component)this.describePanel, "East");
    }

    private JPanel getButtonPanel() {
        this.installButton.setText(JaxoLanguage.translate("JaxoPluginManagerPanel.buttonPanel.install"));
        this.installButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoPluginManagerPanel.this.installButtonClicked();
            }
        });
        this.installButton.setEnabled(true);
        this.uninstallButton.setText(JaxoLanguage.translate("JaxoPluginManagerPanel.buttonPanel.uninstall"));
        this.uninstallButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoPluginManagerPanel.this.removeButtonClicked();
            }
        });
        this.uninstallButton.setEnabled(false);
        this.closeButton.setText(JaxoLanguage.translate("Close"));
        this.closeButton.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                JaxoPluginManagerPanel.this.list.clearSelection();
                JaxoPluginManagerPanel.this.setVisible(false);
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.uninstallButton);
        buttonPanel.add(Box.createHorizontalStrut(60));
        buttonPanel.add(this.installButton);
        buttonPanel.add(Box.createHorizontalStrut(20));
        buttonPanel.add(this.closeButton);
        return buttonPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installButtonClicked() {
        JaxoChooseFile c = new JaxoChooseFile(this.dialog);
        c.setApproveText(JaxoLanguage.translate("OK"));
        String fileName = c.chooseFile(new String[]{"jar"}, "Java Archives", "").trim();
        if (fileName.length() == 0) {
            return;
        }
        JaxoPluginLoader pluginLoader = new JaxoPluginLoader();
        List<JaxoPlugin> loadedPlugins = pluginLoader.loadPluginsFromJar(fileName);
        if (loadedPlugins == null) {
            JOptionPane.showMessageDialog(this.dialog, JaxoLanguage.translate("JaxoPluginManagerPanel.error.loading.check.logs"), JaxoLanguage.translate("JaxoPluginManagerPanel.install.error.title"), 0);
            return;
        }
        for (JaxoPlugin loadedPlugin : loadedPlugins) {
            JaxoPluginInfo.getPluginInfo().addPlugin(loadedPlugin);
            this.listModel.addElement(loadedPlugin.pluginName());
        }
        this.initListOfPlugins();
        File jarFile = new File(fileName);
        File destFile = new File(JaxoInfo.PLUGIN_DIR, jarFile.getName());
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(jarFile);
            out = new FileOutputStream(destFile);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (IOException ex) {
            JaxoLog.debug("Could not install plugin in: " + JaxoInfo.PLUGIN_DIR, ex);
            JOptionPane.showMessageDialog(this.dialog, JaxoLanguage.message("JaxoPluginManagerPanel.install.error%0", JaxoInfo.PLUGIN_DIR), JaxoLanguage.translate("JaxoPluginManagerPanel.install.error.title"), 0);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException ex) {
                JaxoLog.debug(ex);
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ex) {
                JaxoLog.debug(ex);
            }
        }
    }

    private void removeButtonClicked() {
        int[] indices = this.list.getSelectedIndices();
        JaxoPlugin[] toRemove = new JaxoPlugin[indices.length];
        StringBuffer pluginNames = new StringBuffer(128);
        pluginNames.append(' ');
        for (int i = 0; i < indices.length; ++i) {
            toRemove[i] = (JaxoPlugin)this.plugins.get(indices[i]);
            pluginNames.append(toRemove[i].pluginName());
            if (i == indices.length - 1) continue;
            pluginNames.append(", ");
        }
        int n = JOptionPane.showConfirmDialog(this.dialog, JaxoLanguage.translate("JaxoPluginManagerPanel.confirm.remove") + pluginNames.toString() + "?", JaxoLanguage.translate("JaxoPluginManagerPanel.buttonPanel.uninstall"), 0, 3);
        if (n == 1) {
            return;
        }
        for (int i = toRemove.length - 1; i >= 0; --i) {
            File jar = JaxoPluginLoader.getPluginJar(toRemove[i], JaxoInfo.PLUGIN_DIR);
            if (jar == null) continue;
            if (jar.delete()) {
                JaxoLog.debug("Deleted: " + jar.getAbsolutePath());
                JaxoLog.info("Successfully removed " + toRemove[i].pluginName());
                continue;
            }
            JaxoLog.debug("Failed to delete: " + jar.getAbsolutePath());
            JOptionPane.showMessageDialog(this.dialog, JaxoLanguage.message("JaxoPluginManagerPanel.uninstall.error%0", jar.getAbsolutePath()), JaxoLanguage.translate("JaxoPluginManagerPanel.uninstall.error.title"), 0);
        }
        JaxoLog.info("Re-scanning plugin dir...");
        JaxoPluginInfo.getPluginInfo().reValidate();
        this.initListOfPlugins();
        this.listModel.clear();
        this.initListModel();
    }

    public void updateLanguage() {
        this.installButton.setText(JaxoLanguage.translate("JaxoPluginManagerPanel.buttonPanel.install"));
        this.uninstallButton.setText(JaxoLanguage.translate("JaxoPluginManagerPanel.buttonPanel.uninstall"));
        this.closeButton.setText(JaxoLanguage.translate("Close"));
        ((JaxoTitledBorder)this.pluginPanel.getBorder()).setTitle(JaxoLanguage.translate("JaxoPluginManagerPanel.pluginPanel.title"));
        ((JaxoTitledBorder)this.describePanel.getBorder()).setTitle(JaxoLanguage.translate("JaxoPluginManagerPanel.describePanel.title"));
        ((JaxoTitledBorder)this.namePanel.getBorder()).setTitle(JaxoLanguage.translate("JaxoPluginManagerPanel.namePanel.title"));
    }
}

