/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.JaxoCanvas;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.gui.JaxoDrawingArea;
import net.sf.jaxodraw.gui.JaxoTab;
import net.sf.jaxodraw.gui.menu.popup.JaxoCanvasPopupMenu;
import net.sf.jaxodraw.gui.panel.JaxoCommunicator;
import net.sf.jaxodraw.gui.panel.JaxoExportPanel;
import net.sf.jaxodraw.gui.panel.JaxoImportPanel;
import net.sf.jaxodraw.gui.panel.JaxoLatexPackage;
import net.sf.jaxodraw.gui.panel.JaxoLatexTextToolTip;
import net.sf.jaxodraw.gui.panel.JaxoMoveGraph;
import net.sf.jaxodraw.gui.panel.JaxoUserGuide;
import net.sf.jaxodraw.gui.panel.button.JaxoButtonPanel;
import net.sf.jaxodraw.gui.swing.JaxoClosableTabbedPane;
import net.sf.jaxodraw.gui.swing.TabClosingEvent;
import net.sf.jaxodraw.gui.swing.TabClosingListener;
import net.sf.jaxodraw.io.JaxoIO;
import net.sf.jaxodraw.io.JaxoPreview;
import net.sf.jaxodraw.io.JaxoPrint;
import net.sf.jaxodraw.io.exports.JaxoExportLatexPS;
import net.sf.jaxodraw.plugin.JaxoImportPlugin;
import net.sf.jaxodraw.plugin.JaxoPluginInfo;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoConstants;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoLocalized;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoSoundsHandler;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoTabbedCanvasPanel
extends MouseAdapter
implements ActionListener,
PropertyChangeListener,
JaxoLocalized {
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoTabbedCanvasPanel.class);
    private static final String SNAP = "Jaxo.snap";
    private final JaxoCommunicator thePanel;
    private final Component parentComponent;
    private final JaxoCanvasPopupMenu canvasPopup;
    private final JPanel root;
    private final JaxoIO io;
    private final JaxoClosableTabbedPane tabbedPane;
    private JaxoTab selectedTab;
    private final Icon modifiedIcon = JaxoUtils.newImageIcon("modified.png");
    private final Icon unmodifiedIcon = JaxoUtils.newImageIcon("unmodified.png");
    private final ChangeListener tabListener;
    private JaxoExportPanel exportPanel;
    private JaxoImportPanel importPanel;
    private final Map<String, Integer> nameIndex = new HashMap<String, Integer>(16);
    private final Map<JaxoTab, TabInfo> tabInfos = new HashMap<JaxoTab, TabInfo>(16);
    private final JaxoPreview preview;
    private final JaxoDrawingArea theCanvas;
    private final JaxoLatexTextToolTip latexTextToolTip = new JaxoLatexTextToolTip();
    private boolean watchMode;
    private boolean antialiasEnabled;
    private boolean canUndo;
    private boolean canRedo;
    private int currentMode = 0;
    private int vertexType = 336;

    public JaxoTabbedCanvasPanel(JaxoCommunicator panel, Component parent) {
        this.thePanel = panel;
        this.parentComponent = parent;
        this.io = new JaxoIO(this.parentComponent);
        this.preview = new JaxoPreview(this.parentComponent);
        this.root = new JPanel(new BorderLayout(), false);
        this.root.setBorder(JaxoButtonPanel.RAISED_ETCHED_BORDER);
        this.tabbedPane = new JaxoClosableTabbedPane();
        this.root.add(this.tabbedPane);
        this.theCanvas = new JaxoCanvas(this);
        this.theCanvas.setMinimumCanvasSize(new Dimension(JaxoPrefs.getIntPref("prefSCREENSIZEX"), JaxoPrefs.getIntPref("prefSCREENSIZEY")));
        this.theCanvas.setMaximumCanvasSize(JaxoInfo.SCREEN_SIZE);
        this.theCanvas.setCanvasBackground(JaxoColor.getColor(JaxoPrefs.getStringPref("prefCANVASBACKGROUND"), 2));
        this.canvasPopup = new JaxoCanvasPopupMenu(this.thePanel);
        this.tabbedPane.addClosingListener(new TabClosingListener(){

            public void closing(TabClosingEvent e) {
                JaxoTabbedCanvasPanel.this.setSelectedTabIndex(e.getIndex());
                JaxoTabbedCanvasPanel.this.closing();
            }
        });
        this.tabbedPane.addMouseListener(this);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JaxoTabbedCanvasPanel.this.updateSelectedTab();
            }
        });
        this.tabListener = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JaxoTab t = (JaxoTab)e.getSource();
                JaxoTabbedCanvasPanel.this.updateSaveState(t);
                JaxoTabbedCanvasPanel.this.tabChanged(t);
            }
        };
        this.aNewT();
        this.setupLatexTextToolTip();
        this.resetMode();
    }

    private void setupLatexTextToolTip() {
        this.latexTextToolTip.setGraph(this.getSelectedTab().getTabGraph());
        this.theCanvas.addMouseListener(this.latexTextToolTip);
        this.theCanvas.addMouseMotionListener(this.latexTextToolTip);
    }

    public JaxoDrawingArea getCanvas() {
        return this.theCanvas;
    }

    private void initExportPanel() {
        this.exportPanel = new JaxoExportPanel(this.parentComponent, JaxoPluginInfo.getPluginInfo().getExportFormats(), this.preview);
    }

    private void initImportPanel() {
        this.importPanel = new JaxoImportPanel(this.parentComponent, JaxoPluginInfo.getPluginInfo().getImportFormats());
    }

    public final JComponent getRoot() {
        return this.root;
    }

    public final int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public final JaxoTab getTabAt(int index) {
        return JaxoTab.asJaxoTab(this.tabbedPane.getComponentAt(index));
    }

    public int getTabIndex(JaxoTab t) {
        return this.tabbedPane.indexOfComponent(t.getRoot());
    }

    public final JaxoTab getSelectedTab() {
        return JaxoTab.asJaxoTab(this.tabbedPane.getSelectedComponent());
    }

    public void setSelectedTab(JaxoTab value) {
        this.tabbedPane.setSelectedComponent(value == null ? null : value.getRoot());
    }

    private void setSelectedTabIndex(int value) {
        this.tabbedPane.setSelectedIndex(value);
    }

    public final JaxoTab getTabWithSaveFileName(String name) {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            if (!this.getTabAt(i).getTabGraph().getSaveFileName().equals(name)) continue;
            return this.getTabAt(i);
        }
        return null;
    }

    private void updateSaveState(JaxoTab t) {
        int index = this.getTabIndex(t);
        this.tabbedPane.setClosableIconAt(index, t.isSaved() ? this.unmodifiedIcon : this.modifiedIcon);
        this.tabbedPane.setFontStyleAt(index, t.getSaveFileName().length() > 0 ? 1 : 0);
    }

    private void updateSelectedTab() {
        JaxoTab t = this.getSelectedTab();
        if (t != this.selectedTab) {
            JaxoTab old = this.selectedTab;
            this.selectedTab = t;
            if (this.selectedTab != null) {
                this.selectedTab.revalidate();
            }
            if (old != null) {
                this.updateSelectedTab(old, t);
            }
            this.latexTextToolTip.setGraph(t.getTabGraph());
        }
    }

    private TabInfo info(JaxoTab t) {
        return this.tabInfos.get(t);
    }

    private String getName(JaxoTab t) {
        TabInfo n = this.info(t);
        return n == null ? null : n.getName();
    }

    private boolean isUntitled(JaxoTab t) {
        return this.info(t).isUntitled();
    }

    private void setUntitled(JaxoTab t, boolean value) {
        this.info(t).setUntitled(value);
    }

    private void setNameAndIndex(JaxoTab t, String name) {
        Integer count;
        String old = this.getName(t);
        if (old == null ? name == null : old.equals(name)) {
            return;
        }
        TabInfo n = this.info(t);
        if (n != null && n.getName() != null) {
            int count2 = 0;
            int max = -1;
            for (int i = this.getTabCount() - 1; i >= 0; --i) {
                TabInfo n2 = this.info(this.getTabAt(i));
                if (!n.getName().equals(n2.getName())) continue;
                if (n2 != n) {
                    max = Math.max(max, n2.getIndex());
                }
                ++count2;
            }
            if (count2 < 2) {
                this.nameIndex.remove(n.getName());
            } else {
                this.nameIndex.put(n.getName(), max);
            }
        }
        if (name == null) {
            count = 0;
        } else {
            count = this.nameIndex.get(name);
            count = count == null ? Integer.valueOf(0) : Integer.valueOf(count + 1);
            this.nameIndex.put(name, count);
        }
        TabInfo nn = this.info(t);
        if (nn == null) {
            nn = new TabInfo();
            this.tabInfos.put(t, nn);
        }
        nn.setName(name);
        nn.setIndex(count);
        this.updateTabTitle(t);
    }

    private void updateTabTitle(JaxoTab t) {
        TabInfo n = this.info(t);
        if (n.getIndex() > 0) {
            t.setTabTitle(LANGUAGE.message("tabTitle%0No%1", n.getName(), n.getIndex()));
        } else {
            t.setTabTitle(LANGUAGE.message("tabTitle%0", n.getName()));
        }
    }

    private void pushTabTitle(JaxoTab t) {
        int index = this.getTabIndex(t);
        this.tabbedPane.setClosableTitleAt(index, t.getTabTitle());
    }

    public final void updateLanguage() {
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            JaxoTab t = this.getTabAt(i);
            TabInfo n = this.info(t);
            if (n.isUntitled()) {
                this.setNameAndIndex(t, LANGUAGE.value("untitled"));
            } else {
                this.updateTabTitle(t);
            }
            this.tabbedPane.setClosableTitleAt(i, t.getTabTitle());
        }
        this.canvasPopup.updateLanguage();
        this.theCanvas.updateLanguage();
        if (this.exportPanel != null) {
            this.exportPanel.updateLanguage();
        }
        if (this.importPanel != null) {
            this.importPanel.updateLanguage();
        }
    }

    private void actionEvent(int i) {
        switch (i) {
            case 1101: {
                this.getSelectedTab().undoMove();
                break;
            }
            case 1103: {
                this.getSelectedTab().redoMove();
                break;
            }
            case 1102: {
                this.theCanvas.clear();
                break;
            }
            case 1111: {
                this.theCanvas.cutMarkedObjects();
                break;
            }
            case 1112: {
                this.theCanvas.copyMarkedObjects();
                break;
            }
            case 1113: {
                this.theCanvas.groupMarkedObjects();
                break;
            }
            case 1114: {
                this.theCanvas.ungroupMarkedObjects();
                break;
            }
            case 1115: {
                this.theCanvas.moveSelection(false);
                break;
            }
            case 1116: {
                this.theCanvas.moveSelection(true);
                break;
            }
            case 1105: {
                this.theCanvas.pasteFromClipboard();
                break;
            }
            case 1104: {
                this.theCanvas.refresh();
                break;
            }
            case 1108: {
                JaxoExportLatexPS l = new JaxoExportLatexPS();
                l.setParentComponent(this.root);
                l.setGraph(this.getSelectedTab().getTabGraph());
                l.preview(this.preview.copy(), this.isWatchMode());
                break;
            }
            case 1109: {
                this.setWatchMode(!this.isWatchMode());
                break;
            }
            case 1110: {
                this.renameTab();
                break;
            }
            case 1106: {
                String s = JaxoDialogs.getDescription(this.root, this.getSelectedTab().getTabGraph().getDescription());
                if (s == null) break;
                this.getSelectedTab().getTabGraph().setDescription(s);
                this.commitGraphChanges();
                break;
            }
            case 1118: {
                JaxoMoveGraph g = new JaxoMoveGraph(this.root, this.theCanvas);
                g.show();
                if (!g.hasChanged()) break;
                this.commitGraphChanges();
                break;
            }
            case 1107: {
                JaxoLatexPackage latexPackage = new JaxoLatexPackage(this.root, this.getSelectedTab().getTabGraph().getPackageList());
                if (latexPackage.wasCancelled()) break;
                this.commitGraphChanges();
                break;
            }
            case 1117: {
                JaxoExportLatexPS lps = new JaxoExportLatexPS();
                lps.setParentComponent(this.root);
                lps.setGraph(this.theCanvas.getClipboard());
                lps.preview(this.preview.copy(), this.isWatchMode());
                break;
            }
        }
    }

    private void commitGraphChanges() {
        this.getSelectedTab().commitGraphChanges();
    }

    private void commitRepeatableGraphChanges() {
        this.getSelectedTab().commitRepeatableGraphChanges();
    }

    private void commitRepeatableGraphChanges(int count) {
        this.getSelectedTab().commitRepeatableGraphChanges(count);
    }

    private void fileEvent(int i) {
        switch (i) {
            case 570: {
                this.aNewG();
                break;
            }
            case 580: {
                this.aNewT();
                break;
            }
            case 571: {
                this.open();
                break;
            }
            case 581: {
                this.importGraph();
                break;
            }
            case 578: {
                this.closing();
                break;
            }
            case 572: {
                this.save();
                break;
            }
            case 573: {
                this.saveAs();
                break;
            }
            case 582: {
                this.save(true, this.theCanvas.getClipboard(), LANGUAGE.value("selection"));
                break;
            }
            case 575: {
                this.export();
                break;
            }
            case 583: {
                this.export(this.theCanvas.getClipboard(), LANGUAGE.value("selection"));
                break;
            }
            case 576: {
                this.print();
                break;
            }
            case 3163: {
                this.quit();
                break;
            }
        }
    }

    private void gridEvent(int i) {
        switch (i) {
            case 3163: {
                this.quit();
                break;
            }
            case 3162: {
                this.setMode(i);
                break;
            }
            case 3161: {
                boolean snap = !this.getSelectedTab().isSnappingToGrid();
                this.thePanel.distributePropertyChange(SNAP, !snap, snap);
                break;
            }
            case 3165: {
                this.getSelectedTab().setGridType(i);
                break;
            }
            case 3166: {
                this.getSelectedTab().setGridType(i);
                break;
            }
            case 3167: {
                this.getSelectedTab().setGridStyle(i);
                break;
            }
            case 3168: {
                this.getSelectedTab().setGridStyle(i);
                break;
            }
            case 3169: {
                this.getSelectedTab().setGridStyle(i);
                break;
            }
            case 3170: {
                this.getSelectedTab().setGridStyle(i);
                break;
            }
        }
    }

    private void helpEvent(int mode) {
        switch (mode) {
            case 2151: {
                this.about();
                break;
            }
            case 2152: {
                this.usrGuide();
                break;
            }
            case 2153: {
                this.sysInfo();
                break;
            }
            case 2154: {
                this.macReadme();
                break;
            }
        }
    }

    public void performAction(int mode) {
        if (JaxoConstants.isFileMode(mode)) {
            this.fileEvent(mode);
        } else if (JaxoConstants.isActionMode(mode)) {
            this.actionEvent(mode);
        } else if (JaxoConstants.isHelpMode(mode)) {
            this.helpEvent(mode);
        } else if (JaxoConstants.isGridMode(mode)) {
            this.gridEvent(mode);
        } else if (JaxoConstants.isEditMode(mode)) {
            this.setMode(mode);
        } else if (JaxoConstants.isParticleMode(mode)) {
            this.setMode(mode);
        } else if (JaxoConstants.isMiscMode(mode)) {
            this.setMode(mode);
        } else if (JaxoConstants.isVertexMode(mode)) {
            this.setVertexType(mode);
        }
    }

    private void renameTab() {
        JaxoTab t = this.getSelectedTab();
        String oldName = this.isUntitled(t) ? "" : this.getName(t);
        String newName = JaxoDialogs.getNewTabName(this.tabbedPane, oldName);
        if (newName.length() != 0 && !newName.equals(oldName)) {
            this.setUntitled(t, false);
            this.renameTab(t, newName);
        }
    }

    private void addTab(JaxoTab t, String name, boolean untitled, boolean use) {
        t.setTabMode(JaxoConstants.defaultActionToMode(JaxoPrefs.getIntPref("prefDEFAULTACTION")));
        boolean reuse = use;
        if (reuse) {
            reuse = this.selectedTab != null && !this.selectedTab.hasBeenUsed() && JaxoIO.shortName(this.selectedTab.getTabGraph().getSaveFileName()).length() == 0;
        }
        JaxoTab oldSelectedTab = this.selectedTab;
        this.setNameAndIndex(t, name);
        this.setUntitled(t, untitled);
        t.addChangeListener(this.tabListener);
        this.tabbedPane.addClosableTab(t.getTabTitle(), t.getRoot());
        this.updateSaveState(t);
        this.setSelectedTab(t);
        if (reuse) {
            this.removeTab(oldSelectedTab);
        }
    }

    private void renameTab(JaxoTab t, String newName) {
        this.setNameAndIndex(t, newName);
        this.pushTabTitle(t);
    }

    private void aNewG() {
        Object[] options;
        int choice;
        JaxoTab t = this.getSelectedTab();
        if (!t.isSaved() && (choice = this.showTabQuestionDialog("newGraph.title", "newGraph.message%0", t, options = new Object[]{LANGUAGE.value("newGraph.continue"), LANGUAGE.value("newGraph.cancel")})) == 0) {
            t.newGraph();
        }
    }

    private void aNewT() {
        this.addTab(new JaxoTab(this.theCanvas), LANGUAGE.value("untitled"), true, false);
    }

    private void open() {
        JaxoGraph newGraph = this.io.open();
        this.open(newGraph);
    }

    public void openOrImport(String fileName) {
        if (JaxoIO.extension(fileName).equals("xml")) {
            this.open(this.io.open(fileName));
        } else {
            JaxoImportPlugin plugin = JaxoPluginInfo.getPluginInfo().getImportForExtension(JaxoIO.extension(fileName));
            if (plugin != null) {
                this.open(plugin.importGraph(fileName));
            }
        }
    }

    private void importGraph() {
        if (this.importPanel == null) {
            this.initImportPanel();
        } else {
            this.importPanel.setImports(JaxoPluginInfo.getPluginInfo().getImportFormats());
        }
        this.importPanel.show();
        this.open(this.importPanel.getImportedGraph());
    }

    private void closing() {
        JaxoTab t = this.getSelectedTab();
        if (!t.isSaved()) {
            Object[] options = new Object[]{LANGUAGE.value("close.save"), LANGUAGE.value("close.dontSave"), LANGUAGE.value("close.cancel")};
            int choice = this.showTabQuestionDialog("close.title", "close.message%0", t, options);
            if (choice == 2) {
                return;
            }
            if (choice == 0) {
                this.save();
                if (!t.isSaved()) {
                    return;
                }
            }
        }
        this.close();
    }

    private void close() {
        JaxoTab t = this.getSelectedTab();
        if (this.getTabCount() == 1) {
            this.setNameAndIndex(t, null);
            this.aNewT();
        }
        this.removeTab(t);
    }

    private int showTabQuestionDialog(String titleKey, String messageKey, JaxoTab t, Object[] options) {
        return JOptionPane.showOptionDialog(this.parentComponent, LANGUAGE.message(messageKey, t.getTabTitle()), JaxoDialogs.windowTitle(LANGUAGE, titleKey), -1, 3, null, options, options[0]);
    }

    private void removeTab(JaxoTab t) {
        this.setNameAndIndex(t, null);
        this.tabInfos.remove(t);
        this.tabbedPane.remove(t.getRoot());
        t.removeChangeListener(this.tabListener);
        this.updateSelectedTab();
    }

    private void save() {
        this.save(false);
    }

    private void saveAs() {
        this.save(true);
    }

    private void save(boolean saveas) {
        boolean as = saveas;
        boolean suggestUntitled = true;
        JaxoTab t = this.getSelectedTab();
        String saveFileName = t.getTabGraph().getSaveFileName();
        String shortName = JaxoIO.shortName(saveFileName);
        if (this.isUntitled(t) || !JaxoIO.baseName(shortName).equals(this.getName(t))) {
            as = true;
        }
        if (as) {
            JaxoGraph jaxoGraph = t.getTabGraph();
            String string = t.getTabTitle();
            if (this.isUntitled(t)) {
                // empty if block
            }
            this.io.saveAs(jaxoGraph, string, this.getName(t));
        } else {
            this.io.save(t.getTabGraph(), t.getTabTitle(), shortName);
        }
        saveFileName = t.getTabGraph().getSaveFileName();
        shortName = JaxoIO.shortName(saveFileName);
        t.setSaveFileName(saveFileName);
        if (saveFileName.length() != 0) {
            this.thePanel.distributePropertyChange("Jaxo.recentFile", null, saveFileName);
            this.setUntitled(t, false);
            this.renameTab(t, JaxoIO.baseName(shortName));
            t.setSaved(t.getTabGraph().isSaved());
        }
    }

    private void save(boolean as, JaxoGraph g, String title) {
        if (as) {
            this.io.saveAs(g, title, "");
        } else {
            this.io.save(g, title, "");
        }
    }

    private void export() {
        JaxoTab t = this.getSelectedTab();
        this.export(t.getTabGraph(), t.getTabTitle());
    }

    private void export(JaxoGraph g, String title) {
        if (this.exportPanel == null) {
            this.initExportPanel();
        }
        this.exportPanel.setNewPreviewFrame(!this.isWatchMode());
        this.exportPanel.setExports(JaxoPluginInfo.getPluginInfo().getExportFormats());
        this.exportPanel.export(g, title);
    }

    private void print() {
        JaxoTab t = this.getSelectedTab();
        JaxoPrint p = new JaxoPrint(t.getTabGraph());
        p.print(this.parentComponent, t.getTabTitle());
    }

    private void quit() {
        boolean dontQuit = false;
        boolean saveAll = false;
        int unsavedCount = 0;
        for (int i = this.getTabCount() - 1; i > -1; --i) {
            JaxoTab t = this.getTabAt(i);
            if (t.isSaved()) continue;
            ++unsavedCount;
        }
        Object[] options = unsavedCount > 1 ? new Object[]{LANGUAGE.value("quit.saveAll"), LANGUAGE.value("quit.save"), LANGUAGE.value("quit.dontSave"), LANGUAGE.value("quit.cancel")} : new Object[]{LANGUAGE.value("quit.save"), LANGUAGE.value("quit.dontSave"), LANGUAGE.value("quit.cancel")};
        block6: for (int i = this.getTabCount() - 1; i >= 0 && !dontQuit; --i) {
            int choice;
            JaxoTab t = this.getTabAt(i);
            if (t.isSaved()) continue;
            new Thread(new JaxoSoundsHandler("resources/sounds/unsaved_changes.wav")).start();
            this.setSelectedTabIndex(i);
            if (saveAll) {
                choice = 1;
            } else {
                choice = this.showTabQuestionDialog("quit.title", "quit.message%0", t, options);
                if (options.length == 3) {
                    ++choice;
                }
                if (choice == 0) {
                    saveAll = true;
                }
            }
            switch (choice) {
                case 0: 
                case 1: {
                    this.save();
                    if (t.isSaved()) continue block6;
                    return;
                }
                case 2: {
                    continue block6;
                }
                case 3: {
                    dontQuit = true;
                    continue block6;
                }
            }
        }
        if (!dontQuit) {
            this.thePanel.shutdown(0);
        }
    }

    private void open(JaxoGraph graph) {
        if (graph == null) {
            return;
        }
        String shortName = JaxoIO.shortName(graph.getSaveFileName());
        this.addTab(new JaxoTab(this.theCanvas, graph), JaxoIO.baseName(shortName), false, true);
        this.thePanel.distributePropertyChange("Jaxo.recentFile", null, graph.getSaveFileName());
    }

    public final void mousePressed(MouseEvent e) {
        if ((e.getModifiers() & 4) != 0) {
            int index = this.tabbedPane.indexAtLocation(e.getX(), e.getY());
            if (index != -1) {
                this.tabbedPane.setSelectedIndex(index);
            }
            this.canvasPopup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private boolean isWatchMode() {
        return this.watchMode;
    }

    private void setWatchMode(boolean value) {
        if (this.isWatchMode() != value) {
            this.watchMode = value;
            this.thePanel.distributePropertyChange("Jaxo.watchMode", !value, value);
        }
    }

    public boolean isAntialiasEnabled() {
        return this.antialiasEnabled;
    }

    public void setAntialiasEnabled(boolean on) {
        if (on != this.antialiasEnabled) {
            this.antialiasEnabled = on;
        }
    }

    public void actionPerformed(ActionEvent e) {
        if ("resetMode".equals(e.getActionCommand())) {
            this.resetMode();
        } else if ("commitGraphChanges".equals(e.getActionCommand())) {
            this.commitGraphChanges();
        } else if ("commitRepeatableGraphChanges".equals(e.getActionCommand())) {
            this.commitRepeatableGraphChanges();
        } else if ("commitRepeatableGraphChangesN".equals(e.getActionCommand())) {
            this.commitRepeatableGraphChanges(e.getID());
        } else if ("setGlassPaneVisible".equals(e.getActionCommand())) {
            this.thePanel.actionPerformed(e);
        } else if ("setGlassPaneInvisible".equals(e.getActionCommand())) {
            this.thePanel.actionPerformed(e);
        } else {
            this.thePanel.actionPerformed(e);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("Jaxo.canvasBackground".equals(evt.getPropertyName())) {
            this.theCanvas.setCanvasBackground((Color)evt.getNewValue());
            JaxoPrefs.setStringPref("prefCANVASBACKGROUND", JaxoColor.getColorName((Color)evt.getNewValue(), 2));
        } else if ("Jaxo.gridColor".equals(evt.getPropertyName())) {
            this.getSelectedTab().setGridColor((Color)evt.getNewValue());
        } else if ("Jaxo.gridSize".equals(evt.getPropertyName())) {
            this.getSelectedTab().setGridSize((Integer)evt.getNewValue());
        } else if (SNAP.equals(evt.getPropertyName())) {
            this.getSelectedTab().setSnappingToGrid((Boolean)evt.getNewValue());
        } else if ("Jaxo.gridOn".equals(evt.getPropertyName())) {
            this.getSelectedTab().setGridPainted((Boolean)evt.getNewValue());
        } else if ("Jaxo.zoomFactor".equals(evt.getPropertyName())) {
            this.theCanvas.getZoom().setZoomFactorFor((Integer)evt.getNewValue());
        } else if ("Jaxo.mainPanelFocused".equals(evt.getPropertyName())) {
            this.latexTextToolTip.setActive((Boolean)evt.getNewValue());
        }
    }

    private void updateSelectedTab(JaxoTab old, JaxoTab t) {
        this.thePanel.distributePropertyChange("Jaxo.selectedTab", old, t);
        this.tabChanged(t);
        if (t == null) {
            this.thePanel.distributePropertyChange("Jaxo.gridOn", false, true);
            this.thePanel.distributePropertyChange(SNAP, true, false);
            this.setMode(0);
        } else {
            this.thePanel.distributePropertyChange("Jaxo.gridOn", true, t.isGridPainted());
            this.thePanel.distributePropertyChange(SNAP, false, t.isSnappingToGrid());
            this.setMode(t.getTabMode());
        }
    }

    private void tabChanged(JaxoTab t) {
        if (t == null) {
            this.setCanUndo(false);
            this.setCanRedo(false);
        } else {
            this.setCanUndo(t.canUndo());
            this.setCanRedo(t.canRedo());
        }
    }

    private void setCanUndo(boolean value) {
        if (value != this.canUndo) {
            this.canUndo = value;
            this.thePanel.distributePropertyChange("Jaxo.canUndo", !value, value);
        }
    }

    private void setCanRedo(boolean value) {
        if (value != this.canRedo) {
            this.canRedo = value;
            this.thePanel.distributePropertyChange("Jaxo.canRedo", !value, value);
        }
    }

    private void setMode(int newMode) {
        if (newMode != this.currentMode) {
            int old = this.currentMode;
            this.currentMode = newMode;
            if (this.currentMode == 232) {
                this.currentMode = this.vertexType;
            }
            this.thePanel.distributePropertyChange("Jaxo.mode", old, this.currentMode);
        }
    }

    private void resetMode() {
        int newMode = JaxoConstants.defaultActionToMode(JaxoPrefs.getIntPref("prefDEFAULTACTION"));
        if (newMode == 0) {
            newMode = this.currentMode;
        }
        this.setMode(newMode);
    }

    private void setVertexType(int value) {
        if (value != this.vertexType) {
            int old = this.vertexType;
            this.vertexType = value;
            this.thePanel.distributePropertyChange("Jaxo.vertexType", old, value);
        }
    }

    private void about() {
        String message = JaxoInfo.about(JaxoPluginInfo.getPluginInfo().availablePlugins());
        String title = JaxoDialogs.windowTitle("About");
        JaxoDialogs.showInfoDialog(this.parentComponent, message, title);
    }

    private void usrGuide() {
        JaxoUserGuide usrGuide = new JaxoUserGuide(this.parentComponent);
        usrGuide.show(this.preview.copy());
    }

    private void sysInfo() {
        String message = JaxoInfo.sysInfo();
        String title = JaxoDialogs.windowTitle("System_Info");
        JaxoDialogs.showInfoDialog(this.parentComponent, message, title);
    }

    private void macReadme() {
        this.preview.copy().showURLInternally(Thread.currentThread().getContextClassLoader().getResource("resources/MacIssues.html"));
    }

    private static class TabInfo {
        private String name;
        private int index;
        private boolean untitled;

        TabInfo() {
            this(null);
        }

        TabInfo(String nname) {
            this.name = nname;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String nname) {
            this.name = nname;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int ind) {
            this.index = ind;
        }

        public boolean isUntitled() {
            return this.untitled;
        }

        public void setUntitled(boolean ut) {
            this.untitled = ut;
        }
    }
}

