/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.swing.spinner;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.plaf.UIResource;

public class JaxoFixedJSpinner
extends JSpinner {
    private static final long serialVersionUID = 7526471155622776147L;
    private Font textFieldFont;

    public JaxoFixedJSpinner(SpinnerModel m) {
        super(m);
    }

    public void setFont(Font font) {
        Font oldTextFieldFont = this.textFieldFont;
        this.textFieldFont = font == null ? null : font.deriveFont(1.0f).deriveFont((float)font.getSize());
        super.setFont(font);
        if (this.getEditor() instanceof JSpinner.DefaultEditor) {
            JFormattedTextField t = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
            if (t == null) {
                return;
            }
            if (JaxoFixedJSpinner.hasFont(t, oldTextFieldFont) || t.getFont() instanceof UIResource) {
                t.setFont(this.textFieldFont);
            }
        }
    }

    public void setEditor(JComponent editor) {
        if (editor == this.getEditor()) {
            return;
        }
        super.setEditor(editor);
        if (this.getEditor() instanceof JSpinner.DefaultEditor) {
            JFormattedTextField t = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
            if (t == null) {
                return;
            }
            if (JaxoFixedJSpinner.hasFont(t, this.getFont())) {
                t.setFont(this.textFieldFont);
            }
        }
    }

    private static boolean hasFont(Component c, Font f) {
        return f == null ? !c.isFontSet() : c.isFontSet() && c.getFont().equals(f);
    }
}

