/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.swing.spinner;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoSpinnerComboBox
extends JComboBox {
    private static final long serialVersionUID = 7526471155622776147L;
    private static final boolean ALLOW_DEFAULT_BUTTON = true;
    private static Action disabledAction = new AbstractAction(){
        private static final long serialVersionUID = 7526471155622776147L;

        public void actionPerformed(ActionEvent e) {
        }

        public boolean isEnabled() {
            return false;
        }
    };
    private JSpinner spinner;

    public JaxoSpinnerComboBox(JSpinner s) {
        this(s, Collections.EMPTY_LIST);
    }

    public JaxoSpinnerComboBox(JSpinner s, List<?> l) {
        this.spinner = s;
        this.setEditable(true);
        this.setItems(l);
        this.setSelectedItem(s.getValue());
        this.setEditor(new SpinnerEditor(s));
        this.getActionMap().put("enterPressed", new AbstractAction(){
            private static final long serialVersionUID = 752647115562277L;
            {
                this.putValue("ActionCommandKey", "FIX-enterPressed");
            }

            public void actionPerformed(ActionEvent e) {
                Action a;
                boolean realEnter = this.getValue("ActionCommandKey").equals(e.getActionCommand());
                if (!realEnter) {
                    return;
                }
                ActionMap m = JaxoSpinnerComboBox.this.getActionMap().getParent();
                if (m != null && (a = m.get("enterPressed")) != null) {
                    a.actionPerformed(e);
                }
            }
        });
    }

    @Override
    public void firePopupMenuWillBecomeVisible() {
        this.setActionsEnabled(false);
        super.firePopupMenuWillBecomeVisible();
    }

    @Override
    public void firePopupMenuWillBecomeInvisible() {
        this.setActionsEnabled(true);
        super.firePopupMenuWillBecomeInvisible();
    }

    public final void setItems(List<?> value) {
        MutableComboBoxModel model = (MutableComboBoxModel)this.getModel();
        if (model instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)model).removeAllElements();
        } else {
            for (int i = model.getSize() - 1; i >= 0; --i) {
                model.removeElement(model.getElementAt(i));
            }
        }
        Iterator<?> i = value.iterator();
        while (i.hasNext()) {
            model.addElement(i.next());
        }
    }

    @Override
    public void removeAllItems() {
        this.setItems(Collections.EMPTY_LIST);
    }

    private void setActionsEnabled(boolean value) {
        if (value) {
            this.spinner.getActionMap().remove("increment");
            this.spinner.getActionMap().remove("decrement");
        } else {
            this.spinner.getActionMap().put("increment", disabledAction);
            this.spinner.getActionMap().put("decrement", disabledAction);
        }
    }

    private static class SpinnerEditor
    implements ComboBoxEditor,
    ChangeListener,
    Serializable {
        private static final long serialVersionUID = 7526471155622776147L;
        private final EventListenerList listeners = new EventListenerList();
        private final JComponent root;
        private final JSpinner spinner;
        private boolean setting;

        SpinnerEditor(JSpinner s) {
            this.spinner = s;
            this.spinner.setFocusable(false);
            this.spinner.addChangeListener(this);
            this.root = new JComponent(){
                private static final long serialVersionUID = 7526471557L;
                {
                    this.setFocusable(false);
                    this.setLayout(new BorderLayout());
                    this.add(SpinnerEditor.this.spinner);
                    super.setFont(SpinnerEditor.this.spinner.getFont());
                    this.setBackground(Color.white);
                    this.setForeground(Color.black);
                    this.setBorder(BorderFactory.createEmptyBorder());
                }

                public void setFont(Font value) {
                    super.setFont(value);
                    SpinnerEditor.this.spinner.setFont(value);
                }

                public void setEnabled(boolean value) {
                    super.setEnabled(value);
                    SpinnerEditor.this.spinner.setEnabled(value);
                }

                private Component getFocusTarget() {
                    for (Container p = this; p != null; p = p.getParent()) {
                        FocusTraversalPolicy t = p.getFocusTraversalPolicy();
                        if (t == null) continue;
                        Component c = t.getDefaultComponent(this);
                        if (!this.isAncestorOf(c)) break;
                        return c;
                    }
                    return this;
                }

                public boolean isFocusable() {
                    return false;
                }

                public void requestFocus() {
                    if (this.containsFocus()) {
                        return;
                    }
                    this.getFocusTarget().requestFocus();
                }

                public boolean requestFocusInWindow() {
                    if (this.containsFocus()) {
                        return false;
                    }
                    return this.getFocusTarget().requestFocusInWindow();
                }

                private boolean containsFocus() {
                    for (Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(); c != null; c = c.getParent()) {
                        if (c != this) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        public void addActionListener(ActionListener l) {
            this.listeners.add(ActionListener.class, l);
        }

        public void removeActionListener(ActionListener l) {
            this.listeners.remove(ActionListener.class, l);
        }

        protected void fireActionPerformed() {
            ActionEvent e = null;
            Object[] pairs = this.listeners.getListenerList();
            for (int i = pairs.length - 2; i >= 0; i -= 2) {
                if (pairs[i] != ActionListener.class) continue;
                if (e == null) {
                    e = new ActionEvent(this, 1001, "");
                }
                ((ActionListener)pairs[i + 1]).actionPerformed(e);
            }
        }

        public Component getEditorComponent() {
            return this.root;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setItem(Object value) {
            this.setting = true;
            try {
                this.spinner.setValue(value);
            }
            finally {
                this.setting = false;
            }
        }

        public Object getItem() {
            return this.spinner.getValue();
        }

        public void selectAll() {
        }

        public void stateChanged(ChangeEvent e) {
            if (!this.setting) {
                this.fireActionPerformed();
            }
        }
    }
}

