/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.gui.swing.spinner;

import javax.swing.SpinnerNumberModel;

public class JaxoSpinnerIntModel
extends SpinnerNumberModel {
    private static final long serialVersionUID = 7526471155622776147L;
    private boolean snap;
    private int origin;

    public JaxoSpinnerIntModel(int minimum, int maximum, int stepSize) {
        super(minimum, minimum, maximum, stepSize);
        this.origin = minimum;
    }

    public JaxoSpinnerIntModel(int minimum, int maximum, int stepSize, int orig) {
        super(minimum, minimum, maximum, stepSize);
        this.snap = true;
        this.origin = orig;
        this.snapValue();
    }

    public final int getIntValue() {
        return this.getNumber().intValue();
    }

    public void setValue(Object value) {
        if (!(value instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        this.setIntValue((Integer)value);
    }

    public final void setIntValue(int newValue) {
        int value = newValue;
        if (this.snap) {
            value = this.snappedValue(value);
        }
        if (this.getNumber().intValue() != value) {
            super.setValue(value);
        }
    }

    public void setIntStepSize(int newValue) {
        this.setStepSize(newValue);
    }

    public void setStepSize(Number stepSize) {
        if (!(stepSize instanceof Integer)) {
            throw new IllegalArgumentException();
        }
        super.setStepSize(stepSize);
        this.snapValue();
    }

    public final int getOrigin() {
        return this.origin;
    }

    public void setOrigin(int newValue) {
        if (this.origin != newValue) {
            this.origin = newValue;
            this.snapValue();
        }
    }

    public final boolean isSnap() {
        return this.snap;
    }

    public void setSnap(boolean newValue) {
        if (this.snap != newValue) {
            this.snap = newValue;
            this.snapValue();
        }
    }

    private void snapValue() {
        if (this.snap) {
            this.setIntValue(this.getIntValue());
        }
    }

    private int snappedValue(int candidate) {
        int min = ((Number)((Object)this.getMinimum())).intValue();
        int max = ((Number)((Object)this.getMaximum())).intValue();
        int stepSize = this.getStepSize().intValue();
        int candidateR = this.roundedTowardsOrigin(candidate);
        if (min <= candidate && candidate <= max) {
            int minR = this.roundedTowardsOrigin(min);
            if (minR < min) {
                if (candidateR == minR) {
                    candidateR += stepSize;
                }
            } else {
                int maxR = this.roundedTowardsOrigin(max);
                if (maxR > max && candidateR == maxR) {
                    candidateR -= stepSize;
                }
            }
        }
        return candidateR;
    }

    private int roundedTowardsOrigin(int candidate) {
        int stepSize = this.getStepSize().intValue();
        return this.origin + (candidate < this.origin ? -1 : 1) * stepSize * Math.round((float)Math.abs(candidate - this.origin) / (float)stepSize);
    }
}

