/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Locale;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JOptionPane;
import net.sf.jaxodraw.graph.JaxoGraph;
import net.sf.jaxodraw.gui.JaxoDialogs;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLog;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoPrint
implements Printable {
    private final JaxoDictionary language = new JaxoDictionary(JaxoPrint.class);
    private JaxoGraph jaxoGraph;

    public JaxoPrint(JaxoGraph graph) {
        this.jaxoGraph = graph;
    }

    public JaxoPrint() {
        this.jaxoGraph = new JaxoGraph();
    }

    public final int print(Graphics g, PageFormat pf, int pageIndex) {
        double transX = pf.getImageableX();
        double transY = pf.getImageableY();
        Rectangle graphBB = this.jaxoGraph.getBounds();
        if (graphBB == null) {
            graphBB = new Rectangle();
        }
        double scaleX = pf.getImageableWidth() / graphBB.getWidth();
        double scaleY = pf.getImageableHeight() / graphBB.getHeight();
        if (pageIndex == 0) {
            JaxoGraphics2D g2 = new JaxoGraphics2D((Graphics2D)g);
            g2.setPrinting(true);
            double right = transX + pf.getImageableWidth() - graphBB.getX() - graphBB.getWidth();
            double bottom = transY + pf.getImageableHeight() - graphBB.getY() - graphBB.getHeight();
            double scale = scaleX;
            if (scaleY < scaleX) {
                scale = scaleY;
            }
            if (scale > 1.0) {
                scale = 1.0;
            }
            g2.translate(transX, transY);
            if (scale < 1.0) {
                g2.scale(scale, scale);
                g2.translate(-graphBB.getX(), -graphBB.getY());
            } else {
                if (right < 0.0) {
                    g2.translate(right - transX, 0.0);
                }
                if (bottom < 0.0) {
                    g2.translate(0.0, bottom - transY);
                }
            }
            this.jaxoGraph.paint(g2);
            return 0;
        }
        return 1;
    }

    private void showPrintError(Component parent, String text) {
        JOptionPane.showMessageDialog(parent, text, JaxoDialogs.windowTitle(this.language, "errorTitle"), 0);
    }

    public final void print(Component parent, JaxoGraph graph, String name) {
        this.jaxoGraph = graph;
        this.print(parent, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void print(Component parent, String name) {
        PrintService chosenService;
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(OrientationRequested.LANDSCAPE);
        aset.add(new Copies(1));
        aset.add(new JobName(name, null));
        PrinterJob pj = PrinterJob.getPrinterJob();
        pj.setPrintable(this);
        PrintService[] services = PrinterJob.lookupPrintServices();
        PrintService defaultService = PrintServiceLookup.lookupDefaultPrintService();
        PrintService printService = chosenService = services.length > 0 ? services[0] : defaultService;
        if (chosenService == null) {
            this.showPrintError(parent, this.language.value("noPrinters"));
        } else {
            Locale oldLocale = Locale.getDefault();
            try {
                pj.setPrintService(chosenService);
                Locale.setDefault(this.language.locale());
                if (pj.printDialog(aset)) {
                    pj.print(aset);
                }
            }
            catch (PrinterException e) {
                JaxoLog.debug(e);
                this.showPrintError(parent, this.language.message("print%0Failed", name));
            }
            finally {
                Locale.setDefault(oldLocale);
            }
        }
    }

    @Deprecated
    public final void print(Component parent, JaxoGraph newGraph, Dimension d, String name) {
        this.print(parent, newGraph, name);
    }
}

