/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.io.exports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jaxodraw.io.JaxoPreview;
import net.sf.jaxodraw.io.exports.JaxoExport;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.text.JaxoLatexText;
import net.sf.jaxodraw.plugin.JaxoPluginExecutionException;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoInfo;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.JaxoUtils;

public class JaxoExportLatex
extends JaxoExport {
    private JPanel panel;
    private JLabel scaleLabel;
    private JFrame previewFrame;
    private boolean scaleToFitPage = false;
    private static final JaxoDictionary LANGUAGE = new JaxoDictionary(JaxoExportLatex.class);
    private static final float MARGIN_IN_INCH = 2.0f;
    private static final String TAB = "    ";
    private static final String PLUGIN_ID = JaxoExportLatex.class.getName();

    public final String getFormatName() {
        return LANGUAGE.value("formatName");
    }

    public final String getFileExtension() {
        return "tex";
    }

    public final String getFileExtensionDescription() {
        return LANGUAGE.value("fileDescription");
    }

    public String description() {
        return LANGUAGE.value("description");
    }

    public String pluginId() {
        return PLUGIN_ID;
    }

    public String getShortName() {
        return "latex-export";
    }

    public String getWarningForGraph() {
        String warning = null;
        if (this.getGraph().containsPSText()) {
            warning = this.getPSTextWarningForLaTeX();
        }
        if (JaxoPrefs.getIntPref("prefCOLORSPACE") == 2) {
            warning = warning == null ? this.getColorSpaceWarningForLaTeX() : warning.concat("<p></p>").concat(this.getColorSpaceWarningForLaTeX());
        }
        return warning;
    }

    protected final void exportTo(String fileName) throws JaxoPluginExecutionException {
        PrintWriter texFile;
        try {
            texFile = new PrintWriter(new FileWriter(fileName));
        }
        catch (IOException e) {
            throw new JaxoPluginExecutionException(this.errorDialogMessage(fileName, "write%0OpenFailed"), e, this);
        }
        texFile.println(this.latexFileAsString());
        texFile.close();
        if (texFile.checkError()) {
            throw new JaxoPluginExecutionException(this.errorDialogMessage("JaxoIO.write%0WriteFailed"), texFile);
        }
    }

    public final String latexFileAsString() {
        StringBuffer buffer = new StringBuffer(1024);
        String defaultColor = "\\SetColor{Black}";
        String defaultWidth = "\\SetWidth{0.5}";
        String nl = JaxoUtils.LINE_SEPARATOR;
        Rectangle bBox = this.getGraph().getBounds();
        if (bBox == null) {
            bBox = new Rectangle();
        }
        int bBoxWidth = bBox.width;
        int bBoxHeight = bBox.height;
        Dimension bBoxDim = new Dimension(bBoxWidth, bBoxHeight);
        float boxWidthInInch = (float)bBoxWidth / 72.0f;
        float boxHeightInInch = (float)bBoxHeight / 72.0f;
        float paperWidthInInch = 6.2677164f;
        float paperHeightInInch = 9.692914f;
        float scaleFactor = 1.0f;
        float scaleX = boxWidthInInch / 6.2677164f;
        float scaleY = boxHeightInInch / 9.692914f;
        if (this.scaleToFitPage) {
            scaleFactor = Math.max(1.0f, Math.max(scaleX, scaleY));
        }
        buffer.append(this.getHeader()).append(nl);
        StringBuffer comment = new StringBuffer(this.getGraph().getDescription());
        if (comment.length() > 0) {
            comment.append(' ');
        }
        buffer.append("\\begin{document}").append(nl).append(nl);
        buffer.append("%%JaxoComment:").append(comment).append(nl);
        buffer.append("%%JaxoScale{").append(scaleFactor).append('}').append(nl).append(nl).append(nl);
        buffer.append("\\begin{center}").append(nl);
        buffer.append("\\fcolorbox{white}{white}{").append(nl);
        buffer.append("  \\begin{picture}(").append((int)((float)bBoxWidth / scaleFactor)).append(',').append((int)((float)bBoxHeight / scaleFactor)).append(") (").append((int)((float)bBox.x / scaleFactor)).append(',').append((int)((float)(-bBox.y) / scaleFactor)).append(')').append(nl);
        JaxoList<JaxoObject> oblist = this.getGraph().getObjectList();
        for (int i = 0; i < oblist.size(); ++i) {
            JaxoObject ob = (JaxoObject)oblist.get(i);
            String latexCommand = ob.latexCommand(scaleFactor, bBoxDim);
            String latexColor = JaxoColor.getLatexColorCommand(ob.getColor());
            String latexWidth = ob.latexWidth();
            if (i == 0) {
                if (ob instanceof JaxoLatexText) {
                    buffer.append(TAB).append(defaultWidth).append(nl);
                } else {
                    buffer.append(TAB).append(latexWidth).append(nl);
                }
                buffer.append(TAB).append(latexColor).append(nl);
                buffer.append(TAB).append(latexCommand).append(nl);
                defaultColor = latexColor;
                defaultWidth = latexWidth;
                continue;
            }
            if (!latexWidth.equals(defaultWidth) && !(ob instanceof JaxoLatexText)) {
                buffer.append(TAB).append(latexWidth).append(nl);
                defaultWidth = latexWidth;
            }
            if (!latexColor.equals(defaultColor) && !(ob instanceof JaxoLatexText)) {
                buffer.append(TAB).append(latexColor).append(nl);
                defaultColor = latexColor;
            }
            buffer.append(TAB).append(latexCommand).append(nl);
        }
        buffer.append("  \\end{picture}").append(nl);
        buffer.append('}').append(nl);
        buffer.append("\\end{center}").append(nl).append(nl);
        buffer.append("\\end{document}").append(nl);
        return buffer.toString();
    }

    protected final void exportTo(String fileName, boolean rescale) throws JaxoPluginExecutionException {
        this.scaleToFitPage = rescale;
        this.exportTo(fileName);
    }

    private StringBuffer getHeader() {
        StringBuffer buffer = new StringBuffer(1024);
        String nl = JaxoUtils.LINE_SEPARATOR;
        Calendar rightNow = Calendar.getInstance();
        String creationDate = "CreationDate: " + rightNow.get(5) + "/" + (rightNow.get(2) + 1) + "/" + rightNow.get(1);
        buffer.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        buffer.append(nl);
        buffer.append("%%%\t\tLaTex file generated by ").append(JaxoInfo.VERSION);
        buffer.append(nl);
        buffer.append("%%%\t\t\t").append(creationDate).append(nl);
        buffer.append("%%%\tMake sure you have the axodraw4j package installed in order to proceed!");
        buffer.append(nl);
        buffer.append("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        buffer.append(nl).append(nl);
        buffer.append("\\documentclass[a4paper]{article}").append(nl).append(nl);
        List<String> packageList = this.getGraph().getPackageList();
        for (int j = 0; j < packageList.size(); ++j) {
            buffer.append("\\usepackage{").append(packageList.get(j)).append('}').append(nl);
        }
        buffer.append(nl);
        buffer.append("\\setlength{\\oddsidemargin}{0pt}").append(nl);
        buffer.append("\\setlength{\\evensidemargin}{0pt}").append(nl);
        buffer.append("\\setlength{\\topmargin}{0pt}").append(nl);
        buffer.append("\\setlength{\\headheight}{0pt}").append(nl);
        buffer.append("\\setlength{\\headsep}{0pt}").append(nl);
        buffer.append("\\setlength{\\topskip}{0pt}").append(nl);
        buffer.append("\\setlength{\\footskip}{0pt}").append(nl);
        buffer.append("\\setlength{\\textwidth}{\\paperwidth}").append(nl);
        buffer.append("\\addtolength{\\textwidth}{-2in}").append(nl);
        buffer.append("\\setlength{\\textheight}{\\paperheight}").append(nl);
        buffer.append("\\addtolength{\\textheight}{-2in}").append(nl);
        buffer.append(nl);
        buffer.append("\\pagestyle{empty}").append(nl).append(nl).append(nl);
        return buffer;
    }

    public void preview(JaxoPreview p, boolean sameWindow) {
        if (!sameWindow || this.previewFrame == null) {
            this.previewFrame = new JFrame();
        }
        p.setTitle(LANGUAGE.message("preview%0Title", this.getShortGraphName()));
        try {
            p.showText(this.latexFileAsString(), "Jaxo_tmp.tex", this.previewFrame);
        }
        catch (IOException ex) {
            this.setFailure(ex);
            this.showErrorDialog(this.errorDialogMessage("Jaxo_tmp.tex", "write%0WriteFailed"));
        }
    }

    public void commitConfiguration() {
    }

    public JComponent getConfigurationPanel() {
        if (this.panel == null && this.isRescalingNeeded()) {
            this.panel = new JPanel(new GridBagLayout(), false);
            GridBagConstraints labels = new GridBagConstraints();
            GridBagConstraints components = new GridBagConstraints();
            labels.anchor = 22;
            labels.gridx = 0;
            labels.gridy = 0;
            components.anchor = 21;
            components.gridx = 1;
            components.gridy = 0;
            components.weightx = 1.0;
            this.scaleLabel = new JLabel(LANGUAGE.value("rescaleLabel"));
            this.panel.add((Component)this.scaleLabel, labels);
            final JCheckBox scaleBox = new JCheckBox();
            scaleBox.setSelected(this.scaleToFitPage);
            scaleBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JaxoExportLatex.this.scaleToFitPage = scaleBox.isSelected();
                }
            });
            this.panel.add((Component)scaleBox, components);
            ++labels.gridy;
            ++components.gridy;
        }
        return this.panel;
    }

    public final void updateLanguage() {
        if (this.scaleLabel != null) {
            this.scaleLabel.setText(LANGUAGE.value("rescaleLabel"));
        }
    }

    private String errorDialogMessage(String fileName, String key) {
        return LANGUAGE.message(key, new File(fileName));
    }

    private boolean isRescalingNeeded() {
        boolean rneeded = false;
        Rectangle bBox = this.getGraph().getBounds();
        if (bBox == null) {
            return false;
        }
        int bBoxWidth = bBox.width;
        int bBoxHeight = bBox.height;
        float boxWidthInInch = (float)bBoxWidth / 72.0f;
        float boxHeightInInch = (float)bBoxHeight / 72.0f;
        float paperWidthInInch = 6.2677164f;
        float paperHeightInInch = 9.692914f;
        float scaleX = boxWidthInInch / 6.2677164f;
        float scaleY = boxHeightInInch / 9.692914f;
        if (scaleX > 1.0f || scaleY > 1.0f) {
            rneeded = true;
        }
        return rneeded;
    }
}

