/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.logging;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.sf.jaxodraw.logging.JaxoConsoleHandler;
import net.sf.jaxodraw.logging.JaxoFileHandler;
import net.sf.jaxodraw.logging.JaxoLogger;

public final class JaxoDefaultLogger
implements JaxoLogger {
    private static final Logger LOGGER = Logger.getLogger("net.sf.jaxodraw");
    private final JaxoConsoleHandler consoleHandler = new JaxoConsoleHandler();

    public JaxoDefaultLogger() {
        this(null);
    }

    public JaxoDefaultLogger(String logDir) {
        LOGGER.setLevel(Level.ALL);
        LOGGER.setUseParentHandlers(false);
        LOGGER.addHandler(this.consoleHandler);
        if (logDir != null) {
            this.addFileHandler(logDir);
        }
    }

    public void setLevel(Level level) {
        this.consoleHandler.setLevel(level);
    }

    public Level getLevel() {
        return this.consoleHandler.getLevel();
    }

    public boolean isLoggable(Level level) {
        return this.consoleHandler.isLoggable(new LogRecord(level, null));
    }

    public void log(Level level, String message, Throwable e) {
        if (e == null) {
            if (message == null) {
                throw new IllegalArgumentException("Nothing to log?");
            }
            LOGGER.log(level, message);
        } else {
            LOGGER.log(level, message == null ? e.getMessage() : message, e);
            if (this.getLevel().intValue() <= Level.FINE.intValue()) {
                e.printStackTrace();
            }
        }
    }

    private boolean createLogDir(File logDir) throws IOException {
        if (!logDir.exists()) {
            if (logDir.mkdirs()) {
                return true;
            }
            throw new IOException("Failed to create log dir: " + logDir.getAbsolutePath());
        }
        return false;
    }

    private void addFileHandler(String logDir) {
        block3: {
            try {
                boolean dirCreated = this.createLogDir(new File(logDir));
                LOGGER.addHandler(new JaxoFileHandler(logDir));
                if (dirCreated) {
                    LOGGER.log(Level.WARNING, "Created log directory: {0}", logDir);
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "Failed to initialize FileHandler!", ex);
                if (this.getLevel().intValue() > Level.FINE.intValue()) break block3;
                ex.printStackTrace();
            }
        }
    }
}

