/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.bezier;

import java.awt.geom.Point2D;
import net.sf.jaxodraw.object.Jaxo3PointObject;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.util.JaxoGeometry;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoBezierObject
extends Jaxo3PointObject {
    public static final int SELECT_P4 = 3;
    private static final long serialVersionUID = 2L;
    private static final int POINT_COUNT = 4;
    private int x4;
    private int y4;
    private boolean noFreqStretching = true;

    public int getPointCount() {
        return 4;
    }

    public int getX(int index) {
        if (index == 3) {
            return this.x4;
        }
        return super.getX(index);
    }

    public int getY(int index) {
        if (index == 3) {
            return this.y4;
        }
        return super.getY(index);
    }

    public void setX(int index, int value) {
        if (index == 3) {
            this.x4 = value;
        } else {
            super.setX(index, value);
        }
    }

    public void setY(int index, int value) {
        if (index == 3) {
            this.y4 = value;
        } else {
            super.setY(index, value);
        }
    }

    public final void setNoFreqStretching(boolean nofs) {
        this.noFreqStretching = nofs;
    }

    public final boolean isNoFreqStretching() {
        return this.noFreqStretching;
    }

    public final void setX4(int newx4) {
        this.setX(3, newx4);
    }

    public final int getX4() {
        return this.getX(3);
    }

    public final void setY4(int newy4) {
        this.setY(3, newy4);
    }

    public final int getY4() {
        return this.getY(3);
    }

    public final void setBezierPts(int sx1, int sy1, int sx2, int sy2, int sx3, int sy3, int sx4, int sy4) {
        this.setLocation(sx1, sy1, sx2, sy2, sx3, sy3, sx4, sy4);
    }

    public final void setLocation(int sx1, int sy1, int sx2, int sy2, int sx3, int sy3, int sx4, int sy4) {
        this.setLocation(sx1, sy1, sx2, sy2, sx3, sy3);
        this.setX4(sx4);
        this.setY4(sy4);
    }

    public boolean isCopy(JaxoObject comp) {
        JaxoBezierObject tmp;
        boolean isCopy = false;
        if (comp instanceof JaxoBezierObject && (tmp = (JaxoBezierObject)comp).getX4() == this.getX4() && tmp.getY4() == this.getY4() && tmp.isNoFreqStretching() == this.isNoFreqStretching() && super.isCopy(tmp)) {
            isCopy = true;
        }
        return isCopy;
    }

    public void copyFrom(JaxoBezierObject temp) {
        super.copyFrom(temp);
        this.setLocation(temp.getX(), temp.getY(), temp.getX2(), temp.getY2(), temp.getX3(), temp.getY3(), temp.getX4(), temp.getY4());
        this.setNoFreqStretching(temp.isNoFreqStretching());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoBezierObject)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoBezierObject)o);
    }

    public final void paintVisualAid(JaxoGraphics2D g2) {
        g2.drawLine(this.getX(), this.getY(), this.getX2(), this.getY2());
        g2.drawLine(this.getX2(), this.getY2(), this.getX3(), this.getY3());
        g2.drawLine(this.getX3(), this.getY3(), this.getX4(), this.getY4());
        g2.drawLine(this.getX4(), this.getY4(), this.getX(), this.getY());
    }

    public final void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        if (editMode == 459) {
            return;
        }
        h.paint(g2, this.getX(), this.getY(), this.isMarked(), !this.canBeSelected(0, editMode));
        h.paint(g2, this.getX2(), this.getY2(), this.isMarked(), !this.canBeSelected(1, editMode));
        h.paint(g2, this.getX3(), this.getY3(), this.isMarked(), !this.canBeSelected(2, editMode));
        h.paint(g2, this.getX4(), this.getY4(), this.isMarked(), !this.canBeSelected(3, editMode));
    }

    public final float smallestDistanceTo(int px, int py) {
        int distY;
        int distX;
        float dist2;
        float dist1 = super.smallestDistanceTo(px, py);
        return dist1 < (dist2 = (float)Math.sqrt((distX = px - this.getX4()) * distX + (distY = py - this.getY4()) * distY)) ? dist1 : dist2;
    }

    public int getGrabbedHandle(int clickX, int clickY, JaxoHandle h) {
        int selected = super.getGrabbedHandle(clickX, clickY, h);
        if (this.isAround(3, clickX, clickY, h)) {
            selected = 3;
        }
        return selected;
    }

    public boolean canBeSelected(int handle, int mode) {
        boolean active;
        boolean bl = active = handle == 0 || handle == 3;
        if (mode == 451) {
            active = handle == 0 || handle == 1 || handle == 2 || handle == 3;
        }
        return active;
    }

    public final void moveBy(int deltaX, int deltaY) {
        if (deltaX != 0 || deltaY != 0) {
            super.moveBy(deltaX, deltaY);
            this.setX4(this.getX4() + deltaX);
            this.setY4(this.getY4() + deltaY);
        }
    }

    public final void rescaleObject(int orx, int ory, float scale) {
        Point2D p1 = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX(), this.getY());
        Point2D p2 = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX2(), this.getY2());
        Point2D p3 = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX3(), this.getY3());
        Point2D p4 = JaxoGeometry.scaledPoint(orx, ory, scale, this.getX4(), this.getY4());
        this.setLocation((int)Math.round(p1.getX()), (int)Math.round(p1.getY()), (int)Math.round(p2.getX()), (int)Math.round(p2.getY()), (int)Math.round(p3.getX()), (int)Math.round(p3.getY()), (int)Math.round(p4.getX()), (int)Math.round(p4.getY()));
    }

    protected static Point2D getLatexPoint(double x, double y, float scaleFactor, int canvasHeight) {
        return new Point2D.Double(x / (double)scaleFactor, ((double)canvasHeight - y) / (double)scaleFactor);
    }

    protected static Point2D getLatexPoint(Point2D p, float scaleFactor, int canvasHeight) {
        return JaxoBezierObject.getLatexPoint(p.getX(), p.getY(), scaleFactor, canvasHeight);
    }

    protected static String bezierLatexCommand(String options, Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        return "\\Bezier" + options + "(" + D_FORMAT.format(p1.getX()) + "," + D_FORMAT.format(p1.getY()) + ")(" + D_FORMAT.format(p2.getX()) + "," + D_FORMAT.format(p2.getY()) + ")(" + D_FORMAT.format(p3.getX()) + "," + D_FORMAT.format(p3.getY()) + ")(" + D_FORMAT.format(p4.getX()) + "," + D_FORMAT.format(p4.getY()) + ")";
    }

    protected String getArrowCommand(float scale) {
        StringBuffer arrowcmd = new StringBuffer("[");
        float arpos = this.getArrowPosition();
        arrowcmd.append(this.getArrow().latexCommand(arpos, scale));
        if (this.isFlip()) {
            arrowcmd.append(",flip");
        }
        arrowcmd.append(']');
        return arrowcmd.toString();
    }

    public JaxoArrow.Coordinates arrowCoordinates() {
        float arrowPosition = this.getArrowPosition();
        Point2D point = this.getPoint(arrowPosition);
        double theta = this.slope(arrowPosition);
        if (this.isFlip()) {
            theta += Math.PI;
        }
        return new JaxoArrow.Coordinates(point.getX(), point.getY(), theta);
    }

    public Point2D getPoint(double u) {
        return JaxoGeometry.bezierPoint(this.getPoints(), u);
    }

    protected Point2D getPointOnCurve(double t) {
        double u = t;
        if (u > 1.0) {
            u = 1.0;
        }
        if (u < 0.0) {
            u = 0.0;
        }
        return this.getPoint(u);
    }

    public double slope(double u) {
        return JaxoGeometry.bezierSlope(this.getPoints(), u);
    }

    public final double getBezierLength() {
        return JaxoGeometry.bezierLength(this.getPoints(), 10.0);
    }

    public void setPreferences() {
        super.setPreferences();
        this.setNoFreqStretching(true);
    }

    static {
        JaxoBezierObject.setTransient(JaxoBezierObject.class, new String[]{"x4", "y4"});
    }
}

