/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.bezier;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.bezier.JaxoBezierObject;
import net.sf.jaxodraw.util.JaxoUtils;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public abstract class JaxoDashBezier
extends JaxoBezierObject {
    private static final long serialVersionUID = 314159L;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.resetStroke();
    }

    public final void paint(JaxoGraphics2D g2) {
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.getObjectPath());
        if (this.isPaintArrow()) {
            this.paintArrow(g2);
        }
    }

    public Rectangle getBounds() {
        Rectangle bb = this.getStroke().createStrokedShape(new Area(this.getObjectPath())).getBounds();
        if (this.isPaintArrow()) {
            bb.add(this.getArrow().getBounds(this.arrowCoordinates()));
        }
        return bb;
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        String arrowCommand = "";
        String jdIdentifier = this.getIdentifier();
        Point2D latexP1 = JaxoDashBezier.getLatexPoint(this.getX(), this.getY(), scale, canvasHeight);
        Point2D latexP2 = JaxoDashBezier.getLatexPoint(this.getX2(), this.getY2(), scale, canvasHeight);
        Point2D latexP3 = JaxoDashBezier.getLatexPoint(this.getX3(), this.getY3(), scale, canvasHeight);
        Point2D latexP4 = JaxoDashBezier.getLatexPoint(this.getX4(), this.getY4(), scale, canvasHeight);
        String options = "[dash,dsize=" + D_FORMAT.format(this.getDash() / scale) + "]";
        String command = JaxoDashBezier.bezierLatexCommand(options, latexP1, latexP2, latexP3, latexP4);
        if (this.isPaintArrow()) {
            float k = 0.0025f;
            float arrowPosition = this.getArrowPosition();
            Point2D b1 = this.getPointOnCurve(arrowPosition - 0.0025f);
            Point2D b2 = this.getPointOnCurve(arrowPosition + 0.0025f);
            Point2D startPoint = JaxoDashBezier.getLatexPoint(b1.getX(), b1.getY(), scale, canvasHeight);
            Point2D endPoint = JaxoDashBezier.getLatexPoint(b2.getX(), b2.getY(), scale, canvasHeight);
            String arrowcmd = this.getArrowCommand(scale);
            arrowCommand = "\\Line" + arrowcmd + "(" + D_FORMAT.format(startPoint.getX()) + "," + D_FORMAT.format(startPoint.getY()) + ")" + "(" + D_FORMAT.format(endPoint.getX()) + "," + D_FORMAT.format(endPoint.getY()) + ")";
            jdIdentifier = jdIdentifier + arrowcmd;
        }
        return command + arrowCommand + jdIdentifier;
    }

    protected void resetStroke() {
        if (JaxoUtils.zero(this.getStrokeWidth()) || JaxoUtils.zero(this.getDash())) {
            return;
        }
        this.setStroke(new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.strokeDashes(), 0.0f));
    }

    private GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        gp.moveTo(this.getX(), this.getY());
        gp.curveTo(this.getX2(), this.getY2(), this.getX3(), this.getY3(), this.getX4(), this.getY4());
        return gp;
    }

    protected abstract float[] strokeDashes();

    protected abstract String getIdentifier();
}

