/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.fill;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.fill.JaxoFillObject;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoBox
extends JaxoFillObject {
    private static final long serialVersionUID = 314159L;
    private transient Rectangle2D box = new Rectangle2D.Float();

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.box = new Rectangle2D.Float();
    }

    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoBox) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public final int getGrabbedHandle(int clickX, int clickY, JaxoHandle h) {
        int handle = super.getGrabbedHandle(clickX, clickY, h);
        if (this.isAroundDX(clickX, clickY, h)) {
            handle = -3;
        } else if (this.isAroundDY(clickX, clickY, h)) {
            handle = -4;
        }
        return handle;
    }

    private boolean isAroundDX(int clickX, int clickY, JaxoHandle h) {
        return h.contains(clickX, clickY, this.getX(), this.getY2());
    }

    private boolean isAroundDY(int clickX, int clickY, JaxoHandle h) {
        return h.contains(clickX, clickY, this.getX2(), this.getY());
    }

    public boolean canBeSelected(int handle, int mode) {
        return handle == 0 || handle == 1 || handle == -3 || handle == -4;
    }

    public final void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        if (editMode == 459) {
            return;
        }
        h.paint(g2, this.getX(), this.getY(), this.isMarked(), !this.canBeSelected(0, editMode));
        h.paint(g2, this.getX2(), this.getY2(), this.isMarked(), !this.canBeSelected(1, editMode));
        h.paint(g2, this.getX(), this.getY2(), this.isMarked(), !this.canBeSelected(-3, editMode));
        h.paint(g2, this.getX2(), this.getY(), this.isMarked(), !this.canBeSelected(-4, editMode));
    }

    public final float smallestDistanceTo(int px, int py) {
        int x = this.getX();
        int y = this.getY();
        int w = this.getWidth();
        int h = this.getHeight();
        double distX = px - x;
        double distY = py - y;
        float dist1 = (float)Math.sqrt(distX * distX + distY * distY);
        distX = px - x;
        distY = py - y - h;
        float dist2 = (float)Math.sqrt(distX * distX + distY * distY);
        distX = px - x - w;
        distY = py - y;
        float dist3 = (float)Math.sqrt(distX * distX + distY * distY);
        distX = px - x - w;
        distY = py - y - h;
        float dist4 = (float)Math.sqrt(distX * distX + distY * distY);
        return this.smallest(dist1, dist2, dist3, dist4);
    }

    private float smallest(float dist1, float dist2, float dist3, float dist4) {
        if (dist1 < dist2) {
            return this.smallest(dist1, dist3, dist4);
        }
        return this.smallest(dist2, dist3, dist4);
    }

    private float smallest(float dist1, float dist2, float dist3) {
        float dist = 0.0f;
        dist = dist1 < dist2 ? (dist1 < dist3 ? dist1 : dist3) : (dist2 < dist3 ? dist2 : dist3);
        return dist;
    }

    public final void paint(JaxoGraphics2D g2) {
        this.updateBox();
        if (this.isFilled()) {
            g2.setColor(this.getFillColor());
            g2.fill(this.box);
        }
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(this.box);
    }

    public Rectangle getBounds() {
        this.updateBox();
        return this.getStroke().createStrokedShape(this.box).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        int canvasHeight = canvasDim.height;
        Point2D lowerCorner = this.getLaTexLowerCorner(scale, canvasHeight);
        Point2D upperCorner = this.getLaTexUpperCorner(scale, canvasHeight);
        if ((int)lowerCorner.getX() == (int)upperCorner.getX() && (int)lowerCorner.getY() == (int)upperCorner.getY()) {
            return "%";
        }
        String command = "";
        if (this.isFilled()) {
            if (JaxoColor.isGrayScale(this.getFillColor())) {
                float grayScale = JaxoColor.getGrayScaleFloat(this.getFillColor());
                command = "\\GBox(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")" + "(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + ")" + "{" + GRAY_SCALE_FORMAT.format(grayScale) + "}";
            } else {
                String tlc = JaxoColor.isGrayScale(this.getColor()) ? "Gray" : JaxoColor.getColorName(this.getColor());
                String tfc = JaxoColor.getColorName(this.getFillColor());
                command = "\\CBox(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")" + "(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + ")" + "{" + tlc + "}" + "{" + tfc + "}";
            }
        } else {
            command = "\\EBox(" + D_FORMAT.format(lowerCorner.getX()) + "," + D_FORMAT.format(lowerCorner.getY()) + ")" + "(" + D_FORMAT.format(upperCorner.getX()) + "," + D_FORMAT.format(upperCorner.getY()) + ")";
        }
        return command;
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.addCenterSizePanel(this.getX(), this.getY(), this.getWidth(), this.getHeight(), 0, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addFillLineColorPanels(this.getColor(), this.getFillColor(), this.isFilled(), 1, 1, 1, 0);
        editPanel.setTitleAndIcon("Box_parameters", "box.png");
    }

    private Point2D getLaTexLowerCorner(float scaleFactor, int canvasHeight) {
        Point2D.Float lowerCornerVec = new Point2D.Float();
        float x1 = this.getRelw() < 0 ? (float)this.getX2() : (float)this.getX();
        float y1 = this.getRelh() < 0 ? (float)this.getY() : (float)this.getY2();
        ((Point2D)lowerCornerVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return lowerCornerVec;
    }

    private Point2D getLaTexUpperCorner(float scaleFactor, int canvasHeight) {
        Point2D.Float upperCornerVec = new Point2D.Float();
        float x1 = this.getRelw() < 0 ? (float)this.getX() : (float)this.getX2();
        float y1 = this.getRelh() < 0 ? (float)this.getY2() : (float)this.getY();
        ((Point2D)upperCornerVec).setLocation(x1 / scaleFactor, ((float)canvasHeight - y1) / scaleFactor);
        return upperCornerVec;
    }

    private void updateBox() {
        this.box.setFrameFromDiagonal(this.getX(), this.getY(), this.getX() + this.getRelw(), this.getY() + this.getRelh());
    }
}

