/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.group;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import net.sf.jaxodraw.object.JaxoExtendedObject;
import net.sf.jaxodraw.object.JaxoHandle;
import net.sf.jaxodraw.object.JaxoList;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.JaxoObjectList;
import net.sf.jaxodraw.object.JaxoWiggleObject;
import net.sf.jaxodraw.object.text.JaxoLatexText;
import net.sf.jaxodraw.object.text.JaxoPSText;
import net.sf.jaxodraw.util.JaxoPrefs;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoGroup
extends JaxoExtendedObject {
    private static final long serialVersionUID = 2L;
    private int groupAmp;
    private int groupTeXSize;
    private Font groupTextFont;
    private JaxoList<JaxoObject> objectList = new JaxoObjectList<JaxoObject>(5);

    @Override
    public final JaxoObject copy() {
        JaxoGroup copy = (JaxoGroup)super.copy();
        copy.setFont(this.getFont());
        copy.setLatexTextSize(this.getLatexTextSize());
        copy.setAmp(this.getAmp());
        copy.setObjectList(this.objectList.copyOf());
        return copy;
    }

    @Override
    public final boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoGroup) {
            JaxoGroup group = (JaxoGroup)comp;
            JaxoList<JaxoObject> v1 = this.getObjectList();
            JaxoList<JaxoObject> v2 = group.getObjectList();
            int length = v1.size();
            if (length == v2.size()) {
                boolean temp = true;
                for (int i = 0; i < length; ++i) {
                    JaxoObject ob1 = (JaxoObject)v1.get(i);
                    JaxoObject ob2 = (JaxoObject)v2.get(i);
                    temp = temp && ob1.isCopy(ob2);
                }
                boolean equalTexFonts = this.getFont() == null ? group.getFont() == null : this.getFont().equals(group.getFont());
                isCopy = temp && equalTexFonts && group.getLatexTextSize() == this.getLatexTextSize() && group.getAmp() == this.getAmp() && super.isCopy(group);
            }
        }
        return isCopy;
    }

    public void copyFrom(JaxoGroup temp) {
        super.copyFrom(temp);
        this.setFont(temp.getFont());
        this.setLatexTextSize(temp.getLatexTextSize());
        this.setAmp(temp.getAmp());
        this.clearGroup();
        this.setObjectList(temp.getObjectList().copyOf());
    }

    @Override
    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoGroup)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoGroup)o);
    }

    @Override
    public final int getGrabbedHandle(int clickX, int clickY, JaxoHandle h) {
        Rectangle bBox = this.getBounds();
        int selected = -1;
        int gx = bBox.x;
        int gy = bBox.y;
        int gx2 = bBox.x + bBox.width;
        int gy2 = bBox.y + bBox.height;
        if (h.contains(clickX, clickY, gx2, gy2)) {
            selected = 1;
        } else if (h.contains(clickX, clickY, gx, gy2)) {
            selected = -3;
        } else if (h.contains(clickX, clickY, gx2, gy)) {
            selected = -4;
        } else if (h.contains(clickX, clickY, gx, gy)) {
            selected = 0;
        }
        return selected;
    }

    @Override
    public boolean canBeSelected(int handle, int mode) {
        return handle == 0 || handle == 1 || handle == -3 || handle == -4;
    }

    @Override
    public final void paintHandles(JaxoGraphics2D g2, JaxoHandle h, int editMode) {
        Rectangle bBox = this.getBounds();
        int gx1 = bBox.x;
        int gy1 = bBox.y;
        int gx2 = bBox.x + bBox.width;
        int gy2 = bBox.y + bBox.height;
        h.paint(g2, gx1, gy1, this.isMarked(), !this.canBeSelected(0, editMode));
        h.paint(g2, gx1, gy2, this.isMarked(), !this.canBeSelected(1, editMode));
        h.paint(g2, gx2, gy1, this.isMarked(), !this.canBeSelected(-3, editMode));
        h.paint(g2, gx2, gy2, this.isMarked(), !this.canBeSelected(-4, editMode));
    }

    @Override
    public final float smallestDistanceTo(int px, int py) {
        Rectangle bBox = this.getBounds();
        int x = bBox.x;
        int y = bBox.y;
        int w = bBox.width;
        int h = bBox.height;
        int distX = px - x;
        int distY = py - y;
        float dist1 = (float)Math.sqrt(distX * distX + distY * distY);
        distX = px - x;
        distY = py - y - h;
        float dist2 = (float)Math.sqrt(distX * distX + distY * distY);
        distX = px - x - w;
        distY = py - y;
        float dist3 = (float)Math.sqrt(distX * distX + distY * distY);
        distX = px - x - w;
        distY = py - y - h;
        float dist4 = (float)Math.sqrt(distX * distX + distY * distY);
        return this.smallest(dist1, dist2, dist3, dist4);
    }

    private float smallest(float dist1, float dist2, float dist3, float dist4) {
        if (dist1 < dist2) {
            return this.smallest(dist1, dist3, dist4);
        }
        return this.smallest(dist2, dist3, dist4);
    }

    private float smallest(float dist1, float dist2, float dist3) {
        float dist = 0.0f;
        dist = dist1 < dist2 ? (dist1 < dist3 ? dist1 : dist3) : (dist2 < dist3 ? dist2 : dist3);
        return dist;
    }

    @Override
    public final void paintVisualAid(JaxoGraphics2D g2) {
        Rectangle bBox = this.getBounds();
        g2.drawRect(bBox.x, bBox.y, bBox.width, bBox.height);
    }

    @Override
    public final void paint(JaxoGraphics2D g2) {
        this.objectList.paint(g2);
    }

    @Override
    public final void moveBy(int deltaX, int deltaY) {
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        super.moveBy(deltaX, deltaY);
        this.objectList.moveAllObjects(deltaX, deltaY);
        Rectangle bBox = this.getBounds();
        this.setX(bBox.x);
        this.setY(bBox.y);
        this.setX2(bBox.x + bBox.width);
        this.setY2(bBox.y + bBox.height);
    }

    @Override
    public final String latexCommand(float scale, Dimension canvasDim) {
        return "%";
    }

    @Override
    public final String latexWidth() {
        return "%";
    }

    @Override
    public Rectangle getBounds() {
        return this.objectList.getBounds();
    }

    public final void clearGroup() {
        this.objectList.clear();
    }

    public final JaxoList<JaxoObject> getObjectList() {
        return this.objectList;
    }

    public final void setObjectList(JaxoList<JaxoObject> obList) {
        this.objectList = new JaxoObjectList<JaxoObject>(obList);
    }

    public final int size() {
        return this.objectList.size();
    }

    @Override
    public final void rescaleObject(int orx, int ory, float scale) {
        for (int i = 0; i < this.size(); ++i) {
            JaxoObject ob = (JaxoObject)this.getObjectList().get(i);
            ob.rescaleObject(orx, ory, scale);
        }
        Rectangle bBox = this.getBounds();
        this.setLocation(bBox.x, bBox.y, bBox.x + bBox.width, bBox.y + bBox.height);
    }

    public final void setNewScale(float scale) {
        this.rescaleObject(this.getX(), this.getY(), scale);
    }

    @Override
    public final void setStrokeWidth(float newStroke) {
        super.setStrokeWidth(newStroke);
        Float stroke = Float.valueOf(newStroke);
        for (int i = 0; i < this.size(); ++i) {
            JaxoObject ob = (JaxoObject)this.getObjectList().get(i);
            ob.setParameter("strokeWidth", Float.TYPE, stroke, false);
        }
    }

    public final int getAmp() {
        return this.groupAmp;
    }

    public final void setAmp(int amp) {
        this.groupAmp = amp;
        if (amp == 0) {
            return;
        }
        Integer amplitude = amp;
        for (int i = 0; i < this.size(); ++i) {
            JaxoObject ob = (JaxoObject)this.getObjectList().get(i);
            ob.setParameter("amp", Integer.TYPE, amplitude, false);
        }
    }

    public final int getLatexTextSize() {
        return this.groupTeXSize;
    }

    public final void setLatexTextSize(int teXSize) {
        this.groupTeXSize = teXSize;
        if (teXSize == 0) {
            return;
        }
        Integer size = teXSize;
        for (int i = 0; i < this.size(); ++i) {
            JaxoObject ob = (JaxoObject)this.getObjectList().get(i);
            ob.setParameter("latexTextSize", Integer.TYPE, size, false);
        }
    }

    public final Font getFont() {
        return this.groupTextFont;
    }

    public final void setFont(Font textFont) {
        this.groupTextFont = textFont;
        if (textFont == null) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            JaxoObject ob = (JaxoObject)this.getObjectList().get(i);
            ob.setParameter("font", Font.class, textFont, false);
        }
    }

    public final void setFontName(String name) {
        Font oldFont = this.getFont();
        Font newFont = oldFont == null ? new Font(name, JaxoPrefs.getIntPref("prefPSSTYLE"), JaxoPrefs.getIntPref("prefPSSIZE")) : new Font(name, oldFont.getStyle(), oldFont.getSize());
        this.setFont(newFont);
    }

    public final void setFontStyle(int style) {
        Font oldFont = this.getFont();
        Font newFont = oldFont == null ? new Font(JaxoPrefs.getStringPref("prefPSFAMILY"), style, JaxoPrefs.getIntPref("prefPSSIZE")) : new Font(oldFont.getName(), style, oldFont.getSize());
        this.setFont(newFont);
    }

    public final void setFontSize(int size) {
        Font oldFont = this.getFont();
        Font newFont = oldFont == null ? new Font(JaxoPrefs.getStringPref("prefPSFAMILY"), JaxoPrefs.getIntPref("prefPSSTYLE"), size) : new Font(oldFont.getName(), oldFont.getStyle(), size);
        this.setFont(newFont);
    }

    @Override
    public final void setColor(Color newColor) {
        super.setColor(newColor);
        if (newColor == null) {
            return;
        }
        for (int i = 0; i < this.size(); ++i) {
            JaxoObject ob = (JaxoObject)this.getObjectList().get(i);
            if (ob instanceof JaxoLatexText) continue;
            ob.setColor(newColor);
        }
    }

    public final boolean containsInstanceOf(Class<?> clazz) {
        boolean thereare = false;
        for (int i = 0; i < this.size(); ++i) {
            JaxoObject ob = (JaxoObject)this.getObjectList().get(i);
            if (ob instanceof JaxoGroup) {
                thereare = ((JaxoGroup)ob).containsInstanceOf(clazz);
                if (!thereare) continue;
                break;
            }
            if (!clazz.isInstance(ob)) continue;
            thereare = true;
            break;
        }
        return thereare;
    }

    @Override
    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        this.prepareGroupPanel(editPanel);
    }

    private void prepareGroupPanel(JaxoObjectEditPanel editPanel) {
        editPanel.addPositionPanel(this.getX(), this.getY(), 0, 0);
        editPanel.addReScalePanel(1, 0);
        editPanel.addColorPanel(this.getColor(), 2, 2, 0);
        if (this.containsInstanceOf(JaxoExtendedObject.class)) {
            editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        }
        if (this.containsInstanceOf(JaxoWiggleObject.class)) {
            editPanel.addWigglePanel(this.getAmp(), 1, 1);
        }
        if (this.containsInstanceOf(JaxoLatexText.class)) {
            editPanel.addLatexFontSizePanel(this.getLatexTextSize(), 2, 1);
        }
        if (this.containsInstanceOf(JaxoPSText.class)) {
            editPanel.addPSFontPanel(this.getFont(), 0, 2, 3);
        }
        editPanel.setTitleAndIcon("Group_parameters", "group.png");
    }
}

