/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.line;

import java.awt.BasicStroke;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jaxodraw.object.line.JaxoLineObject;
import net.sf.jaxodraw.util.JaxoUtils;

public abstract class JaxoDashLine
extends JaxoLineObject {
    private static final long serialVersionUID = 314159L;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.resetStroke();
    }

    protected void resetStroke() {
        if (JaxoUtils.zero(this.getStrokeWidth()) || JaxoUtils.zero(this.getDash())) {
            return;
        }
        this.setStroke(new BasicStroke(this.getStrokeWidth(), 1, 0, 10.0f, this.strokeDashes(), 0.0f));
    }

    protected GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        if (this.isDoubleLine()) {
            float length = (float)this.getRadius();
            float sepx = (float)this.getRelh() / length * this.getDLSeparation() / 2.0f;
            float sepy = (float)this.getRelw() / length * this.getDLSeparation() / 2.0f;
            gp.moveTo((float)this.getX() - sepx, (float)this.getY() + sepy);
            gp.lineTo((float)this.getX2() - sepx, (float)this.getY2() + sepy);
            gp.moveTo((float)this.getX() + sepx, (float)this.getY() - sepy);
            gp.lineTo((float)this.getX2() + sepx, (float)this.getY2() - sepy);
        } else {
            gp.moveTo(this.getX(), this.getY());
            gp.lineTo(this.getX2(), this.getY2());
        }
        return gp;
    }

    protected abstract float[] strokeDashes();

    protected String getAxo4JOptions(float scale) {
        float dashSize = this.getDash() / scale;
        StringBuffer optioncmd = new StringBuffer("dash,dashsize=").append(D_FORMAT.format(dashSize));
        if (this.isPaintArrow()) {
            float arpos = this.getArrowPosition();
            StringBuffer arrowcmd = new StringBuffer(this.getArrow().latexCommand(arpos, scale));
            if (this.isFlip()) {
                arrowcmd.append(",flip");
            }
            optioncmd.append(',').append(arrowcmd);
            if (this.isDoubleLine()) {
                optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            }
        } else if (this.isDoubleLine()) {
            optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
        }
        optioncmd.insert(0, '[').append(']');
        return optioncmd.toString();
    }
}

