/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.line;

import java.awt.geom.GeneralPath;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.line.JaxoLineObject;

public class JaxoFLine
extends JaxoLineObject {
    private static final long serialVersionUID = 314159L;

    public boolean isCopy(JaxoObject comp) {
        boolean isCopy = false;
        if (comp instanceof JaxoFLine) {
            isCopy = super.isCopy(comp);
        }
        return isCopy;
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        editPanel.add2PointsPanel(this.getPoints(), 0, 0);
        editPanel.addArrowPanel(this.isPaintArrow(), this.isFlip(), this.getArrowPosition(), 1, 0);
        editPanel.addArrowOptionsEditPanel(this.getArrow(), 2, 0);
        editPanel.addDoubleLinePanel(this.isDoubleLine(), this.getDLSeparation(), 0, 1);
        editPanel.addStrokePanel(this.getStrokeWidth(), 1, 1);
        editPanel.addColorPanel(this.getColor(), 2, 2, 1);
        editPanel.setTitleAndIcon("Fermion_line_parameters", "fline.png");
    }

    protected GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        if (this.isDoubleLine()) {
            float length = (float)this.getRadius();
            float sepx = (float)this.getRelh() / length * this.getDLSeparation() / 2.0f;
            float sepy = (float)this.getRelw() / length * this.getDLSeparation() / 2.0f;
            gp.moveTo((float)this.getX() - sepx, (float)this.getY() + sepy);
            gp.lineTo((float)this.getX2() - sepx, (float)this.getY2() + sepy);
            gp.moveTo((float)this.getX() + sepx, (float)this.getY() - sepy);
            gp.lineTo((float)this.getX2() + sepx, (float)this.getY2() - sepy);
        } else {
            gp.moveTo(this.getX(), this.getY());
            gp.lineTo(this.getX2(), this.getY2());
        }
        return gp;
    }

    protected String getAxo4JOptions(float scale) {
        StringBuffer optioncmd = new StringBuffer(128);
        if (this.isPaintArrow()) {
            float arpos = this.getArrowPosition();
            optioncmd.append(this.getArrow().latexCommand(arpos, scale));
            if (this.isFlip()) {
                optioncmd.append(",flip");
            }
            if (this.isDoubleLine()) {
                optioncmd.append(",double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            }
            optioncmd.insert(0, '[').append(']');
        } else if (this.isDoubleLine()) {
            optioncmd.append("double,sep=").append(D_FORMAT.format(this.getDLSeparation()));
            optioncmd.insert(0, '[').append(']');
        }
        return optioncmd.toString();
    }
}

