/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.object.vertex;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import net.sf.jaxodraw.object.Jaxo3PointObject;
import net.sf.jaxodraw.object.JaxoFillColorObject;
import net.sf.jaxodraw.object.JaxoObject;
import net.sf.jaxodraw.object.JaxoObjectEditPanel;
import net.sf.jaxodraw.object.arrow.JaxoArrow;
import net.sf.jaxodraw.util.JaxoColor;
import net.sf.jaxodraw.util.graphics.JaxoGraphics2D;

public class JaxoVertexT5
extends Jaxo3PointObject
implements JaxoFillColorObject {
    private static final long serialVersionUID = 314159L;
    private Color fillColor;
    private boolean filled = true;

    public final boolean isFilled() {
        return this.filled;
    }

    public final void setFilled(boolean value) {
        Boolean old = this.filled;
        this.filled = value;
        this.firePropertyChange("filled", old, this.filled);
    }

    public final Color getFillColor() {
        return this.fillColor;
    }

    public final void setFillColor(Color color) {
        Color old = this.fillColor;
        this.fillColor = color;
        this.firePropertyChange("fillColor", old, this.fillColor);
    }

    public final void setVertexPts(int sx1, int sy1, int sx2, int sy2, int sx3, int sy3) {
        this.setLocation(sx1, sy1, sx2, sy2, sx3, sy3);
    }

    public final void copyFrom(JaxoVertexT5 temp) {
        super.copyFrom(temp);
        this.setFillColor(temp.getFillColor());
        this.setFilled(temp.isFilled());
    }

    public void setState(JaxoObject o) {
        if (!(o instanceof JaxoVertexT5)) {
            throw new UnsupportedOperationException("Cannot copy from super type!");
        }
        this.copyFrom((JaxoVertexT5)o);
    }

    public final boolean isCopy(JaxoObject comp) {
        JaxoVertexT5 vertex;
        boolean isCopy = false;
        if (comp instanceof JaxoVertexT5 && (vertex = (JaxoVertexT5)comp).getFillColor().equals(this.getFillColor()) && vertex.isFilled() == this.isFilled() && super.isCopy(vertex)) {
            isCopy = true;
        }
        return isCopy;
    }

    public final void paint(JaxoGraphics2D g2) {
        GeneralPath gp = this.getObjectPath();
        if (this.isFilled()) {
            g2.setColor(this.getFillColor());
            g2.fill(gp);
        }
        g2.setColor(this.getColor());
        g2.setStroke(this.getStroke());
        g2.draw(gp);
    }

    public void paintVisualAid(JaxoGraphics2D g2) {
    }

    public Rectangle getBounds() {
        return this.getStroke().createStrokedShape(this.getObjectPath()).getBounds();
    }

    public final String latexCommand(float scale, Dimension canvasDim) {
        double ax1 = (float)this.getX() / scale;
        double ay1 = (float)(canvasDim.height - this.getY()) / scale;
        double ax2 = (float)this.getX2() / scale;
        double ay2 = (float)(canvasDim.height - this.getY2()) / scale;
        double ax3 = (float)this.getX3() / scale;
        double ay3 = (float)(canvasDim.height - this.getY3()) / scale;
        String command = "";
        if (this.isFilled()) {
            if (JaxoColor.isGrayScale(this.getFillColor())) {
                float grayScale = JaxoColor.getGrayScaleFloat(this.getFillColor());
                command = "\\GTri(" + D_FORMAT.format(ax1) + "," + D_FORMAT.format(ay1) + ")" + "(" + D_FORMAT.format(ax2) + "," + D_FORMAT.format(ay2) + ")" + "(" + D_FORMAT.format(ax3) + "," + D_FORMAT.format(ay3) + ")" + "{" + GRAY_SCALE_FORMAT.format(grayScale) + "}";
            } else {
                String tlc = JaxoColor.getColorName(this.getColor());
                String tfc = JaxoColor.getColorName(this.getFillColor());
                command = "\\CTri(" + D_FORMAT.format(ax1) + "," + D_FORMAT.format(ay1) + ")" + "(" + D_FORMAT.format(ax2) + "," + D_FORMAT.format(ay2) + ")" + "(" + D_FORMAT.format(ax3) + "," + D_FORMAT.format(ay3) + ")" + "{" + tlc + "}" + "{" + tfc + "}";
            }
        } else {
            command = "\\ETri(" + D_FORMAT.format(ax1) + "," + D_FORMAT.format(ay1) + ")" + "(" + D_FORMAT.format(ax2) + "," + D_FORMAT.format(ay2) + ")" + "(" + D_FORMAT.format(ax3) + "," + D_FORMAT.format(ay3) + ")";
        }
        return command;
    }

    public void setPreferences() {
        super.setPreferences();
        this.setFilled(true);
        this.setFillColor(JaxoColor.getDefaultFillColor(this.getColor()));
    }

    private GeneralPath getObjectPath() {
        GeneralPath gp = this.getGeneralPath();
        gp.reset();
        gp.moveTo(this.getX(), this.getY());
        gp.lineTo(this.getX2(), this.getY2());
        gp.lineTo(this.getX3(), this.getY3());
        gp.closePath();
        return gp;
    }

    public void prepareEditPanel(JaxoObjectEditPanel editPanel) {
        this.prepareT5Panel(editPanel);
    }

    private void prepareT5Panel(JaxoObjectEditPanel editPanel) {
        editPanel.add3PointsPanel(this.getPoints(), 0, 0);
        editPanel.addStrokePanel(this.getStrokeWidth(), 0, 1);
        editPanel.addFillLineColorPanels(this.getColor(), this.getFillColor(), this.isFilled(), 1, 1, 1, 0);
        editPanel.setTitleAndIcon("Vertex_parameters", "vertexT5.png");
    }

    public JaxoArrow.Coordinates arrowCoordinates() {
        return null;
    }
}

