/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import net.sf.jaxodraw.plugin.JaxoPlugin;
import net.sf.jaxodraw.util.JaxoLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaxoPluginLoader {
    public List<JaxoPlugin> loadPlugins(String pluginDirName) {
        ArrayList<JaxoPlugin> plugins = new ArrayList<JaxoPlugin>(8);
        String[] children = JaxoPluginLoader.getJars(pluginDirName);
        if (children == null) {
            JaxoLog.debug("No plugin directory found, no plugins loaded!");
            return plugins;
        }
        for (int i = 0; i < children.length; ++i) {
            String filename = new File(pluginDirName, children[i]).toString();
            this.loadPluginFromJar(filename, plugins);
        }
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            ((JaxoPlugin)it.next()).loadProperties();
        }
        return plugins;
    }

    public List<JaxoPlugin> reValidate(String pluginDirName) {
        this.jarLoader().reset();
        return this.loadPlugins(pluginDirName);
    }

    public List<JaxoPlugin> loadPluginsFromJar(String filename) {
        ArrayList<JaxoPlugin> plugins = new ArrayList<JaxoPlugin>(8);
        this.loadPluginFromJar(filename, plugins);
        if (plugins.isEmpty()) {
            return null;
        }
        for (JaxoPlugin plugin : plugins) {
            plugin.loadProperties();
        }
        return plugins;
    }

    public static File getPluginJar(JaxoPlugin plugin, String pluginDir) {
        String[] children = JaxoPluginLoader.getJars(pluginDir);
        if (children == null) {
            return null;
        }
        for (int i = 0; i < children.length; ++i) {
            File file = new File(pluginDir, children[i]);
            JarFile jarFile = JaxoPluginLoader.getJarFile(file.toString());
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String clas;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith("JaxoPlugin.class") || !(clas = name.substring(0, name.lastIndexOf(".class")).replace('/', '.')).equals(plugin.pluginId())) continue;
                return file;
            }
        }
        return null;
    }

    private JarLoader jarLoader() {
        return JarLoader.getInstance();
    }

    private static JarFile getJarFile(String filename) {
        try {
            return new JarFile(filename);
        }
        catch (IOException e) {
            JaxoLog.debug(filename + " cannot be loaded, ignoring!", e);
            return null;
        }
    }

    private void loadPluginFromJar(String filename, List<JaxoPlugin> plugins) {
        JarFile jarFile = JaxoPluginLoader.getJarFile(filename);
        if (jarFile == null) {
            return;
        }
        try {
            String mainclass = jarFile.getManifest().getMainAttributes().getValue("Main-Class");
            if (mainclass != null && this.jarLoader().isLoaded(mainclass)) {
                JaxoLog.warn(mainclass + ": A Main-Class with this name is already loaded! Ignoring.");
                return;
            }
        }
        catch (IOException ex) {
            JaxoLog.debug(ex);
            JaxoLog.warn("Failed to load plugin from: " + jarFile.getName());
            return;
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.endsWith("JaxoPlugin.class")) continue;
            this.jarLoader().addJar(filename);
            String clas = name.substring(0, name.lastIndexOf(".class")).replace('/', '.');
            if (this.jarLoader().isLoaded(clas)) {
                JaxoLog.warn(clas + ": double loaded!");
            }
            this.loadPluginFromClass(clas, plugins);
        }
    }

    private void loadPluginFromClass(String clas, List<JaxoPlugin> plugins) {
        Class<?> jarLoaderClass = null;
        try {
            jarLoaderClass = this.jarLoader().loadClass(clas);
        }
        catch (ClassNotFoundException e) {
            this.logIgnor(clas, " cannot be loaded", e);
            return;
        }
        JaxoLog.debug("Class " + clas + " successfully loaded!");
        Object pluginClass = null;
        try {
            pluginClass = jarLoaderClass.newInstance();
        }
        catch (IllegalAccessException e) {
            this.logIgnor(clas, " cannot be accessed", e);
            return;
        }
        catch (InstantiationException e) {
            this.logIgnor(clas, " cannot be instantiated", e);
            return;
        }
        catch (NoClassDefFoundError e) {
            this.logIgnor(clas, " is missing dependencies", new Exception(e));
            return;
        }
        if (pluginClass instanceof JaxoPlugin) {
            JaxoPlugin plugin = pluginClass;
            if (plugin.pluginId() == null) {
                JaxoLog.warn(clas + " has null pluginId(), ignoring!");
            } else if (plugin.pluginId().equals(jarLoaderClass.getName())) {
                plugins.add(plugin);
                JaxoLog.info(clas + ": Plugin registered!");
            } else {
                JaxoLog.warn(clas + " has invalid pluginId(), ignoring!");
            }
        } else {
            JaxoLog.warn(clas + " is not a JaxoPlugin, ignoring!");
        }
    }

    private void logIgnor(String clas, String msg, Exception e) {
        JaxoLog.warn("Plugin class " + clas + msg + ", ignoring!");
        JaxoLog.debug(e);
    }

    private static String[] getJars(String pluginDirName) {
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        return new File(pluginDirName).list(filter);
    }

    private static final class JarLoader
    extends URLClassLoader {
        private static JarLoader jarLoader;

        private JarLoader() {
            super(new URL[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static JarLoader getInstance() {
            Class<JarLoader> clazz = JarLoader.class;
            synchronized (JarLoader.class) {
                if (jarLoader == null) {
                    jarLoader = new JarLoader();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return jarLoader;
            }
        }

        public boolean isLoaded(String clazz) {
            return this.findLoadedClass(clazz) != null;
        }

        public void reset() {
            jarLoader = null;
        }

        public void addJar(String path) {
            String uri = new File(path).toURI().toString();
            String urlPath = "jar:" + uri + "!/";
            JaxoLog.debug("Loading plugin from " + path + "...");
            try {
                this.addURL(new URL(urlPath));
            }
            catch (MalformedURLException e) {
                JaxoLog.debug("Could not load " + urlPath + ", ignoring!", e);
            }
        }
    }
}

