/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jaxodraw.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import net.sf.jaxodraw.util.JaxoDictionary;
import net.sf.jaxodraw.util.JaxoLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JaxoLanguage {
    public static final String ENGLISH = "english";
    public static final String GERMAN = "german";
    public static final String FRENCH = "french";
    public static final String ITALIAN = "italian";
    public static final String SPANISH = "spanish";
    private static final String BUNDLE_NAME = "resources/properties/language";
    private static final Locale SPANISH_LOCALE = new Locale("es");
    private static ResourceBundle languageBundle;
    private static Locale locale;
    private static Map<String, MessageFormat> messageFormats;
    private static final String[] KNOWN_LANGUAGES;
    private static final Map<String, PluginBundle> PLUGIN_BUNDLES;

    private JaxoLanguage() {
    }

    public static void registerBundle(Class<?> c) {
        PLUGIN_BUNDLES.put(c.getName(), new PluginBundle(c, locale));
        JaxoLog.debug("Registered language bundle for: " + c.getName());
    }

    public static void registerBundle(Class<?> c, JaxoDictionary d) {
        String n = c.getName();
        int dot = n.lastIndexOf(46);
        int plugin = n.indexOf(".plugin.");
        if (plugin > 0 && dot != plugin + 7) {
            JaxoLanguage.registerBundle(c);
            d.setValues(c.getName(), "");
        } else {
            d.setValues(null, n.substring(dot + 1) + ".");
        }
    }

    public static void removeBundle(Class<?> c) {
        PluginBundle o = PLUGIN_BUNDLES.remove(c.getName());
        if (o != null) {
            JaxoLog.debug("Removed bundle for: " + c.getName());
        }
    }

    public static void languageChanged(String language) {
        locale = language.equals(ENGLISH) ? Locale.ENGLISH : (language.equals(GERMAN) ? Locale.GERMAN : (language.equals(FRENCH) ? Locale.FRENCH : (language.equals(ITALIAN) ? Locale.ITALIAN : (language.equals(SPANISH) ? SPANISH_LOCALE : Locale.ENGLISH))));
        for (PluginBundle b : PLUGIN_BUNDLES.values()) {
            b.setResourceBundleFor(locale);
        }
        languageBundle = ResourceBundle.getBundle(BUNDLE_NAME, locale);
        messageFormats.clear();
    }

    public static Locale locale() {
        return locale;
    }

    public static String label(String key) {
        return JaxoLanguage.message("JaxoDraw.label%0", JaxoLanguage.translate(key));
    }

    public static String message(String key, Object argument) {
        return JaxoLanguage.message(key, new Object[]{argument});
    }

    public static String bundleMessage(String key, String bundleId, Object argument) {
        return JaxoLanguage.bundleMessage(key, bundleId, new Object[]{argument});
    }

    public static String message(String key, Object argument1, Object argument2) {
        return JaxoLanguage.message(key, new Object[]{argument1, argument2});
    }

    public static String bundleMessage(String key, String bundleId, Object argument1, Object argument2) {
        return JaxoLanguage.bundleMessage(key, bundleId, new Object[]{argument1, argument2});
    }

    public static String message(String key, Object[] arguments) {
        return JaxoLanguage.bundleMessage(key, null, arguments);
    }

    public static String bundleMessage(String key, String bundleId, Object[] arguments) {
        if (arguments.length == 0) {
            if (bundleId == null) {
                return JaxoLanguage.translate(key);
            }
            return JaxoLanguage.bundleTranslate(key, bundleId);
        }
        String totalKey = bundleId + "//" + key;
        MessageFormat f = messageFormats.get(totalKey);
        if (f == null) {
            f = bundleId == null ? new MessageFormat(JaxoLanguage.translate(key)) : new MessageFormat(JaxoLanguage.bundleTranslate(key, bundleId));
            messageFormats.put(totalKey, f);
        }
        return f.format(arguments);
    }

    public static String translate(String key) {
        return JaxoLanguage.bundleTranslate(key, null);
    }

    public static String bundleTranslate(String akey, String abundleId) {
        String key = akey;
        String bundleId = abundleId;
        if ("".equals(key)) {
            return "";
        }
        if (key.charAt(0) == '/') {
            key = key.substring(1);
            bundleId = null;
        }
        if (bundleId == null) {
            return languageBundle.getString(key);
        }
        PluginBundle b = PLUGIN_BUNDLES.get(bundleId);
        if (b == null) {
            JaxoLog.warn("No language bundle found for id: " + bundleId);
            return key;
        }
        return b.getString(key);
    }

    public static String getLanguageFor(int mode) {
        String lang = "";
        switch (mode) {
            case 4171: {
                lang = ENGLISH;
                break;
            }
            case 4172: {
                lang = GERMAN;
                break;
            }
            case 4173: {
                lang = FRENCH;
                break;
            }
            case 4174: {
                lang = ITALIAN;
                break;
            }
            case 4175: {
                lang = SPANISH;
                break;
            }
        }
        return lang;
    }

    public static String[] knownLanguages() {
        return (String[])KNOWN_LANGUAGES.clone();
    }

    static {
        KNOWN_LANGUAGES = new String[]{ENGLISH, GERMAN, FRENCH, ITALIAN, SPANISH};
        PLUGIN_BUNDLES = new HashMap<String, PluginBundle>(8);
        messageFormats = new HashMap<String, MessageFormat>(16);
        JaxoLanguage.languageChanged(ENGLISH);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginBundle {
        private final Class<?> klass;
        private ResourceBundle bundle;

        PluginBundle(Class<?> c, Locale l) {
            this.klass = c;
            this.setResourceBundleFor(l);
        }

        public final void setResourceBundleFor(Locale value) {
            this.bundle = ResourceBundle.getBundle(PluginBundle.bundleName(this.klass), locale, this.klass.getClassLoader());
        }

        public final String getString(String key) {
            return this.bundle.getString(key);
        }

        private static String bundleName(Class<?> c) {
            int dot = c.getName().lastIndexOf(46);
            return c.getName().substring(0, dot + 1).replace('.', '/').concat(JaxoLanguage.BUNDLE_NAME);
        }
    }
}

