<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xdoc="http://maven.apache.org/XDOC/2.0">
    <!-- Output method -->
    <xsl:output method="html" encoding="iso-8859-1" indent="no"/>

    <!-- Defined parameters (overrideable) -->
    <xsl:param name="relative-path" select="'.'"/>
    <xsl:param name="JDtitle"/>
    <xsl:param name="JDversion"/>

    <!-- Process an entire document into an HTML page -->
    <xsl:template match="xdoc:document">
        <xsl:comment>Do not edit this autogenerated HTML file; edit src/xdocs files instead. </xsl:comment>
        <xsl:variable name="project" select="document('../navigation.xml')/project"/>
        <html>
            <head>
                <style type="text/css" media="all">
                  @import url("./css/maven-base.css");
                  @import url("./css/maven-theme.css");
                  @import url("./css/site.css");
                </style>

                <xsl:apply-templates select="meta"/>
                <title>
                    <xsl:value-of select="$project/title"/> - <xsl:value-of select="properties/title"/>
                </title>
                <xsl:for-each select="properties/author">
                    <xsl:variable name="name">
                        <xsl:value-of select="."/>
                    </xsl:variable>
                    <xsl:variable name="email">
                        <xsl:value-of select="@email"/>
                    </xsl:variable>
                    <meta name="author" content="{$name}"/>
                    <meta name="email" content="{$email}"/>
                </xsl:for-each>
            </head>
            <body>
                <xsl:comment>HEADER</xsl:comment>
                <h1><xsl:value-of select="$JDtitle"/>-<xsl:value-of select="$JDversion"/> -- User Guide</h1>
                <xsl:comment>TOP LINK MENU NAVIGATION</xsl:comment>
                <xsl:apply-templates select="$project/body/menu"/>
                <xsl:apply-templates select="xdoc:body"/>
            </body>
        </html>
    </xsl:template>

    <!-- Process top link menu navigation bar -->
    <xsl:template match="menu">
        <div align="center" style="font-size: 100%">
            <table>
                <tr>
                    <xsl:for-each select="./item">
                        <td><xsl:call-template name="linkitem"/></td>
                    </xsl:for-each>
                </tr>
            </table>
        </div>
    </xsl:template>

    <!-- Process a topmenu item for the top navigation bar -->
    <xsl:template name="linkitem">
        <xsl:variable name="href">
                    <xsl:value-of select="$relative-path"/>
                    <xsl:value-of select="@href"/>
        </xsl:variable>
        <a href="{$href}">
            <xsl:attribute name="title">
                <xsl:value-of select="@name"/>
            </xsl:attribute>
            <xsl:value-of select="@name"/>
        </a> 
    </xsl:template>

    <xsl:template match="xdoc:body">
        <xsl:apply-templates/>
    </xsl:template>

    <!-- Process a documentation section -->
    <xsl:template match="xdoc:section">
        <xsl:variable name="name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="linkname">
            <xsl:value-of select="translate(@name,' ','_')"/>
        </xsl:variable>
            <!-- Section heading -->
                        <div class="section">
                        <a name="{$linkname}">
                            <h2>
                                <xsl:value-of select="@name"/>
                            </h2>
                        </a>
            <!-- Section body -->
                        <xsl:apply-templates/>
                        </div>
    </xsl:template>

    <!-- Process a documentation subsection -->
    <xsl:template match="xdoc:subsection">
        <xsl:variable name="name">
            <xsl:value-of select="@name"/>
        </xsl:variable>
        <xsl:variable name="linkname">
            <xsl:value-of select="translate(@name,' ','_')"/>
        </xsl:variable>
            <!-- Subsection heading -->
                        <div class="section">
                        <a name="{$linkname}">
                            <h3>
                                <xsl:value-of select="@name"/>
                            </h3>
                        </a>
            <!-- Subsection body -->
                        <xsl:apply-templates/>
                        </div>
    </xsl:template>

    <!-- Process everything else by just passing it through -->
    <xsl:template match="*|@*">
        <xsl:copy>
            <xsl:apply-templates select="@*|*|text()"/>
        </xsl:copy>
    </xsl:template>

    <xsl:template match="xdoc:macro">
        <!-- ignore -->
    </xsl:template>

    <!-- Process a source code example -->
    <xsl:template match="xdoc:source">
        <div class="source"><pre><xsl:apply-templates/></pre></div>
    </xsl:template>

</xsl:stylesheet>
