/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public abstract class OperatingSystem {
    public static final OperatingSystem UNIX = new Unix();
    public static final OperatingSystem MACOS_X = new MacOSX();
    public static final OperatingSystem WINDOWS = new Windows();
    private static OperatingSystem os;

    public abstract String getInstallDirectory(String var1);

    public String toString() {
        return "Unknown OS";
    }

    public String getShortcutDirectory(String version) {
        return this.getInstallDirectory(version);
    }

    public ScriptParameters createScriptParameters(String version) {
        return new ScriptParameters(this.getInstallDirectory(version), this.getShortcutDirectory(version), null, 96);
    }

    public void createScript(Install installer, ScriptParameters scriptParams) throws IOException {
        System.out.println("Automatic script creation is not available for this operating system !");
    }

    public void mkdirs(String directory) throws IOException {
        File file = new File(directory);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public void chmodScript(String fileName) throws IOException {
    }

    public String getExecScriptExtension() {
        return null;
    }

    public static OperatingSystem getOperatingSystem() {
        if (os != null) {
            return os;
        }
        String osName = System.getProperty("os.name");
        os = osName.indexOf("Windows") != -1 ? WINDOWS : (osName.indexOf("Mac") != -1 ? MACOS_X : UNIX);
        return os;
    }

    public static OperatingSystem[] getAvailableOperatingSystems() {
        OperatingSystem[] oses = new OperatingSystem[]{UNIX, MACOS_X, WINDOWS};
        return oses;
    }

    public static void setOperatingSystem(OperatingSystem newOs) {
        os = newOs;
    }

    public static void main(String[] args) {
        OperatingSystem os = WINDOWS;
        Install i = new Install();
        ScriptParameters scriptParams = new ScriptParameters("c:/home/reynal/temp", "c:/home/reynal/temp/bin", null, 96);
        try {
            os.createScript(i, scriptParams);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static class Windows
    extends OperatingSystem {
        public String getInstallDirectory(String version) {
            return "C:\\jPicEdt\\" + version;
        }

        public String getShortcutDirectory(String version) {
            return "C:\\jPicEdt" + version;
        }

        public String toString() {
            return "MS Windows";
        }

        public String getExecScriptExtension() {
            return ".bat";
        }

        public void createScript(Install installer, ScriptParameters scriptParams) throws IOException {
            String script = scriptParams.binDir + "\\jpicedt.bat";
            script = script.replace('/', '\\');
            String installDir = scriptParams.installDir.replace('/', '\\');
            FileWriter out = new FileWriter(script);
            out.write("rem Java heap size amounts to 96 megabytes by default; increase if you run out of memory (see quickstart.html)\r\n");
            out.write("\"" + scriptParams.javaHome + "\\bin\\java\" " + "-Xmx" + Integer.toString(scriptParams.javaHeap) + "m " + "-classpath \"" + installDir + ";" + installDir + "\\lib\\jpicedt.jar\" " + "jpicedt.JPicEdt " + "%1\r\n");
            out.close();
        }
    }

    public static class MacOSX
    extends Unix {
        public String getInstallDirectory(String version) {
            return "/Applications/jPicEdt" + version;
        }

        public String getShortcutDirectory(String version) {
            return "/usr/bin";
        }

        public String toString() {
            return "Mac OS X";
        }
    }

    public static class Unix
    extends OperatingSystem {
        public String getInstallDirectory(String version) {
            return "/usr/share/jpicedt/" + version;
        }

        public String getShortcutDirectory(String version) {
            return "/usr/bin";
        }

        public String toString() {
            return "Unix";
        }

        public void createScript(Install installer, ScriptParameters scriptParams) throws IOException {
            String script = scriptParams.binDir + "/jpicedt";
            File f = new File(script);
            if (f.isDirectory()) {
                script = script + "/jpicedt";
                f = new File(script);
            }
            f.delete();
            FileWriter out = new FileWriter(script);
            out.write("#!/bin/sh\n");
            out.write("# Java heap size, in megabytes; increase if you experience OutOfMemory errors (see quickstart.html)\n");
            out.write("JAVA_HEAP_SIZE=" + Integer.toString(scriptParams.javaHeap) + "\n");
            out.write("exec " + scriptParams.javaHome + "/bin/java " + "-Xmx${JAVA_HEAP_SIZE}m ${JPICEDT} " + "-classpath \"${CLASSPATH}:" + scriptParams.installDir + ":" + scriptParams.installDir + "/lib/jpicedt.jar\" " + "jpicedt.JPicEdt " + "$@\n");
            out.close();
            this.chmodScript(script);
        }

        public void chmodScript(String fileName) throws IOException {
            String[] chmodArgs = new String[]{"chmod", "755", fileName};
            this.exec(chmodArgs);
        }

        public String getExecScriptExtension() {
            return ".sh";
        }

        public void mkdirs(String directory) throws IOException {
            File file = new File(directory);
            if (!file.exists()) {
                String[] mkdirArgs = new String[]{"mkdir", "-m", "755", "-p", directory};
                this.exec(mkdirArgs);
            }
        }

        public void exec(String[] args) throws IOException {
            Process proc = Runtime.getRuntime().exec(args);
            proc.getInputStream().close();
            proc.getOutputStream().close();
            proc.getErrorStream().close();
            try {
                proc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static class ScriptParameters {
        String installDir;
        String binDir;
        String javaHome;
        int javaHeap;

        public ScriptParameters() {
            this.javaHeap = 96;
            this.javaHome = System.getProperty("java.home");
            this.setDirectories(System.getProperty("user.home"), null);
        }

        public ScriptParameters(String installDir, String binDir, String javaHome, int javaHeap) {
            this.setDirectories(installDir, binDir);
            if (javaHeap < 32) {
                javaHeap = 32;
            }
            if (javaHome == null) {
                javaHome = System.getProperty("java.home");
            }
            this.javaHome = javaHome;
            this.javaHeap = javaHeap;
        }

        public void setDirectories(String installDir, String binDir) {
            if (installDir == null) {
                installDir = System.getProperty("user.home");
            }
            this.installDir = installDir;
            if (binDir == null) {
                binDir = installDir;
            }
            this.binDir = binDir;
            if (installDir != null && installDir.endsWith(File.separator)) {
                installDir = installDir.substring(0, installDir.length() - 1);
            }
            if (binDir != null && binDir.endsWith(File.separator)) {
                binDir = binDir.substring(0, binDir.length() - 1);
            }
        }
    }
}

