/**
	 Album Cover Grabber - Grabs album covers automatically off the internet
	 Copyright (C) 2002  Kevin M Schmidt

	 This program is free software; you can redistribute it and/or modify
	 it under the terms of the GNU General Public License as published by
	 the Free Software Foundation; either version 2 of the License, or
	 (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 GNU General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; if not, write to the Free Software
	 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber;

import java.io.*;

import java.awt.*;

import org.apache.regexp.*;
import com.bluedragontavern.albumgrabber.google.*;
import com.bluedragontavern.albumgrabber.util.*;

/**
 * Album data object
 */
public class Album
	extends ItemToGrab
{
	private File albumDir;
	private String searchArtistName = null;
	private String searchAlbumName = null;
	private String foundArtistName = null;
	private String foundAlbumName = null;
	private String albumUrl = null;
	private String artistUrl = null;
	private String imageUrl = null;
	private Image image = null;
	private byte[] imageBytes = null;

	/**
	 * Constructor
	 * @param albumDir DOCUMENT ME!
	 */
	public Album(File albumDir)
		throws Exception
	{
		this.albumDir = albumDir;

		RE underscoresToSpacesRE = new RE("_");
		searchArtistName = albumDir.getParentFile().getName();
		searchAlbumName = albumDir.getName();

		//Replace underscores with spaces in artist and album names
		RE underscoreToSpace = new RE("_");
		searchArtistName = underscoreToSpace.subst(searchArtistName, " ",
																 RE.REPLACE_ALL);
		searchAlbumName = underscoreToSpace.subst(searchAlbumName, " ",
																RE.REPLACE_ALL);
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public String getImageUrl()
	{
		return imageUrl;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param imageUrl DOCUMENT ME!
	 */
	public void setImageUrl(String imageUrl)
	{
		this.imageUrl = imageUrl;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public String getAlbumUrl()
	{
		return albumUrl;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param albumUrl DOCUMENT ME!
	 */
	public void setAlbumUrl(String albumUrl)
	{
		this.albumUrl = albumUrl;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @return DOCUMENT ME!
	 */
	public String getArtistUrl()
	{
		return artistUrl;
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param albumUrl DOCUMENT ME!
	 */
	public void setArtistUrl(String artistUrl)
	{
		this.artistUrl = artistUrl;
	}

	/**
	 * Set found artist name
	 * @param foundArtistName DOCUMENT ME!
	 */
	public void setFoundArtistName(String foundArtistName)
	{
		this.foundArtistName = foundArtistName;
	}

	/**
	 * Set found album name
	 * @param foundAlbumName DOCUMENT ME!
	 */
	public void setFoundAlbumName(String foundAlbumName)
	{
		this.foundAlbumName = foundAlbumName;
	}

	/**
	 * Get the album file
	 * @return DOCUMENT ME!
	 */
	public File getAlbumDir()
	{
		return albumDir;
	}

	/**
	 * Get the name of the artist being searched for
	 * @return DOCUMENT ME!
	 */
	public String getSearchArtistName()
	{
		return searchArtistName;
	}

	/**
	 * Get the name of the album being searched for
	 * @return DOCUMENT ME!
	 */
	public String getSearchAlbumName()
	{
		return searchAlbumName;
	}

	/**
	 * Get the found artist name
	 * @return DOCUMENT ME!
	 */
	public String getFoundArtistName()
	{
		return foundArtistName;
	}

	/**
	 * Get the found album name
	 * @return DOCUMENT ME!
	 */
	public String getFoundAlbumName()
	{
		return foundAlbumName;
	}

	/**
	 * Get the awt Image for this album
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public Image getImage()
		throws Exception
	{
		if (image == null)
		{
			//Compute the awt Image for display
			image = Toolkit.getDefaultToolkit().createImage(getImageBytes());
		}

		return image;
	}

	/**
	 * Get the image bytes
	 * @return DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	public byte[] getImageBytes()
		throws Exception
	{
		if (imageBytes == null)
		{
			//Get the bytes from the url
			imageBytes = NetUtil.getImageBytes(imageUrl);
		}

		return imageBytes;
	}

	/**
	 * Write the image to disk
	 * @throws Exception DOCUMENT ME!
	 */
	public void writeImage()
		throws Exception
	{
		FileOutputStream fos = new FileOutputStream(new File(albumDir,
			albumDir.getName() + ".jpg"));

		//If using thumbnails, set the image URL to the full sized image
		if (hasThumbnails())
		{
			imageUrl = ( (Thumbnail) thumbnails.elementAt(0)).getFullImageUrl();
			imageBytes = ( (Thumbnail) thumbnails.elementAt(0)).getFullImageBytes();
		}

		fos.write(getImageBytes());
		fos.close();
		Report.getInstance().incNumAlbumsStored();
	}

	/**
	 * To string in "artist - album" format
	 * @return DOCUMENT ME!
	 */
	public String toStringSearch()
	{
		return searchArtistName + " - " + searchAlbumName;
	}

	/**
	 * To string in "artist - album" format
	 * @return DOCUMENT ME!
	 */
	public String toStringFound()
	{
		return foundArtistName + " - " + foundAlbumName;
	}
}