/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber;

import java.io.*;
import java.util.*;

import com.bluedragontavern.albumgrabber.allmusic.*;
import com.bluedragontavern.albumgrabber.google.*;
import com.bluedragontavern.albumgrabber.gui.*;

/**
 * Main program
 * <p>Title: </p>
 *
 * <p>Description: </p>
 *
 * <p>Copyright: Copyright (c) 2002</p>
 *
 * <p>Company: </p>
 *
 * @author not attributable
 * @version 1.0
 */
public class AlbumGrabber
	implements Observer
{
	private static Mp3RootChooser mp3RootChooser = Mp3RootChooser.getInstance();

	/**
	 * Main
	 * @param argv DOCUMENT ME!
	 */
	public static void main(String[] argv)
	{
		try
		{
			AlbumGrabber ag = new AlbumGrabber();
			Report.getInstance().setStartTime(System.currentTimeMillis());
			mp3RootChooser.addGoButtonObserver(ag);
			mp3RootChooser.loadFrame();
		}
		catch (Exception ex)
		{
			System.out.println("Exception: " + ex);
		}
	}

	/**
	 * Search all the artists dirs under the root dir
	 * @param mp3root DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	private static void processRoot()
		throws Exception
	{
		File mp3root = new File(mp3RootChooser.getMp3Root());

		if (mp3root.exists() == false)
		{
			throw new Exception("MP3 root: " + mp3root.getName() +
									  "does not exist!");
		}

		//Get the list of artists to search for
		File[] artists = mp3root.listFiles();

		for (int i = 0; i < artists.length; ++i)
		{
			if (artists[i].isDirectory())
			{
				//Grab the artist pics if wanted
				if (mp3RootChooser.isArtistSelected())
				{
					grabArtist(artists[i]);
				}

				//Grab the album pics if wanted
				if (mp3RootChooser.isAlbumSelected())
				{
					//Process the artist dir
					processArtistDir(artists[i]);
				}
			}
		}

		ExitProgram.setAlbumGrabberFinished(true);
	}

	/**
	 * Process an artist dir
	 * @param artistDir DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	private static void processArtistDir(File artistDir)
		throws Exception
	{
		//Get albums for the artist
		File[] albums = artistDir.listFiles();

		for (int i = 0; i < albums.length; ++i)
		{
			if (albums[i].isDirectory())
			{
				grabAlbum(albums[i]);
			}
		}
	}

	/**
	 * Given an album dir, grab it!
	 * @param albumDir DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	private static void grabAlbum(File albumDir)
		throws Exception
	{
		//Create an Album object
		Album album = new Album(albumDir);

		//Before searching, make sure we dont already have a gif or jpg for this album
		File albumJpg = new File(albumDir, albumDir.getName() + ".jpg");
		File albumGif = new File(albumDir, albumDir.getName() + ".gif");
		File albumPng = new File(albumDir, albumDir.getName() + ".png");
		File albumBmp = new File(albumDir, albumDir.getName() + ".bmp");

		if (albumJpg.exists() == true || albumGif.exists() == true ||
			 albumPng.exists() == true || albumBmp.exists() == true)
		{
			Report.getInstance().incNumAlbumsSkipped();

			return;
		}

		//Increment number of albums processed
		Report.getInstance().incNumAlbumsProcessed();

		//Search for the album
		search(album);
	}

	/**
	 * Given an album dir, grab it!
	 * @param albumDir DOCUMENT ME!
	 * @throws Exception DOCUMENT ME!
	 */
	private static void grabArtist(File artistDir)
		throws Exception
	{
		//Create an Album object
		Artist artist = new Artist(artistDir);

		//Before searching, make sure we dont already have a gif or jpg for this album
		File artistJpg = new File(artistDir, artistDir.getName() + ".jpg");
		File artistGif = new File(artistDir, artistDir.getName() + ".gif");
		File artistPng = new File(artistDir, artistDir.getName() + ".png");
		File artistBmp = new File(artistDir, artistDir.getName() + ".bmp");

		if (artistJpg.exists() == true || artistGif.exists() == true ||
			 artistPng.exists() == true || artistBmp.exists() == true)
		{
			Report.getInstance().incNumArtistsSkipped();

			return;
		}

		//Increment number of albums processed
		Report.getInstance().incNumArtistsProcessed();

		//Search for the artist
		search(artist);
	}

	/**
	 * Run the search
	 */
	private static void search(ItemToGrab item)
	{
		try
		{
			if (item instanceof Album)
			{
				//If we are searching artist pics from google
				if (Mp3RootChooser.getInstance().isGoogeAlbumSearch())
				{
					item.setThumbnails(ImageSearch.getThumbnails(
						( (Album) item).toStringSearch(), 0));

					//If thumbnails present, mark as found
					if (item.hasThumbnails())
					{
						//Increment num artists sucessfully located
						Report.getInstance().incNumArtistsLocated();
						item.found();
					}
				}
				else
				{ //Search artist pics from allmusic
					item = AlbumSearch.search( (Album) item);
				}
			}
			else if (item instanceof Artist)
			{
				//If we are searching artist pics from google
				if (Mp3RootChooser.getInstance().isGoogeArtistSearch())
				{
					item.setThumbnails(ImageSearch.getThumbnails(
						( (Artist) item).getSearchArtistName(),
						0));

					//If thumbnails present, mark as found
					if (item.hasThumbnails())
					{
						//Increment num artists sucessfully located
						Report.getInstance().incNumArtistsLocated();
						item.found();
					}
				}
				else
				{ //Search artist pics from allmusic
					item = ArtistSearch.search( (Artist) item);
				}
			}

			if (item.isFound())
			{
				ImageChooserMgr.getInstance().addItem(item);
			}
		}
		catch (Exception ex)
		{
			System.out.println(ex);
		}
	}

	/**
	 * Called when the user hits GO on the main screen.
	 */
	public void update(Observable o, Object arg)
	{
		new Thread()
		{
			public void run()
			{
				try
				{
					processRoot();
				}
				catch (Exception ex)
				{
					System.out.println(ex);
				}

			}
		}.start();
	}
}
