/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber;

import java.util.*;

import org.apache.log4j.*;
import com.bluedragontavern.albumgrabber.gui.*;

public class ImageChooserMgr
	extends Thread
{
	private static Logger logger = Logger.getLogger(ImageChooserMgr.class);

	private static ImageChooserMgr instance = null;
	private List items = new ArrayList();
	private boolean displayingChooser = false;
	private ImageChooser imageChooser;

	/**
	 * Get singleton instance
	 *
	 * @return singleton instance
	 */
	public static synchronized ImageChooserMgr getInstance()
	{
		if (instance == null)
		{
			instance = new ImageChooserMgr();
		}

		return instance;
	}

	/**
	 * Private Singleton Constructor
	 */
	private ImageChooserMgr()
	{
		imageChooser = new ImageChooser();

		start();
	}

	/**
	 * Add chooser to the queue
	 *
	 * @param album Album to add
	 */
	public void addItem(ItemToGrab item)
	{
		ExitProgram.setImageChooserMgrFinished(false);
		items.add(item);
	}

	/**
	 * Run image manager
	 */
	public void run()
	{
		try
		{
			while (ExitProgram.isFinished() == false)
			{
				if (displayingChooser == false && items.size() > 0)
				{
					ItemToGrab item = (ItemToGrab) items.remove(0);
					imageChooser.displayItem(item);
					setDisplayingChooser(true);
				}
				else
				{
					//logger.debug("Sleeping...");
					Thread.sleep(250);

					//If there are no more items and not displaying chooser, then finished
					if (items.size() == 0 && displayingChooser == false)
					{
						ExitProgram.setImageChooserMgrFinished(true);
					}
				}
			}
		}
		catch (Exception ex)
		{
			System.out.println("Exception: " + ex);
		}
	}

	/**
	 * DOCUMENT ME!
	 *
	 * @param flag DOCUMENT ME!
	 */
	public void setDisplayingChooser(boolean flag)
	{
		displayingChooser = flag;
	}
}
