/**
  Album Cover Grabber - Grabs album covers automatically off the internet
  Copyright (C) 2002  Kevin M Schmidt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package com.bluedragontavern.albumgrabber.gui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;

import com.bluedragontavern.albumgrabber.google.*;

/**
 * A panel which contains a thumbnail image, size of original description,
 * and a selection checkbox
 */
public class ThumbnailPanel
	extends JPanel implements MouseListener
{
	private Thumbnail thumbnail = null;
	private boolean selected = false;

	/**
	 * Constructor
	 */
	public ThumbnailPanel(Thumbnail thumbnail)
		throws Exception
	{
		this.thumbnail = thumbnail;

		Box box = Box.createVerticalBox();
		Image image = Toolkit.getDefaultToolkit().createImage(
			thumbnail.getThumbnailBytes());
		ImagePanel ip = new ImagePanel(image);
		box.add(ip);
		box.add(new JLabel(thumbnail.getSizeDescription()));

		//Add the box to the panel
		add(box);

		//Add mouse listener
		addMouseListener(this);
	}

	/**
	 * Check if selected or not
	 */
	public boolean isSelected()
	{
		return selected;
	}

	/**
	 * Return the thumbnail for this panel
	 */
	public Thumbnail getThumbnail()
	{
		return thumbnail;
	}

	/**
	 * Invoked when the mouse has been clicked on a component.
	 */
	public void mouseClicked(MouseEvent e)
	{
		//Flip the flag
		selected = !selected;

		//Set the border properly
		if (selected)
		{
			setBorder(BorderFactory.createEtchedBorder(EtchedBorder.LOWERED));
		}
		else
		{
			setBorder(null);
		}
	}

	/**
	 * Invoked when the mouse enters a component.
	 */
	public void mouseEntered(MouseEvent e)
	{
	}

	/**
	 * Invoked when the mouse exits a component.
	 */
	public void mouseExited(MouseEvent e)
	{
	}

	/**
	 * Invoked when a mouse button has been pressed on a component.
	 */
	public void mousePressed(MouseEvent e)
	{
	}

	/**
	 * Invoked when a mouse button has been released on a component.
	 */
	public void mouseReleased(MouseEvent e)
	{
	}
}
