package dks.src.test.gradientEditor;

import java.awt.Color;

import junit.framework.TestCase;

import org.jdom.Element;
import org.jdom.JDOMException;

import dks.src.gradientEditor.CGradientColor;

public class TestCGradientColor extends TestCase {

	private static final Color ORIG_COLOR = new Color(1, 2, 3, 4);
	private static final Color TEST_COLOR = new Color(8, 7, 6, 5);
	
	private static final int ORIG_POSITION = 1;
	private static final int TEST_POSITION = 2;
	
	public void testCGradientColorColorInt() {
		CGradientColor color = new CGradientColor(ORIG_COLOR, ORIG_POSITION);
		assertNotNull("Le constructeur n'a pas construit l'objet", color);
		assertEquals("Le constructeur n'a pas initialiser la couleur", color.getColor(), ORIG_COLOR);
		assertEquals("Le constructeur n'a pas initialiser la position", color.getPosition(), ORIG_POSITION);		
	}

	public void testSetColor() {
		CGradientColor color = new CGradientColor(ORIG_COLOR, ORIG_POSITION);
		color.setColor(TEST_COLOR);
		assertEquals("La modification de la couleur n'est pas effective", color.getColor(), TEST_COLOR);
	}

	public void testSetPosition() {
		CGradientColor color = new CGradientColor(ORIG_COLOR, ORIG_POSITION);
		color.setPosition(TEST_POSITION);
		assertEquals("La modification de la position n'est pas effective", color.getPosition(), TEST_POSITION);
	}

	public void testXMLload() {
		CGradientColor color = new CGradientColor(ORIG_COLOR, ORIG_POSITION);
		Element root = new Element("parent");
		color.XMLsave(root);
		CGradientColor test = new CGradientColor(TEST_COLOR, TEST_POSITION);
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas modifi la couleur", test.getColor(), ORIG_COLOR);
		assertEquals("Le chargement par XML n'a pas modifi la position", test.getPosition(), ORIG_POSITION);
	}

}
