package dks.src.test.shadow;

import java.awt.Color;
import java.awt.image.BufferedImage;

import junit.framework.TestCase;

import org.jdom.Element;
import org.jdom.JDOMException;

import dks.src.shadowEditor.CShadow;

public class TestCShadow extends TestCase {
	
	private static final BufferedImage ORIG_IMAGE = new BufferedImage(300, 400, BufferedImage.TYPE_4BYTE_ABGR);
	private static final BufferedImage TEST_IMAGE = new BufferedImage(500, 600, BufferedImage.TYPE_4BYTE_ABGR);
	
	private static final Color ORIG_COLOR = new Color(1, 2, 3, 4);
	private static final Color TEST_COLOR = new Color(5, 6, 7, 8);
	
	private static final float ORIG_OPACITY = 0.3f;
	private static final float TEST_OPACITY = 0.4f;
	
	private static final int ORIG_ANGLE = 1;
	private static final int TEST_ANGLE = 2;
	
	private static final int ORIG_SIZE = 3;
	private static final int TEST_SIZE = 4;
	
	private static final int ORIG_DISTANCE = 5;
	private static final int TEST_DISTANCE = 6;
	
	private static final boolean TEST_VISIBLE = false;
		
	public void testCShadowBufferedImageColorFloatIntIntInt() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		assertNotNull("Le constructeur n'a pas cre l'objet", shadow);
		assertEquals("Le constructeur n'a pas initialis l'image", shadow.getImage(), ORIG_IMAGE);
		assertEquals("Le constructeur n'a pas initialis la couleur", shadow.getColor(), ORIG_COLOR);
		assertEquals("Le constructeur n'a pas initialis l'opacit", shadow.getOpacity(), ORIG_OPACITY);
		assertEquals("Le constructeur n'a pas initialis l'angle", shadow.getAngle(), ORIG_ANGLE);
		assertEquals("Le constructeur n'a pas initialis la taille", shadow.getSize(), ORIG_SIZE);
		assertEquals("Le constructeur n'a pas initialis la distance", shadow.getDistance(), ORIG_DISTANCE);
	}

	public void testCShadowBufferedImageColorFloatIntInt() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE);
		assertNotNull("Le constructeur n'a pas cre l'objet", shadow);
		assertEquals("Le constructeur n'a pas initialis l'image", shadow.getImage(), ORIG_IMAGE);
		assertEquals("Le constructeur n'a pas initialis la couleur", shadow.getColor(), ORIG_COLOR);
		assertEquals("Le constructeur n'a pas initialis l'opacit", shadow.getOpacity(), ORIG_OPACITY);
		assertEquals("Le constructeur n'a pas initialis l'angle", shadow.getAngle(), ORIG_ANGLE);
		assertEquals("Le constructeur n'a pas initialis la taille", shadow.getSize(), ORIG_SIZE);
	}

	public void testCShadowBufferedImageColorFloatInt() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE);
		assertNotNull("Le constructeur n'a pas cre l'objet", shadow);
		assertEquals("Le constructeur n'a pas initialis l'image", shadow.getImage(), ORIG_IMAGE);
		assertEquals("Le constructeur n'a pas initialis la couleur", shadow.getColor(), ORIG_COLOR);
		assertEquals("Le constructeur n'a pas initialis l'opacit", shadow.getOpacity(), ORIG_OPACITY);
		assertEquals("Le constructeur n'a pas initialis l'angle", shadow.getAngle(), ORIG_ANGLE);
	}

	public void testCShadowBufferedImageColorFloat() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		assertNotNull("Le constructeur n'a pas cre l'objet", shadow);
		assertEquals("Le constructeur n'a pas initialis l'image", shadow.getImage(), ORIG_IMAGE);
		assertEquals("Le constructeur n'a pas initialis la couleur", shadow.getColor(), ORIG_COLOR);
		assertEquals("Le constructeur n'a pas initialis l'opacit", shadow.getOpacity(), ORIG_OPACITY);
	}

	public void testCShadowBufferedImageColor() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR);
		assertNotNull("Le constructeur n'a pas cre l'objet", shadow);
		assertEquals("Le constructeur n'a pas initialis l'image", shadow.getImage(), ORIG_IMAGE);
		assertEquals("Le constructeur n'a pas initialis la couleur", shadow.getColor(), ORIG_COLOR);
	}

	public void testCShadowBufferedImage() {
		CShadow shadow = new CShadow(ORIG_IMAGE);
		assertNotNull("Le constructeur n'a pas cre l'objet", shadow);
		assertEquals("Le constructeur n'a pas initialis l'image", shadow.getImage(), ORIG_IMAGE);
	}

	public void testCShadow() {
		CShadow shadow = new CShadow();
		assertNotNull("Le constructeur n'a pas cre l'objet", shadow);
	}

	public void testSetAngle() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		shadow.setAngle(TEST_ANGLE);
		assertEquals("La modification de l'angle n'est pas effective", shadow.getAngle(), TEST_ANGLE);
	}

	public void testSetColor() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		shadow.setColor(TEST_COLOR);
		assertEquals("La modification de la couleur n'est pas effective", shadow.getColor(), TEST_COLOR);
	}

	public void testSetDistance() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		shadow.setDistance(TEST_DISTANCE);
		assertEquals("La modification de la distance n'est pas effective", shadow.getDistance(), TEST_DISTANCE);
	}

	public void testSetImage() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		shadow.setImage(TEST_IMAGE);
		assertEquals("La modification de l'image n'est pas effective", shadow.getImage(), TEST_IMAGE);
	}

	public void testSetOpacity() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		shadow.setOpacity(TEST_OPACITY);
		assertEquals("La modification de l'opacit n'est pas effective", shadow.getOpacity(), TEST_OPACITY);
	}

	public void testSetSize() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		shadow.setSize(TEST_SIZE);
		assertEquals("La modification de la taille n'est pas effective", shadow.getSize(), TEST_SIZE);
	}

	public void testSetVisible() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		shadow.setVisible(TEST_VISIBLE);
		assertEquals("La modification de la visibilit n'est pas effective", shadow.isVisible(), TEST_VISIBLE);
	}
	
	public void testXMLload() {
		CShadow shadow = new CShadow(ORIG_IMAGE, ORIG_COLOR, ORIG_OPACITY, ORIG_ANGLE, ORIG_SIZE, ORIG_DISTANCE);
		shadow.setVisible(TEST_VISIBLE);
		Element root = new Element("parent");
		shadow.XMLsave(root);
		CShadow test = new CShadow(TEST_IMAGE, TEST_COLOR, TEST_OPACITY, TEST_ANGLE, TEST_SIZE, TEST_DISTANCE);
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas initialis la couleur", test.getColor(), ORIG_COLOR);
		assertEquals("Le chargement par XML n'a pas initialis l'opacit", test.getOpacity(), ORIG_OPACITY);
		assertEquals("Le chargement par XML n'a pas initialis l'angle", test.getAngle(), ORIG_ANGLE);
		assertEquals("Le chargement par XML n'a pas initialis la taille", test.getSize(), ORIG_SIZE);
		assertEquals("Le chargement par XML n'a pas initialis la distance", test.getDistance(), ORIG_DISTANCE);
		assertEquals("Le chargement par XML n'a pas initialis la visibilit", test.isVisible(), TEST_VISIBLE);
	}

}
