package dks.src.test.texture;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.awt.Color;
import java.awt.image.BufferedImage;

import org.jdom.Element;
import org.jdom.JDOMException;

import dks.src.textureEditor.CLayer;
import dks.src.textureEditor.CTexture;

/**
 * @author   DKS
 */
public class TestCTexture {

	private final CLayer ORIG_BACKGROUND_LAYER = new CLayer(new Color(1, 2, 3, 4));
	private final CLayer TEST_BACKGROUND_LAYER = new CLayer(new BufferedImage(300, 400, BufferedImage.TYPE_3BYTE_BGR));

	private final CLayer ORIG_FOREGROUND_LAYER = new CLayer(new Color(10, 20, 30, 40));
	private final CLayer TEST_FOREGROUND_LAYER = new CLayer(new BufferedImage(30, 40, BufferedImage.TYPE_3BYTE_BGR));

	private static final int ORIG_WIDTH = 100;
	private static final int TEST_WIDTH = 200;
	
	private static final int ORIG_HEIGHT = 150;
	private static final int TEST_HEIGHT = 250;
	
	private final BufferedImage ORIG_TEXTURE = new BufferedImage(300, 250, BufferedImage.TYPE_3BYTE_BGR);
	private final BufferedImage TEST_TEXTURE = new BufferedImage(100, 550, BufferedImage.TYPE_3BYTE_BGR);
	
	private final BufferedImage ORIG_MASK = new BufferedImage(210, 510, BufferedImage.TYPE_3BYTE_BGR);
	private final BufferedImage TEST_MASK = new BufferedImage(110, 410, BufferedImage.TYPE_3BYTE_BGR);
	
	private static final String TEST_MASK_FILENAME = "maskFilename";
	
	private static final String TEST_TEXTURE_FILENAME = "textureFilename";
		
	public void testCTexture() {
		CTexture texture = new CTexture();
		assertNotNull("Le constructeur n'a pas construit l'objet", texture);
	}

	public void testCTextureCLayerCLayerIntegerIntegerBufferedImageBufferedImage() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		assertNotNull("Le constructeur n'a pas construit l'objet", texture);
		assertEquals("Le constructeur n'a pas initialise la couche de fond", texture.getBackgroundLayer(), ORIG_BACKGROUND_LAYER);
		assertEquals("Le constructeur n'a pas initialise la couche d'avant plan", texture.getForegroundLayer(), ORIG_FOREGROUND_LAYER);
		assertEquals("Le constructeur n'a pas initialise la largeur", texture.getWidth(), ORIG_WIDTH);
		assertEquals("Le constructeur n'a pas initialise la hauteur", texture.getHeight(), ORIG_HEIGHT);
		assertEquals("Le constructeur n'a pas initialise la texture", texture.getTexture(), ORIG_TEXTURE);
		assertEquals("Le constructeur n'a pas initialise le masque", texture.getMask(), ORIG_MASK);
	}

	public void testSetBackgroundLayer() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		texture.setBackgroundLayer(TEST_BACKGROUND_LAYER);
		assertEquals("La modification de la couche d'arrire plan n'est pas effective", texture.getBackgroundLayer(), TEST_BACKGROUND_LAYER);
	}

	public void testSetForegroundLayer() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		texture.setForegroundLayer(TEST_FOREGROUND_LAYER);
		assertEquals("La modification de la couche d'avant plan n'est pas effective", texture.getForegroundLayer(), TEST_FOREGROUND_LAYER);
	}

	public void testSetMask() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		texture.setMask(TEST_MASK);
		assertEquals("La modification du masque n'est pas effective", texture.getMask(), TEST_MASK);
	}

	public void testSetTexture() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		texture.setTexture(TEST_TEXTURE);
		assertEquals("La modification de la texture n'est pas effective", texture.getTexture(), TEST_TEXTURE);
	}
	
	public void testSetMaskFileName() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		texture.setMaskFileName(TEST_MASK_FILENAME);
		assertEquals("La modification du nom de fichier du masque n'est pas effective", texture.getMaskFileName(), TEST_MASK_FILENAME);
	}

	public void testSetTextureFileName() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		texture.setTextureFileName(TEST_TEXTURE_FILENAME);
		assertEquals("La modification du nom de fichier de la texture n'est pas effective", texture.getTextureFileName(), TEST_TEXTURE_FILENAME);
	}

	public void testSetHeight() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		texture.setHeight(TEST_HEIGHT);
		assertEquals("La modification de la hauteur n'est pas effective", texture.getHeight(), TEST_HEIGHT);
	}

	public void testSetWidth() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		texture.setWidth(TEST_WIDTH);
		assertEquals("La modification de la largeur n'est pas effective", texture.getWidth(), TEST_WIDTH);	}

	public void testXMLload() {
		CTexture texture = new CTexture(ORIG_BACKGROUND_LAYER, ORIG_FOREGROUND_LAYER, ORIG_WIDTH, ORIG_HEIGHT, ORIG_TEXTURE, ORIG_MASK);
		Element root = new Element("parent");
		texture.XMLsave(root);
		CTexture test = new CTexture(TEST_BACKGROUND_LAYER, TEST_FOREGROUND_LAYER, TEST_WIDTH, TEST_HEIGHT, TEST_TEXTURE, TEST_MASK);
		try {
			test.XMLload(root);
		} catch (JDOMException e) {
			e.printStackTrace();
		}
		assertEquals("Le chargement par XML n'a pas modifi la couche de fond", test.getBackgroundLayer(), ORIG_BACKGROUND_LAYER);
		assertEquals("Le chargement par XML n'a pas modifi la couche d'avant plan", test.getForegroundLayer(), ORIG_FOREGROUND_LAYER);
		assertEquals("Le chargement par XML n'a pas modifi la largeur", test.getWidth(), ORIG_WIDTH);
		assertEquals("Le chargement par XML n'a pas modifi la hauteur", test.getHeight(), ORIG_HEIGHT);
		assertEquals("Le chargement par XML n'a pas modifi la texture", test.getTexture(), ORIG_TEXTURE);
		assertEquals("Le chargement par XML n'a pas modifi le masque", test.getMask(), ORIG_MASK);
	
	}

}
