package dks.src.test.warp;

import junit.framework.TestCase;

import org.jdom.Element;

import dks.src.warpEditor.CPoint;

public class TestCPoint extends TestCase {

	private static final int ORIG_TRANSFORMATION_X = 1;
	private static final int TEST_TRANSFORMATION_X = 2;
	
	private static final int ORIG_TRANSFORMATION_Y = 3;
	private static final int TEST_TRANSFORMATION_Y = 4;
	
	public void testCPoint() {	
		CPoint point = new CPoint();
		assertNotNull("Le constructeur n'a pas construit l'objet", point);
	}

	public void testSetTransformationX() {
		CPoint point = new CPoint();
		point.setTransformationX(ORIG_TRANSFORMATION_X);
		assertEquals("La modification de la transformation sur X n'est pas effective", point.getTransformationX(), ORIG_TRANSFORMATION_X);
	}

	public void testSetTransformationY() {
		CPoint point = new CPoint();
		point.setTransformationY(ORIG_TRANSFORMATION_Y);
		assertEquals("La modification de la transformation sur Y n'est pas effective", point.getTransformationY(), ORIG_TRANSFORMATION_Y);	}

	public void testXMLload() {
		CPoint point = new CPoint();
		point.setTransformationX(ORIG_TRANSFORMATION_X);
		point.setTransformationY(ORIG_TRANSFORMATION_Y);
		Element root = new Element("parent");
		point.XMLsave(root);
		CPoint test = new CPoint();
		test.setTransformationX(TEST_TRANSFORMATION_X);
		test.setTransformationY(TEST_TRANSFORMATION_Y);
		test.XMLload(root);
		assertEquals("Le chargement par XML n'a pas modific la transformation sur X", test.getTransformationX(), ORIG_TRANSFORMATION_X);
		assertEquals("Le chargement par XML n'a pas modific la transformation sur Y", test.getTransformationY(), ORIG_TRANSFORMATION_Y);
	}

}
