/**
 * @author DarK Sidious
 * @version 1.0.0
 */
package dks.src.utils.listener;

import javax.swing.event.ChangeListener;


/**
 * The interface represent objets which can change and notify their parents
 * <br>
 * date : 2 dc. 07
 * @author DarK Sidious
 */
public interface Changeable {
	/**
	 * Add a ChangeListener which will notify when the object change
	 * @param listener the ChangeListener to add
	 */
	public void addChangeListener(ChangeListener listener);
	
	/**
	 * Remove a ChangeListener
	 * @param listener the ChangeListener to remove
	 */
	public void removeChangeListener(ChangeListener listener);
}
