/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.graph;

import gov.nasa.ltl.graph.Edge;
import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.graph.Node;
import gov.nasa.ltl.graph.SCC;
import java.util.List;

public class SCCReduction {
    public static <PropT> Graph<PropT> reduce(Graph<PropT> g) {
        boolean changed;
        String type = g.getStringAttribute("type");
        String ac = g.getStringAttribute("ac");
        assert (ac.equals("nodes") || ac.equals("edges")) : "invalid accepting type: " + ac;
        assert (type.equals("ba") || type.equals("gba")) : "invalid graph type: " + type;
        for (List<Node<PropT>> l : SCC.scc(g)) {
            SCCReduction.clearExternalEdges(l, g);
        }
        do {
            changed = false;
            List<List<Node<PropT>>> sccs = SCC.scc(g);
            for (List<Node<PropT>> scc : sccs) {
                boolean accepting = SCCReduction.isAccepting(scc, g);
                if (!accepting && SCCReduction.isTerminal(scc)) {
                    changed = true;
                    for (Node<PropT> n : scc) {
                        n.remove();
                    }
                    continue;
                }
                if (!SCCReduction.isTransient(scc) && accepting) continue;
                changed |= SCCReduction.anyAcceptingState(scc, g);
                SCCReduction.clearAccepting(scc, g);
            }
        } while (changed);
        return g;
    }

    private static <PropT> boolean isAccepting(List<Node<PropT>> scc, Graph<PropT> g) {
        boolean gba = g.getStringAttribute("type").equals("gba");
        boolean nac = g.getStringAttribute("ac").equals("nodes");
        int nsets = g.getIntAttribute("nsets");
        if (!gba) {
            for (Node<PropT> n : scc) {
                if (nac) {
                    if (!n.getBooleanAttribute("accepting")) continue;
                    return true;
                }
                for (Edge<PropT> e : n.getOutgoingEdges()) {
                    if (!e.getBooleanAttribute("accepting")) continue;
                    return true;
                }
            }
            return false;
        }
        int j = 0;
        while (j < nsets) {
            boolean found = false;
            block3: for (Node<PropT> n : scc) {
                if (nac) {
                    if (!n.getBooleanAttribute("acc" + j)) continue;
                    found = true;
                    break;
                }
                for (Edge<PropT> e : n.getOutgoingEdges()) {
                    if (!e.getBooleanAttribute("acc" + j)) continue;
                    found = true;
                    break block3;
                }
            }
            if (!found) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private static <PropT> boolean isTerminal(List<Node<PropT>> scc) {
        for (Node<PropT> n : scc) {
            for (Edge<PropT> e : n.getOutgoingEdges()) {
                if (scc.contains(e.getNext())) continue;
                return false;
            }
        }
        return true;
    }

    private static <PropT> boolean isTransient(List<Node<PropT>> scc) {
        if (scc.size() != 1) {
            return false;
        }
        Node<PropT> n = scc.get(0);
        for (Edge<PropT> e : n.getOutgoingEdges()) {
            if (e.getNext() != n) continue;
            return false;
        }
        return true;
    }

    private static <PropT> boolean anyAcceptingState(List<Node<PropT>> scc, Graph<PropT> g) {
        boolean gba = g.getStringAttribute("type").equals("gba");
        boolean nac = g.getStringAttribute("ac").equals("nodes");
        int nsets = g.getIntAttribute("nsets");
        for (Node<PropT> n : scc) {
            if (gba) continue;
            if (nac) {
                if (!n.getBooleanAttribute("accepting")) continue;
                return true;
            }
            for (Edge<PropT> e : n.getOutgoingEdges()) {
                if (e.getBooleanAttribute("accepting")) {
                    return true;
                }
                int k = 0;
                while (k < nsets) {
                    if (nac) {
                        if (n.getBooleanAttribute("acc" + k)) {
                            return true;
                        }
                    } else {
                        for (Edge<PropT> f : n.getOutgoingEdges()) {
                            if (!f.getBooleanAttribute("acc" + k)) continue;
                            return true;
                        }
                    }
                    ++k;
                }
            }
        }
        return false;
    }

    private static <PropT> void clearAccepting(List<Node<PropT>> scc, Graph<PropT> g) {
        boolean gba = g.getStringAttribute("type").equals("gba");
        boolean nac = g.getStringAttribute("ac").equals("nodes");
        int nsets = g.getIntAttribute("nsets");
        if (!gba) {
            if (nac) {
                for (Node<PropT> n : scc) {
                    n.setBooleanAttribute("accepting", false);
                }
            } else {
                for (Node<PropT> n : scc) {
                    for (Edge<PropT> e : n.getOutgoingEdges()) {
                        e.setBooleanAttribute("accepting", false);
                    }
                }
            }
        } else {
            int j = 0;
            while (j < nsets) {
                if (nac) {
                    for (Node<PropT> n : scc) {
                        n.setBooleanAttribute("acc" + j, false);
                    }
                } else {
                    for (Node<PropT> n : scc) {
                        for (Edge<PropT> e : n.getOutgoingEdges()) {
                            e.setBooleanAttribute("acc" + j, false);
                        }
                    }
                }
                ++j;
            }
        }
    }

    private static <PropT> void clearExternalEdges(List<Node<PropT>> scc, Graph<PropT> g) {
        int nsets = g.getIntAttribute("nsets");
        boolean gba = g.getStringAttribute("type").equals("gba");
        boolean nac = g.getStringAttribute("ac").equals("nodes");
        if (nac) {
            return;
        }
        for (Node<PropT> n : scc) {
            for (Edge<PropT> e : n.getOutgoingEdges()) {
                if (scc.contains(e.getNext())) continue;
                if (gba) {
                    int k = 0;
                    while (k < nsets) {
                        e.setBooleanAttribute("acc" + k, false);
                        ++k;
                    }
                    continue;
                }
                e.setBooleanAttribute("accepting", false);
            }
        }
    }
}

