/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.ltl.trans;

import gov.nasa.ltl.graph.Graph;
import gov.nasa.ltl.trans.Automaton;
import gov.nasa.ltl.trans.Formula;
import gov.nasa.ltl.trans.LTLErrorException;
import gov.nasa.ltl.trans.Node;
import gov.nasa.ltl.trans.ParseErrorException;
import gov.nasa.ltl.trans.Parser;
import gov.nasa.ltl.trans.Pool;
import gov.nasa.ltl.trans.State;

public class Translator {
    private static Algorithm algorithm = Algorithm.LTL2BUCHI;

    public static Algorithm getAlgorithm() {
        return algorithm;
    }

    public static void setAlgorithm(Algorithm alg) {
        algorithm = alg;
    }

    public static Graph<String> translate(String formula) {
        try {
            Formula<String> ltl = Parser.parse(formula);
            return Translator.translate(ltl);
        }
        catch (ParseErrorException e) {
            throw new LTLErrorException("parse error: " + e.getMessage());
        }
    }

    public static <PropT> Graph<PropT> translate(Formula<PropT> formula) {
        Pool pool = new Pool();
        Node init = Node.createInitial(formula, pool);
        Automaton<PropT> a = new Automaton<PropT>(pool);
        State<PropT>[] states = init.expand(a).structForRuntAnalysis();
        return a.SMoutput(states);
    }

    public static enum Algorithm {
        LTL2AUT,
        LTL2BUCHI;

    }
}

