/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.helpers;

import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.MaskFormatter;

public class LocalDateEditor
extends JFormattedTextField {
    private JSpinner theSpinner;
    private SimpleDateFormat theDateFormat;
    private String format = "dd:MM:yyyy";
    private String mask = "##:##:#### a";

    public LocalDateEditor(JSpinner spinner) {
        super(LocalDateEditor.createFormatter());
        this.setEditable(true);
        this.theDateFormat = new SimpleDateFormat(this.getFormat());
        this.theSpinner = spinner;
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("value")) {
                    LocalDateEditor.this.textFieldToSpinner();
                }
            }
        });
        this.theSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                LocalDateEditor.this.spinnerToTextField();
            }
        });
        this.spinnerToTextField();
    }

    private static JFormattedTextField.AbstractFormatter createFormatter() {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter("##:##:#### UU");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        formatter.setValidCharacters("0123456789ampAMP");
        return formatter;
    }

    private void textFieldToSpinner() {
        try {
            this.theSpinner.setValue(this.theDateFormat.parse(this.getText()));
        }
        catch (IllegalArgumentException iae) {
            this.revertToNow();
        }
        catch (ParseException pe) {
            this.revertToNow();
        }
    }

    private void spinnerToTextField() {
        this.setValue(this.theDateFormat.format(this.theSpinner.getValue()));
    }

    private void revertToNow() {
        try {
            this.setValue(this.theDateFormat.format(new Date()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void setFormat(String format) {
        this.format = format;
    }

    protected void processFocusEvent(FocusEvent e) {
        if (e.getID() == 1005 && e.getSource().equals(this)) {
            this.textFieldToSpinner();
        } else {
            super.processFocusEvent(e);
        }
    }

    public String getFormat() {
        return this.format;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getMask() {
        return this.mask;
    }
}

