/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.RepaintManager;
import javax.swing.text.View;

public class PrintableTextArea
extends JTextArea
implements Printable {
    private MediaSizeName defaultSize = MediaSizeName.ISO_A4;
    private MediaPrintableArea defaultPrintableArea = new MediaPrintableArea(15.0f, 15.0f, 187.0f, 267.0f, 1000);
    private double pageEndY = 0.0;
    private double pageStartY = 0.0;
    private int currentPage = -1;
    public boolean printUsingViews = false;

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (this.printUsingViews) {
            return this.printUsingViews(graphics, pageFormat, pageIndex);
        }
        return this.simplePrint(graphics, pageFormat, pageIndex);
    }

    public int simplePrint(Graphics g, PageFormat pf, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        RepaintManager.currentManager(this).setDoubleBufferingEnabled(false);
        Dimension d = this.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pf.getImageableHeight();
        double pageWidth = pf.getImageableWidth();
        double scale = pageWidth / panelWidth;
        int totalNumPages = (int)Math.ceil(scale * panelHeight / pageHeight);
        if (pageIndex >= totalNumPages) {
            return 1;
        }
        g2.translate(pf.getImageableX(), pf.getImageableY());
        g2.translate(0.0, (double)(-pageIndex) * pageHeight);
        g2.scale(scale, scale);
        this.paint(g2);
        return 0;
    }

    public int printUsingViews(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Dimension d = this.getSize();
        double panelWidth = d.width;
        double panelHeight = d.height;
        double pageHeight = pageFormat.getImageableHeight();
        double pageWidth = pageFormat.getImageableWidth();
        double scale = pageWidth / panelWidth;
        Graphics2D g2 = (Graphics2D)graphics;
        View rootView = this.getUI().getRootView(this);
        g2.scale(scale, scale);
        g2.setClip((int)(pageFormat.getImageableX() / scale), (int)(pageFormat.getImageableY() / scale), (int)(pageFormat.getImageableWidth() / scale), (int)(pageFormat.getImageableHeight() / scale));
        if (pageIndex > this.currentPage) {
            this.currentPage = pageIndex;
            this.pageStartY += this.pageEndY;
            this.pageEndY = g2.getClipBounds().getHeight();
        }
        g2.translate(g2.getClipBounds().getX(), g2.getClipBounds().getY());
        Rectangle allocationToPrint = new Rectangle(0, (int)(-this.pageStartY), (int)this.getMinimumSize().getWidth(), (int)this.getPreferredSize().getHeight());
        if (this.printView(g2, allocationToPrint, rootView)) {
            return 0;
        }
        this.pageStartY = 0.0;
        this.pageEndY = 0.0;
        this.currentPage = -1;
        return 1;
    }

    protected boolean printView(Graphics2D graphics2D, Shape allocationToPrint, View view) {
        boolean pageExists = false;
        Rectangle clipRectangle = graphics2D.getClipBounds();
        if (view.getViewCount() > 0 && !view.getClass().getName().equals("javax.swing.text.html.TableView$CellView")) {
            for (int i = 0; i < view.getViewCount(); ++i) {
                View childView;
                Shape childAllocation = view.getChildAllocation(i, allocationToPrint);
                if (childAllocation == null || !this.printView(graphics2D, childAllocation, childView = view.getView(i))) continue;
                pageExists = true;
            }
        } else {
            double allocBoundsHeight = allocationToPrint.getBounds().getHeight();
            double allocBoundsY = allocationToPrint.getBounds().getY();
            double allocBoundsMaxY = allocationToPrint.getBounds().getMaxY();
            double clipY = clipRectangle.getY();
            double clipMaxY = clipRectangle.getMaxY();
            double clipHeight = clipRectangle.getHeight();
            boolean allocIntersectsClip = allocationToPrint.intersects(clipRectangle);
            if (allocBoundsMaxY > clipY) {
                pageExists = true;
                if (allocBoundsHeight > clipHeight && allocIntersectsClip) {
                    view.paint(graphics2D, allocationToPrint);
                } else if (allocBoundsY >= clipY) {
                    if (allocBoundsMaxY <= clipMaxY) {
                        if (allocBoundsY <= this.pageEndY) {
                            view.paint(graphics2D, allocationToPrint);
                        }
                    } else if (allocBoundsY < this.pageEndY) {
                        this.pageEndY = allocationToPrint.getBounds().getY();
                    }
                }
            } else if (allocBoundsMaxY == clipY) {
                // empty if block
            }
        }
        return pageExists;
    }

    public void printWithoutDialog() {
        this.printWithoutDialog("Java Printing", 1);
    }

    public void printWithoutDialog(int copiesQuantity) {
        this.printWithoutDialog("Java Printing", copiesQuantity);
    }

    public void printWithoutDialog(String jobName, int copiesQuantity) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(new Copies(copiesQuantity));
        aset.add(this.defaultSize);
        aset.add(this.defaultPrintableArea);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setJobName(jobName);
        job.setPrintable(this);
        try {
            job.print(aset);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public boolean showPrintDialog() {
        return this.showPrintDialog("Java Printing");
    }

    public boolean showPrintDialog(String jobName) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(this.defaultSize);
        aset.add(this.defaultPrintableArea);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this);
        job.setJobName(jobName);
        if (job.printDialog(aset)) {
            try {
                job.print(aset);
                this.setCursor(Cursor.getDefaultCursor());
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
        return false;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("PrintableTextArea");
        JScrollPane scroll = new JScrollPane();
        frame.getContentPane().setLayout(new BorderLayout());
        final PrintableTextArea pane = new PrintableTextArea();
        scroll.getViewport().add((Component)pane, null);
        frame.getContentPane().add((Component)scroll, "Center");
        frame.getContentPane().add((Component)new JButton(new AbstractAction("PRINT"){

            public void actionPerformed(ActionEvent e) {
                pane.showPrintDialog();
            }
        }), "South");
        frame.setSize(600, 450);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }
}

