/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui;

import com.jaxfront.swing.ui.PrintableTextArea;
import com.jaxfront.swing.ui.SimplePrintableArea;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class Printer {
    private MediaSizeName defaultSize = MediaSizeName.ISO_A4;
    private MediaPrintableArea defaultPrintableArea = new MediaPrintableArea(15.0f, 15.0f, 187.0f, 267.0f, 1000);
    private JComponent _printComponent = null;

    public Printer(JComponent aComponentToPrint) {
        this._printComponent = aComponentToPrint;
    }

    public static void print(JComponent component) {
        new Printer(component).showPrintDialog();
    }

    private boolean showPrintDialog() {
        return this.showPrintDialog("Java Printing");
    }

    private boolean showPrintDialog(String jobName) {
        HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
        aset.add(this.defaultSize);
        aset.add(this.defaultPrintableArea);
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(this.createPrintableFor(this.getPrintComponent()));
        job.setJobName(jobName);
        if (job.printDialog(aset)) {
            try {
                job.print(aset);
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("PrintableTextArea");
        JScrollPane scroll = new JScrollPane();
        frame.getContentPane().setLayout(new BorderLayout());
        final PrintableTextArea pane = new PrintableTextArea();
        scroll.getViewport().add((Component)pane, null);
        frame.getContentPane().add((Component)scroll, "Center");
        frame.getContentPane().add((Component)new JButton(new AbstractAction("PRINT"){

            public void actionPerformed(ActionEvent e) {
                pane.showPrintDialog();
            }
        }), "South");
        frame.setSize(600, 450);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private JComponent getPrintComponent() {
        return this._printComponent;
    }

    private Printable createPrintableFor(JComponent aComponentToPrint) {
        SimplePrintableArea printarea = new SimplePrintableArea(aComponentToPrint);
        return printarea;
    }
}

