/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.swing.ui.visualizers.AbstractView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class AbstractBean
extends AbstractView
implements FocusListener {
    private JButton _editButton = null;

    public AbstractBean() {
    }

    public AbstractBean(Type aType) {
        this.setModel(aType);
    }

    protected void defaultBuild() {
        this.initLayout();
    }

    protected double getDefaultComponentHeight() {
        if (this.getModel().getXUIDefinition().getStyle().isUsingPlugIn()) {
            return 0.0;
        }
        return super.getDefaultComponentHeight();
    }

    protected float getLabelColumnWidth() {
        return this.getModel().getXUIDefinition().getStyle().getLabelColumnWidth();
    }

    protected float getComponentColumnWidth() {
        return this.getModel().getXUIDefinition().getStyle().getComponentColumnWidth();
    }

    public void markError() {
        if (this.getDOM().isEditable()) {
            this._originalBorder = this._editorComponent.getBorder();
            Border border = BorderFactory.createEtchedBorder(this.getModel().getDOM().getErrorMarkingColor(), Color.lightGray);
            this._editorComponent.setBorder(border);
        }
    }

    protected void initLayout() {
    }

    public void unProcessView() {
    }

    public abstract void populateModel();

    public abstract void populateView();

    public void resetError() {
        this._editorComponent.setBorder(this._originalBorder);
    }

    public void setLabelColor(Color color) {
        if (this._label != null) {
            this._label.setForeground(color);
        }
    }

    JButton getEditButton() {
        if (this._editButton == null) {
            this._editButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_select", "Select"));
            this._editButton.setPreferredSize(new Dimension((int)this._editButton.getPreferredSize().getWidth(), (int)this.getDefaultComponentHeight()));
        }
        return this._editButton;
    }

    public void setRequired(boolean required) {
        if (required) {
            if (this.getModel().getXUIDefinition().getStyle().isApplicationRequired()) {
                this._editorComponent.setBackground(this.getModel().getDOM().getApplicationFieldColor());
            } else {
                this._editorComponent.setBackground(this.getModel().getDOM().getSchemaRequiredFieldColor());
            }
        } else {
            this._editorComponent.setBackground(this.getModel().getDOM().getOptionalFieldColor());
        }
    }

    public void setApplicationRequired(boolean required) {
        this.getModel().getXUIDefinition().getStyle().setApplicationRequired(required);
        this.setRequired(required);
    }

    public void showLabel(boolean show) {
        if (this.getLabelPanel() != null) {
            this.getLabelPanel().setVisible(show);
        }
    }

    public void setForeground(Color color) {
        if (this._editorComponent != null) {
            this._editorComponent.setForeground(color);
        }
    }

    public void release() {
        super.release();
        this._editButton = null;
    }

    public void itemStateChanged(ItemEvent event) {
    }

    protected abstract JComponent createEditorComponent();

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.getSource() == this._editorComponent && !e.isTemporary()) {
            this.populateModel();
        }
    }

    public void setChoosenKeyValue(String xpathRelativeToChoosenKey, String newValue) {
    }

    public void setChoosenKeyContextValue(String xpathRelativeToChoosenKeyContext, String newValue) {
    }
}

