/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.util.TextTools;
import com.jaxfront.core.util.io.FileSelector;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileDialog
extends AbstractSimpleTypeView {
    private boolean _asURL = true;
    protected boolean _acceptsDirectories = false;
    private FileSelector _fileSelector = null;
    private String _suffix;
    private String _suffixDescription;
    private File _currentDirectory;
    protected JButton _selectFileButton = null;
    private JTextField _fileTextField = null;

    public FileDialog() {
    }

    public FileDialog(SimpleType simpleType) {
        this.setModel((Type)simpleType);
    }

    public FileDialog(String currentDirectoryPath) {
        File directory = new File(currentDirectoryPath);
        if (directory.exists()) {
            this._currentDirectory = directory;
        }
    }

    public FileDialog(boolean asURL) {
        this._asURL = asURL;
    }

    public FileDialog(Boolean asURL) {
        this._asURL = asURL;
    }

    public FileDialog(Boolean asURL, String suffix, String suffixDescription, boolean acceptsDirectories) {
        this._suffix = suffix;
        this._suffixDescription = suffixDescription;
        this._acceptsDirectories = acceptsDirectories;
        this._asURL = asURL;
    }

    protected JComponent createEditorComponent() {
        JPanel editorPanel = new JPanel(new BorderLayout());
        this.setFirstFocusableComponent(this.getFileTextField());
        this._selectFileButton = new JButton(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "button_select", "Select"));
        this._selectFileButton.setPreferredSize(new Dimension((int)this._selectFileButton.getPreferredSize().getWidth(), (int)this.getDefaultComponentHeight()));
        editorPanel.add((Component)this.getFileTextField(), "Center");
        editorPanel.add((Component)this._selectFileButton, "East");
        this._editorComponent = editorPanel;
        this.setEditorField(this.getFileTextField());
        return this._editorComponent;
    }

    protected void defaultBuild() {
        int cmode = 2;
        if (!this._acceptsDirectories) {
            cmode = 0;
        }
        FileSelector fileSelector = new FileSelector(GUIComponentNLS.getInstance().getNLSText(this.getDOM(), "dialog_fileselection", "File Selection"), cmode);
        if (this._suffix != null && !this._suffix.equals("")) {
            fileSelector.setCurrentFileFilter(this._suffix, this._suffixDescription, this._acceptsDirectories);
        }
        this.setFileSelector(fileSelector);
        super.defaultBuild();
        this.initActions();
    }

    public void addFileFilter(String suffix, String description, boolean allowDirectories) {
        if (this.getFileSelector() != null) {
            this.getFileSelector().addFileFilter(suffix, description, allowDirectories);
        }
    }

    public void populateModel() {
        String newValue;
        String oldModelValue = this.getValue();
        if (oldModelValue == null) {
            oldModelValue = "";
        }
        if ((newValue = this.getText()) == null || !oldModelValue.equals(newValue)) {
            this.setValue(newValue);
        }
    }

    public void populateView() {
        File directory;
        String value = this.getValue();
        if (value == null) {
            value = "";
        }
        this.setText(value);
        if (!value.equals("") && (directory = new File(this.getValue())).exists()) {
            this.setCurrentDirectory(directory);
        }
    }

    private void setText(String value) {
        if (value != null) {
            this.getFileTextField().setText(value);
        }
    }

    private void setValue(String value) {
        ((SimpleType)this.getModel()).setValue(value);
    }

    private void showDialog() {
        if (this.getCurrentDirectory() != null) {
            this.getFileSelector().setRootDir(this.getCurrentDirectory());
        }
        this.getFileSelector().showOpenDialog((Component)this.getModel().getDOM().getEditor().getWindow());
        if (this.getFileSelector().getSelectedFile() != null && this.getFileSelector().hasSelectionChanged()) {
            String currentValue = null;
            try {
                if (this._asURL) {
                    currentValue = this.getFileSelector().getSelectedFile().toString();
                    currentValue = TextTools.replace((String)currentValue, (String)"\\", (String)"/");
                    currentValue = "file:/" + currentValue;
                } else {
                    currentValue = this.getFileSelector().getSelectedFile().toURL().toString();
                }
            }
            catch (MalformedURLException ex) {
                currentValue = "Wrong URL Format";
            }
            this.setValue(currentValue);
            this.populateView();
        }
    }

    public void initActions() {
        this._selectFileButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(GUIComponentNLS.getInstance().getNLSText(FileDialog.this.getDOM(), "button_select", "Select"))) {
                    FileDialog.this.populateModel();
                    FileDialog.this.showDialog();
                }
            }
        });
    }

    private void setFileSelector(FileSelector _fileSelector) {
        this._fileSelector = _fileSelector;
    }

    private FileSelector getFileSelector() {
        return this._fileSelector;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getEditorField() != null) {
            this.getEditorField().setEnabled(enabled);
        }
        if (this._selectFileButton != null) {
            this._selectFileButton.setEnabled(enabled);
        }
    }

    public String getText() {
        if (this.getFileTextField() != null) {
            return this.getFileTextField().getText();
        }
        return null;
    }

    private String getValue() {
        if (this.getModel() != null) {
            return ((SimpleType)this.getModel()).getValue();
        }
        return null;
    }

    private File getCurrentDirectory() {
        if (this._currentDirectory == null) {
            URL lastDirectory;
            File file;
            File file2;
            if (this.getValue() != null && (file2 = new File(this.getValue())).exists()) {
                this.setCurrentDirectory(file2);
            }
            if (this._currentDirectory == null && (file = new File((lastDirectory = JAXFrontProperties.getInstance().getLastOpenedFolder()).getFile())).exists()) {
                this.setCurrentDirectory(file);
            }
        }
        return this._currentDirectory;
    }

    private void setCurrentDirectory(File newDirectory) {
        this._currentDirectory = newDirectory;
        try {
            JAXFrontProperties.getInstance().setLastOpenedFolder(newDirectory.toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void setApplicationRequired(boolean required) {
        super.setApplicationRequired(required);
        this.getModel().setApplicationRequired(required);
        if (!required) {
            required = this.getModel().isRequired();
        }
        this.setRequired(required);
    }

    public void setRequired(boolean required) {
        super.setRequired(required);
        if (this.getFileTextField() != null && this.getStyle().isEditable()) {
            if (this.getStyle().getBackgroundColor() != null) {
                this.getFileTextField().setBackground(this.getStyle().getBackgroundColor());
            } else if (required) {
                if (this.getStyle().isApplicationRequired()) {
                    this.getFileTextField().setBackground(this.getModel().getDOM().getApplicationFieldColor());
                } else {
                    this.getFileTextField().setBackground(this.getModel().getDOM().getSchemaRequiredFieldColor());
                }
            } else {
                this.getFileTextField().setBackground(this.getModel().getDOM().getOptionalFieldColor());
            }
        }
    }

    protected void setFileTextField(JTextField _fileTextField) {
        this._fileTextField = _fileTextField;
    }

    protected JTextField getFileTextField() {
        if (this._fileTextField == null) {
            this._fileTextField = new JTextField();
            this._fileTextField.addFocusListener(this);
            this._fileTextField.setColumns(1);
        }
        return this._fileTextField;
    }
}

