/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.swing.ui.beans.JDayChooser;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class JMonthChooser
extends JComboBox
implements ItemListener {
    private Locale _locale;
    private int _month;
    private JDayChooser _dayChooser;
    private boolean _initialized = false;

    public JMonthChooser() {
        this.addItemListener(this);
        this._dayChooser = null;
        this._locale = Locale.getDefault();
        this.initNames();
        this.setMonth(Calendar.getInstance().get(2));
        this._initialized = true;
    }

    public Locale getLocale() {
        return this._locale;
    }

    public int getMonth() {
        return this._month;
    }

    public void initNames() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this._locale);
        String[] monthNames = dateFormatSymbols.getMonths();
        if (this.getItemCount() == 12) {
            this.removeAllItems();
        }
        for (int i = 0; i < 12; ++i) {
            this.addItem(monthNames[i]);
        }
        this.setSelectedIndex(this._month);
    }

    public void itemStateChanged(ItemEvent iEvt) {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            this.setMonth(index, false);
        }
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("MonthChooser");
        frame.getContentPane().add(new JMonthChooser());
        frame.pack();
        frame.setVisible(true);
    }

    public void setDayChooser(JDayChooser dayChooser) {
        this._dayChooser = dayChooser;
    }

    public void setLocale(Locale l) {
        if (!this._initialized) {
            super.setLocale(l);
        } else {
            this._locale = l;
            this.initNames();
        }
    }

    public void setMonth(int newMonth) {
        this.setMonth(newMonth, true);
    }

    private void setMonth(int newMonth, boolean select) {
        int oldMonth = this._month;
        this._month = newMonth;
        if (select) {
            this.setSelectedIndex(this._month);
        }
        if (this._dayChooser != null) {
            this._dayChooser.setMonth(this._month);
        }
        this.firePropertyChange("month", oldMonth, this._month);
    }
}

