/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JSpinField
extends JPanel
implements CaretListener,
AdjustmentListener,
ActionListener {
    private JTextField _textField;
    private JScrollBar _scrollBar;
    private Color _darkGreen = new Color(0, 150, 0);
    private int _min = 0;
    private int _max = 100;
    private int _value = 0;

    public JSpinField() {
        this.setLayout(new BorderLayout());
        this._textField = new JTextField(Integer.toString(this._value));
        this._textField.addCaretListener(this);
        this._textField.addActionListener(this);
        this.add((Component)this._textField, "Center");
        this._scrollBar = new JScrollBar(1, 0, 0, 0, 100);
        this._scrollBar.setPreferredSize(new Dimension(this._scrollBar.getPreferredSize().width, this._textField.getPreferredSize().height));
        this._scrollBar.setMinimum(this._min);
        this._scrollBar.setMaximum(this._max);
        this._scrollBar.setValue(this._max + this._min - this._value);
        this._scrollBar.setVisibleAmount(0);
        this._scrollBar.addAdjustmentListener(this);
        this.add((Component)this._scrollBar, "East");
    }

    public void actionPerformed(ActionEvent e) {
        if (this._textField.getForeground().equals(this._darkGreen)) {
            this.setValue(Integer.valueOf(this._textField.getText()));
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.setValue(this._max + this._min - e.getValue(), true, false);
    }

    public void caretUpdate(CaretEvent e) {
        block4: {
            try {
                int testValue = Integer.valueOf(this._textField.getText());
                if (testValue >= this._min && testValue <= this._max) {
                    this._textField.setForeground(this._darkGreen);
                    this.setValue(testValue, false, false);
                } else {
                    this._textField.setForeground(Color.red);
                }
            }
            catch (Exception ex) {
                if (!(ex instanceof NumberFormatException)) break block4;
                this._textField.setForeground(Color.red);
            }
        }
        this._textField.repaint();
    }

    public int getMaximum() {
        return this._max;
    }

    public int getMinimum() {
        return this._min;
    }

    public int getValue() {
        return this._value;
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("JSpinField");
        frame.getContentPane().add(new JSpinField());
        frame.pack();
        frame.setVisible(true);
    }

    public void setFont(Font font) {
        if (this._textField != null) {
            this._textField.setFont(font);
        }
    }

    public void setForeground(Color fg) {
        if (this._textField != null) {
            this._textField.setForeground(fg);
        }
    }

    public void setMaximum(int newMaximum) {
        this._max = newMaximum;
        this._scrollBar.setMaximum(this._max);
    }

    public void setMinimum(int newMinimum) {
        this._min = newMinimum;
        this._scrollBar.setMinimum(this._min);
    }

    public void setValue(int newValue) {
        this.setValue(newValue, true, true);
    }

    protected void setValue(int newValue, boolean updateTextField, boolean updateScrollbar) {
        int oldValue = this._value;
        this._value = newValue < this._min ? this._min : (newValue > this._max ? this._max : newValue);
        if (updateTextField) {
            this._textField.setText(Integer.toString(this._value));
            this._textField.setForeground(Color.black);
        }
        if (updateScrollbar) {
            this._scrollBar.setValue(this._max + this._min - this._value);
        }
        this.firePropertyChange("value", oldValue, this._value);
    }
}

