/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.type.ListModificationException;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.MethodParameter;
import com.jaxfront.core.type.SimpleGroup;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.xui.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ParamVisualizer
extends JPanel
implements PropertyChangeListener {
    private JComponent _editor;
    private ListType _type;
    private Method _method;
    private boolean _bindModelData = false;
    private Hashtable _params;

    public ParamVisualizer(ListType type, Method method, int actionIndex, boolean bindModelData) {
        this._type = type;
        this._method = method;
        this._bindModelData = bindModelData;
        this.init();
    }

    private void addNewParamTypes() {
        int listSize = this._type.getList().size();
        String[] modelValues = null;
        if (this._bindModelData && listSize > 0) {
            modelValues = new String[listSize];
            for (int a = 0; a < listSize; ++a) {
                String value;
                Type simpleGroup = (Type)this._type.getList().get(a);
                TypeVisualizerFactory.getInstance().releaseCache(simpleGroup);
                modelValues[a] = value = simpleGroup.getDirectChildValue("value");
            }
        }
        try {
            this._type.removeAll();
        }
        catch (ListModificationException e) {
            e.printStackTrace();
        }
        Class<?>[] parameterTypes = this._method.getParameterTypes();
        int paramLength = parameterTypes.length;
        for (int i = 0; i < paramLength; ++i) {
            SimpleType nlsType;
            String typeParameter = MethodParameter.convertParameterClassToExternal((String)MethodParameter.removePackages((String)parameterTypes[i].getName()));
            Type param = this._type.addNewChild();
            param.setDirectChildValue("name", "param (" + i + ")");
            param.setDirectChildValue("type", typeParameter);
            if (this._bindModelData && modelValues != null && i < modelValues.length) {
                param.setDirectChildValue("value", modelValues[i]);
            } else {
                param.setDirectChildValue("value", null);
            }
            if (typeParameter.equals("String")) {
                String nlsValue;
                nlsType = (SimpleType)param.getMixedContent();
                nlsType.setSerializable(false);
                NLS nls = (NLS)nlsType.getDOM().getClientProperty("NLS");
                if (nls != null && (nlsValue = nls.get(NLS.createParamNLSKey((Type)nlsType))) != null) {
                    nlsType.setValue(nlsValue);
                }
                this.getParams().put(nlsType, nlsType);
                nlsType.getPropertyChangeSupport().addPropertyChangeListener(this);
                continue;
            }
            nlsType = (SimpleType)param.getMixedContent();
            nlsType.setEnabled(false);
        }
    }

    private Hashtable getParams() {
        if (this._params == null) {
            this._params = new Hashtable();
        }
        return this._params;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.renameMethodNameType();
        this.addNewParamTypes();
        this.typeMapping();
        TypeVisualizerFactory.getInstance().releaseCache((Type)this._type);
        this._editor = (JComponent)TypeVisualizerFactory.getInstance().getVisualizer((Type)this._type);
        this._editor.setVisible(true);
        this.add((Component)this._editor, "Center");
    }

    private void renameMethodNameType() {
        Type uiActionType = this._type.getParent();
        uiActionType.setDirectChildValue("methodName", this._method.getName());
    }

    private void typeMapping() {
        Vector paramList = (Vector)this._type.getList();
        for (int i = 0; i < paramList.size(); ++i) {
            Type param = (Type)paramList.get(i);
            param.getDirectChild("type").getXUIDefinition().getStyle().setEnabled(false);
            SimpleType type = (SimpleType)param.getDirectChild("type");
            SimpleType value = (SimpleType)param.getDirectChild("value");
            value.getXUIDefinition().getStyle().setLabelColumnWidth(0.0f);
            value.getXUIDefinition().getStyle().setComponentColumnWidth(-1.0f);
            if (type.getValue().equals("Boolean")) {
                value.actAsBoolean();
                continue;
            }
            if (type.getValue().equals("boolean")) {
                value.actAsBoolean();
                continue;
            }
            if (type.getValue().equals("int")) {
                value.actAsInt();
                continue;
            }
            if (type.getValue().equals("Integer")) {
                value.actAsInteger();
                continue;
            }
            if (type.getValue().equals("String")) {
                value.actAsString();
                continue;
            }
            if (type.getValue().equals("Color")) {
                value.actAsColor();
                continue;
            }
            if (type.getValue().equals("Visualizer")) {
                value.actAsVisualizer();
                continue;
            }
            if (!type.getValue().equals("Type")) continue;
            value.actAsVisualizer();
        }
    }

    public static String createMethodSignature(Type methodType) {
        String methodName = methodType.getDirectChildValue("methodName");
        ListType parameterList = (ListType)methodType.getChild("param");
        StringBuffer description = new StringBuffer();
        Iterator paramList = parameterList.getList().iterator();
        while (paramList.hasNext()) {
            SimpleGroup param = (SimpleGroup)paramList.next();
            SimpleType type = (SimpleType)param.getDirectChild("type");
            description.append(type.getValue());
        }
        return description.toString();
    }

    public static String createMethodSignature(String methodDefinition) {
        StringBuffer description = new StringBuffer();
        int firstIndex = methodDefinition.indexOf("(") + 1;
        int lastIndex = methodDefinition.lastIndexOf(")");
        if (lastIndex < 0) {
            lastIndex = methodDefinition.length();
        }
        String paramDef = methodDefinition.substring(firstIndex, lastIndex);
        StringTokenizer tokenizer = new StringTokenizer(paramDef, ", ");
        while (tokenizer.hasMoreTokens()) {
            description.append(tokenizer.nextToken());
            tokenizer.nextToken();
        }
        return description.toString();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getParams().get(event.getSource()) != null) {
            SimpleType nlsType = (SimpleType)event.getSource();
            String nlsValue = nlsType.getValue();
            NLS nls = (NLS)nlsType.getDOM().getClientProperty("NLS");
            if (nls != null && nlsValue != null && nlsValue.length() > 0) {
                nls.put((Object)NLS.createParamNLSKey((Type)nlsType), (Object)nlsValue);
            }
        }
    }
}

