/*
 * Decompiled with CFR 0.152.
 */
package com.jaxfront.swing.ui.beans;

import com.jaxfront.core.rule.FormulaExpression;
import com.jaxfront.core.type.ListType;
import com.jaxfront.core.type.SimpleType;
import com.jaxfront.core.type.Type;
import com.jaxfront.core.ui.FlipOrientationTableModel;
import com.jaxfront.core.ui.SimpleTypeVisualizer;
import com.jaxfront.core.ui.TypeVisualizerFactory;
import com.jaxfront.core.ui.Visualizer;
import com.jaxfront.core.ui.tableModel.ListTypeTableModel;
import com.jaxfront.core.util.GUIComponentNLS;
import com.jaxfront.core.util.JAXFrontProperties;
import com.jaxfront.core.xui.ColumnInfo;
import com.jaxfront.core.xui.TableInfo;
import com.jaxfront.swing.ui.tools.FontFactory;
import com.jaxfront.swing.ui.tools.MultiLineTextWraper;
import com.jaxfront.swing.ui.tools.TableSorter;
import com.jaxfront.swing.ui.visualizers.AbstractSimpleTypeView;
import com.jaxfront.swing.ui.visualizers.ContextView;
import com.jaxfront.swing.ui.wrapper.JAXJTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ZebraCellRenderer
extends JLabel
implements TableCellRenderer {
    private static JTextField _staticTextField;
    private double _zebraFactor = 0.9;
    private boolean _useZebraLook = true;
    private Color _zebraColor = null;
    private Color _selectorColor = null;
    private Font _tableFont = FontFactory.getTableFontDefinition().createFont();

    public ZebraCellRenderer() {
        this(0.9);
    }

    public ZebraCellRenderer(boolean useZebraLook) {
        this(0.9);
        this._useZebraLook = useZebraLook;
    }

    public ZebraCellRenderer(double zebraFactor) {
        this.setOpaque(true);
        this._zebraFactor = zebraFactor;
    }

    public ZebraCellRenderer(Color selectorColor) {
        this.setOpaque(true);
        this._selectorColor = selectorColor;
    }

    protected Color getSelectorColor() {
        return this._selectorColor;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean editableCell = false;
        JComponent renderer = this;
        Type typeModel = ZebraCellRenderer.getListItemType(row, column, table);
        if (typeModel != null && typeModel.getClientProperty("listItem-disabled") != null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
        if (value != null) {
            String stringValue;
            if (value instanceof String) {
                String stringValue2 = (String)value;
                this.setText(" " + stringValue2);
                this.setIcon(null);
            } else if (value instanceof Boolean) {
                Boolean booleanValue = (Boolean)value;
                stringValue = "";
                stringValue = booleanValue != false ? GUIComponentNLS.getInstance().getNLSText((String)table.getClientProperty("language"), "button_yes", "Yes") : GUIComponentNLS.getInstance().getNLSText((String)table.getClientProperty("language"), "button_no", "No");
                this.setText(" " + stringValue);
                this.setIcon(null);
            } else if (value instanceof Object[]) {
                Object[] valueWithIcon = (Object[])value;
                this.setText(String.valueOf(valueWithIcon[0]));
                this.setIcon(JAXFrontProperties.getImageIcon((String)String.valueOf(valueWithIcon[1])));
            } else if (value instanceof ListType) {
                ListType listType = (ListType)value;
                ListType keyList = listType.getParent().getParentList();
                if (keyList != null && keyList.isKey()) {
                    Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer((Type)listType, false);
                    if (!(visualizer instanceof ContextView)) {
                        TypeVisualizerFactory.getInstance().releaseCache((Type)listType);
                        visualizer = null;
                    }
                    if (visualizer == null) {
                        boolean allowContextNavigation = true;
                        FormulaExpression contextFormEx = null;
                        int index = 0;
                        index = ((TableSorter)table.getModel()).isFlipped() ? row : column;
                        TableInfo klTabInfo = keyList.getStyle().getTableInfo();
                        ColumnInfo klLInfo = null;
                        if (klTabInfo != null && (klLInfo = klTabInfo.getLineInfo(index)) != null) {
                            allowContextNavigation = klLInfo.allowContextNavigation();
                            contextFormEx = klLInfo.getContextFormulaExpression();
                        }
                        visualizer = new ContextView(allowContextNavigation, contextFormEx);
                        visualizer.setModel((Type)listType);
                        TypeVisualizerFactory.getInstance().cacheVisualizer((Type)listType, visualizer);
                    }
                    visualizer.populateView();
                    renderer = (JComponent)visualizer;
                }
            } else if (value instanceof SimpleType) {
                if (((SimpleType)value).getXUIDefinition().getStyle().isUsingPlugIn()) {
                    Visualizer view = TypeVisualizerFactory.getInstance().getVisualizer((Type)value, (Type)((Type)value).getParentList());
                    view.populateView();
                    renderer = view instanceof AbstractSimpleTypeView ? ((SimpleTypeVisualizer)view).getEditorComponent() : (JComponent)view;
                } else {
                    SimpleType type = (SimpleType)value;
                    stringValue = type.getValue();
                    boolean editorVisibleAlways = false;
                    TableInfo tableInfo = type.getParentList().getStyle().getTableInfo();
                    if (tableInfo != null && !tableInfo.isUsingDefaultRendering()) {
                        int columnIndex = column;
                        try {
                            TableSorter tableSorter = (TableSorter)table.getModel();
                            FlipOrientationTableModel tableModel = (FlipOrientationTableModel)tableSorter.getModel();
                            if (tableModel.isFlipped()) {
                                columnIndex = row;
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        editorVisibleAlways = tableInfo.getLineInfo(columnIndex).isEditorAlwaysVisible();
                    }
                    if (editorVisibleAlways) {
                        Visualizer visualizer = TypeVisualizerFactory.getInstance().getVisualizer((Type)type, (Type)type.getParentList());
                        renderer = (JComponent)visualizer;
                        if (visualizer != null && visualizer instanceof AbstractSimpleTypeView) {
                            renderer = !type.isColor() && !type.isDate() ? ((SimpleTypeVisualizer)visualizer).getEditorField() : ((AbstractSimpleTypeView)visualizer).getEditorComponent();
                            if (type.isString() || type.isNumber()) {
                                editableCell = true;
                            }
                            renderer.setVisible(true);
                        }
                    } else {
                        editableCell = true;
                        if (type.isBoolean()) {
                            Boolean booleanValue = Boolean.valueOf(stringValue);
                            stringValue = booleanValue != false ? GUIComponentNLS.getInstance().getNLSText((String)table.getClientProperty("language"), "button_yes", "Yes") : GUIComponentNLS.getInstance().getNLSText((String)table.getClientProperty("language"), "button_no", "No");
                        }
                        this.setText(stringValue);
                    }
                }
            } else {
                this.setText(value.toString());
                this.setIcon(null);
            }
        }
        if (this._selectorColor == null) {
            this._selectorColor = table.getSelectionBackground();
        }
        if (isSelected) {
            renderer.setBackground(this.getSelectorColor());
            renderer.setForeground(table.getSelectionForeground());
        } else {
            Color background = table.getBackground();
            if (this._useZebraLook && row % 2 != 0) {
                background = this.getZebraColor(background);
            }
            renderer.setBackground(background);
            renderer.setForeground(table.getForeground());
        }
        if (hasFocus) {
            renderer.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                renderer.setForeground(UIManager.getColor("Table.focusCellForeground"));
                renderer.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            renderer.setBorder(null);
        }
        try {
            TableSorter tableSorter = (TableSorter)table.getModel();
            FlipOrientationTableModel tableModel = (FlipOrientationTableModel)tableSorter.getModel();
            int lineInfoindex = column;
            int typeIndex = row;
            if (tableModel.isFlipped()) {
                lineInfoindex = row;
                typeIndex = column;
            }
            ColumnInfo aLineInfo = tableModel.getTableInfo().getLineInfo(lineInfoindex);
            Dimension prefSize = this.getPreferredSize();
            if (aLineInfo.getLineWidth() >= 0) {
                prefSize.width = aLineInfo.getLineWidth();
                this.setPreferredSize(prefSize);
            } else {
                this.setPreferredSize(null);
            }
            String toolTip = aLineInfo.getToolTip((Type)tableModel.getListType().getList().get(typeIndex));
            if (toolTip != null && toolTip.length() > 0 && !toolTip.equalsIgnoreCase("NULL")) {
                FontMetrics fm = this.getFontMetrics(UIManager.getFont("ToolTip.font"));
                toolTip = "<html><body><p>" + MultiLineTextWraper.wrapText(toolTip, fm, 200, null, true) + "</p></body></html>";
                renderer.setToolTipText(toolTip);
            } else {
                renderer.setToolTipText(null);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        renderer.setFont(this._tableFont);
        if (editableCell) {
            renderer.setBorder(this.getStaticTextField().getBorder());
        }
        return renderer;
    }

    private JTextField getStaticTextField() {
        if (_staticTextField == null) {
            _staticTextField = new JTextField();
        }
        return _staticTextField;
    }

    protected Color getZebraColor(Color background) {
        if (this._zebraColor == null) {
            this._zebraColor = new Color(Math.max((int)((double)background.getRed() * this.getZebraFactor()), 0), Math.max((int)((double)background.getGreen() * this.getZebraFactor()), 0), Math.max((int)((double)background.getBlue() * this.getZebraFactor()), 0));
        }
        return this._zebraColor;
    }

    private double getZebraFactor() {
        return this._zebraFactor;
    }

    public static Type getListItemType(int row, int col, JTable table) {
        JAXJTable jaxTable;
        ListType list;
        Type type = null;
        if (table.getModel() instanceof TableSorter) {
            try {
                TableSorter sorter = (TableSorter)table.getModel();
                type = (Type)sorter.getListType().getList().get(sorter.getOriginalRowIndex(row));
            }
            catch (Throwable t) {}
        } else if (table instanceof JAXJTable && (list = (ListType)(jaxTable = (JAXJTable)table).getBaseType()) != null) {
            type = (Type)list.getList().get(ListTypeTableModel.evaluateParentTableRowIndex((TableModel)table.getModel(), (int)(jaxTable.isFlipped() ? col : row)));
        }
        return type;
    }
}

